<?php

include '../security/secure.php';

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MDJ</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Press+Start+2P&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Press Start 2P', cursive;
            background: #1a1a1a;
            color: #ffffff;
            overflow-x: hidden;
        }
        
        .hero {
            height: 100vh;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('cover-font.png');
            background-size: cover;
            background-position: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: relative;
            padding: 0 20px;
        }
        
        .hero h1 {
            font-size: 3rem;
            color: #ffffff;
            text-shadow: 4px 4px 0px #000000;
            margin-bottom: 30px;
            line-height: 1.2;
        }
        
        .hero p {
            font-size: 1rem;
            max-width: 600px;
            line-height: 1.8;
            color: #ffffff;
            text-shadow: 2px 2px 0px #000000;
        }
        
        .info-section {
            background: #1a1a1a;
            padding: 60px 80px;
        }
        
        .info-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .separator {
            height: 4px;
            background: #373737;
            margin: 40px 0;
            position: relative;
        }
        
        .separator:before {
            content: '';
            position: absolute;
            top: -2px;
            left: 0;
            right: 0;
            height: 2px;
            background: #FFFFFF;
        }
        
        .info-box {
            background: #2a2a2a;
            border: 4px solid;
            border-color: #FFFFFF #373737 #373737 #FFFFFF;
            padding: 30px;
            margin-bottom: 40px;
        }
        
        .info-box h2 {
            font-size: 1.2rem;
            color: #FFFFFF;
            text-shadow: 2px 2px 0px #000000;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .requirements {
            background: #5C8A5C;
            border-color: #A0FFA0 #2E4A2E #2E4A2E #A0FFA0;
        }
        
        .requirements h2 {
            color: #A0FFA0;
        }
        
        .instructions {
            background: #8B5A2B;
            border-color: #FFBF7F #4A2E1A #4A2E1A #FFBF7F;
        }
        
        .instructions h2 {
            color: #FFBF7F;
        }
        
        .features {
            background: #4A4A8B;
            border-color: #7F7FFF #1A1A4A #1A1A4A #7F7FFF;
        }
        
        .features h2 {
            color: #7F7FFF;
        }
        
        .req-list, .inst-list, .feat-list {
            list-style: none;
            font-size: 0.8rem;
            line-height: 1.6;
        }
        
        .req-list li, .inst-list li, .feat-list li {
            margin-bottom: 8px;
            padding-left: 20px;
            position: relative;
        }
        
        .req-list li:before {
            content: '▪';
            position: absolute;
            left: 0;
            color: #A0FFA0;
        }
        
        .inst-list li:before {
            content: '►';
            position: absolute;
            left: 0;
            color: #FFBF7F;
        }
        
        .feat-list li:before {
            content: '◆';
            position: absolute;
            left: 0;
            color: #7F7FFF;
        }
        
        .credits {
            margin-top: 30px;
            font-size: 0.6rem;
            line-height: 1.8;
            color: #8B8B8B;
            text-shadow: 1px 1px 0px #000000;
        }
        
        .credits p {
            margin-bottom: 8px;
        }
        
        .footer {
            background: #000000;
            padding: 40px 80px 120px 80px;
            border-top: 4px solid #373737;
        }
        
        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
            text-align: center;
        }
        
        .footer h3 {
            font-size: 1rem;
            margin-bottom: 20px;
            color: #FFFFFF;
            text-shadow: 2px 2px 0px #000000;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            gap: 30px;
            flex-wrap: wrap;
        }
        
        .footer-link {
            color: #FFFFFF;
            text-decoration: none;
            font-size: 0.7rem;
            padding: 10px 15px;
            background: #373737;
            border: 2px solid;
            border-color: #FFFFFF #000000 #000000 #FFFFFF;
            transition: none;
        }
        
        .footer-link:hover {
            background: #FFFFA0;
            color: #000000;
            border-color: #000000 #FFFFFF #FFFFFF #000000;
        }
        
        .bottom-bar {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 80px;
            background: #000000;
            display: flex;
            justify-content: space-between;
            align-items: center;
            z-index: 1000;
            padding: 0 50px;
        }
        
        .music-control {
            display: flex;
            align-items: center;
        }
        
        .buttons-container {
            display: flex;
            gap: 20px;
        }
        
        .minecraft-btn {
            background: #8B8B8B;
            border: 4px solid;
            border-color: #FFFFFF #373737 #373737 #FFFFFF;
            color: #FFFFFF;
            font-family: 'Press Start 2P', cursive;
            font-size: 12px;
            padding: 16px 24px;
            cursor: pointer;
            text-shadow: 2px 2px 0px #000000;
            transition: none;
            text-decoration: none;
            display: inline-block;
            image-rendering: pixelated;
        }
        
        .minecraft-btn:hover {
            background: #FFFFA0;
            color: #000000;
            text-shadow: none;
        }
        
        .minecraft-btn:active {
            border-color: #373737 #FFFFFF #FFFFFF #373737;
            background: #6B6B6B;
            color: #FFFFFF;
            text-shadow: 2px 2px 0px #000000;
        }
        
        .btn-primary {
            background: #5C8A5C;
            border-color: #A0FFA0 #2E4A2E #2E4A2E #A0FFA0;
        }
        
        .btn-primary:hover {
            background: #7FFF7F;
            color: #000000;
        }
        
        .btn-primary:active {
            border-color: #2E4A2E #A0FFA0 #A0FFA0 #2E4A2E;
            background: #3A5A3A;
            color: #FFFFFF;
        }
        
        .music-btn {
            background: #8B8B8B;
            border: 4px solid;
            border-color: #FFFFFF #373737 #373737 #FFFFFF;
            color: #FFFFFF;
            font-family: 'Press Start 2P', cursive;
            font-size: 16px;
            padding: 12px 16px;
            cursor: pointer;
            text-shadow: 2px 2px 0px #000000;
            transition: none;
            image-rendering: pixelated;
            width: 60px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .music-btn:hover {
            background: #FFFFA0;
            color: #000000;
            text-shadow: none;
        }
        
        .music-btn:active {
            border-color: #373737 #FFFFFF #FFFFFF #373737;
            background: #6B6B6B;
            color: #FFFFFF;
            text-shadow: 2px 2px 0px #000000;
        }
        
        .video-container {
            position: fixed;
            bottom: 90px;
            right: 20px;
            width: 320px;
            height: 220px;
            background: #000000;
            border: 4px solid;
            border-color: #FFFFFF #373737 #373737 #FFFFFF;
            z-index: 999;
        }
        
        .video-title {
            background: #000000;
            color: #FFFFFF;
            font-family: 'Press Start 2P', cursive;
            font-size: 10px;
            padding: 8px;
            text-align: center;
            border-bottom: 2px solid #373737;
            text-shadow: 1px 1px 0px #000000;
        }
        
        .video-container video {
            width: 100%;
            height: calc(100% - 32px);
            object-fit: cover;
        }
        
        .mobile-video-thumbnail {
            display: none;
            position: fixed;
            bottom: 90px;
            right: 10px;
            width: 80px;
            height: 60px;
            background: #000000;
            border: 3px solid #FFFFFF;
            cursor: pointer;
            z-index: 1001;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: #FFFFFF;
        }
        
        @media (max-width: 768px) {
            .hero {
                padding: 20px;
                padding-bottom: 100px;
            }
            
            .hero h1 {
                font-size: 2rem;
            }
            
            .info-section {
                padding: 40px 20px;
            }
            
            .footer {
                padding: 30px 20px 100px 20px;
            }
            
            .footer-links {
                gap: 15px;
            }
            
            .bottom-bar {
                padding: 0 20px;
                height: 80px;
            }
            
            .video-container {
                display: none;
            }
            
            .mobile-video-thumbnail {
                display: flex;
            }
        }
    </style>
</head>
<body>
    <audio id="backgroundMusic" loop>
        <source src="song.mp4" type="audio/mp4">
    </audio>
    
    <audio id="clickSound" preload="auto">
        <source src="click.mp4" type="audio/mp4">
    </audio>
    
    <audio id="playSound" preload="auto">
        <source src="play.mp4" type="audio/mp4">
    </audio>
    
    <section class="hero">
        <h1>Minecrfat Dungeons,<br>dans la Java Edition</h1>
        <p>Découvrez MDJ, une version modifié de l'édtion Minecraft Java, avec les fonctionnalitées de Minecraft Dungeons, sur ordinateur.</p>
    </section>
    
    <div class="info-section">
        <div class="info-container">
            <div class="info-box requirements">
                <h2>CONFIGURATION REQUISE</h2>
                <ul class="req-list">
                    <li>Java 17 ou supérieur</li>
                    <li>Minecraft Java Edition 1.20.1</li>
                    <li>4 GB de RAM minimum</li>
                    <li>2 GB d'espace libre</li>
                    <li>Forge 47.2.0 ou supérieur</li>
                </ul>
            </div>
            
            <div class="separator"></div>
            
            <div class="info-box features">
                <h2>NOUVELLES FONCTIONNALITÉS PAR RAPPORT A LA VERSION JAVA</h2>
                <ul class="feat-list">
                    <li>Système de séléction</li>
                    <li>Jouabilité à la troisième personne</li>
                    <li>Menu de personnalisation et d'édition</li>
                </ul>
            </div>
            
            <div class="separator"></div>
            
            <div class="info-box instructions">
                <h2>INSTRUCTIONS D'INSTALLATION</h2>
                <ul class="inst-list">
                    <li>Téléchargez et installez Minecraft Forge</li>
                    <li>Lancez Minecraft avec le profil Forge</li>
                    <li>Fermez Minecraft complètement</li>
                    <li>Téléchargez le mod MDJ depuis notre site</li>
                    <li>Placez le fichier .jar dans le dossier mods</li>
                    <li>Relancez Minecraft avec Forge</li>
                    <li>Créez un nouveau monde et amusez-vous !</li>
                </ul>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <div class="footer-content">
            <h3>LIENS UTILES</h3>
            <div class="footer-links">
                <a href="/documentation" class="footer-link">DOCUMENTATION</a>
                <a href="/support" class="footer-link">SUPPORT</a>
                <a href="/github" class="footer-link">GITHUB</a>
                <a href="/changelog" class="footer-link">CHANGELOG</a>
                <a href="/wiki" class="footer-link">WIKI</a>
                <a href="/community" class="footer-link">COMMUNAUTÉ</a>
            </div>
            <div class="separator"></div>
            <div class="credits">
                <p>MDJ - Minecraft Dungeons Java</p>
                <p>Un projet crée par Revo</p>
                <p>A website made <a href="https://forchange.me" class="underline">forchange</a></p>
                <p>© 2025 MDJ. Under the (type) licence. All right reserved</p>
            </div>
        </div>
    </footer>
    
    <div class="video-container">
        <div class="video-title">GAMEPLAY TRAILER</div>
        <video id="gameVideo" autoplay muted loop>
            <source src="gameplay.mp4" type="video/mp4">
        </video>
    </div>
    
    <div class="mobile-video-thumbnail" id="mobileVideoThumbnail">▶</div>
    
    <div class="bottom-bar">
        <div class="music-control">
            <button id="musicToggle" class="music-btn">⏸</button>
        </div>
        <div class="buttons-container">
            <a href="/download" class="minecraft-btn btn-primary">INSTALLER</a>
            <a href="/discord" class="minecraft-btn">DISCORD</a>
        </div>
    </div>
    
    <script>
        const audio = document.getElementById('backgroundMusic');
        const toggleBtn = document.getElementById('musicToggle');
        const clickSound = document.getElementById('clickSound');
        const playSound = document.getElementById('playSound');
        const gameVideo = document.getElementById('gameVideo');
        const videoContainer = document.querySelector('.video-container');
        const mobileVideoThumbnail = document.getElementById('mobileVideoThumbnail');
        let isPlaying = false;
        let videoExpanded = false;
        
        audio.volume = 0.3;
        clickSound.volume = 0.5;
        playSound.volume = 0.7;
        
        function playClickSound() {
            clickSound.currentTime = 0;
            clickSound.play().catch(e => console.log('Son bloqué'));
        }
        
        function playPlaySound() {
            playSound.currentTime = 0;
            playSound.play().catch(e => console.log('Son bloqué'));
        }
        
        function startMusic() {
            audio.play().then(() => {
                isPlaying = true;
                toggleBtn.textContent = '⏸';
            }).catch(e => {
                console.log('Autoplay bloqué');
            });
        }
        
        document.addEventListener('click', function() {
            if (!isPlaying) {
                startMusic();
            }
        }, { once: true });
        
        toggleBtn.addEventListener('click', function() {
            playClickSound();
            if (isPlaying) {
                audio.pause();
                toggleBtn.textContent = '▶';
                isPlaying = false;
            } else {
                audio.play().then(() => {
                    toggleBtn.textContent = '⏸';
                    isPlaying = true;
                });
            }
        });
        
        document.querySelectorAll('.minecraft-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                playClickSound();
            });
        });
        
        mobileVideoThumbnail.addEventListener('click', function() {
            playClickSound();
            videoExpanded = !videoExpanded;
            if (videoExpanded) {
                videoContainer.style.display = 'block';
                mobileVideoThumbnail.textContent = '✕';
            } else {
                videoContainer.style.display = 'none';
                mobileVideoThumbnail.textContent = '▶';
            }
        });
        
        document.querySelectorAll('.footer-link').forEach(link => {
            link.addEventListener('click', function() {
                playClickSound();
            });
        });
        
        gameVideo.addEventListener('play', function() {
            playPlaySound();
        });
        
        audio.addEventListener('ended', function() {
            audio.currentTime = 0;
            audio.play();
        });
    </script>
</body>
</html>