<?php
session_start();
require_once 'db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$profiles = [];

try {
    if (empty($search)) {
        $stmt = $pdo->query("SELECT p.id, p.name, p.description, p.profile_image, p.created_at, u.username as created_by 
                            FROM profiles p 
                            JOIN users u ON p.created_by = u.id 
                            ORDER BY p.created_at DESC 
                            LIMIT 20");
    } else {
        $stmt = $pdo->prepare("SELECT p.id, p.name, p.description, p.profile_image, p.created_at, u.username as created_by 
                              FROM profiles p 
                              JOIN users u ON p.created_by = u.id 
                              WHERE p.name LIKE ? OR p.description LIKE ? 
                              ORDER BY p.created_at DESC");
        $stmt->execute(["%$search%", "%$search%"]);
    }
    
    $profiles = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = "Database error: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Library - Peerkinton</title>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        jost: ['Jost', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Jost', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50 text-black font-jost">
    <div class="min-h-screen flex flex-col">
        <header class="bg-white py-4 px-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h1 class="text-2xl font-light">Peerkinton</h1>
                <div class="flex items-center space-x-4">
                    <span><?php echo htmlspecialchars($user['username']); ?></span>
                    <a href="logout.php" class="text-sm text-gray-600">Logout</a>
                </div>
            </div>
        </header>
        
        <nav class="bg-white py-3 px-6 border-b border-gray-200">
            <div class="flex space-x-6">
                <a href="dashboard.php" class="text-gray-500 hover:text-gray-800">Map</a>
                <span class="text-gray-800 font-medium">Library</span>
                <a href="create-profile.php" class="text-gray-500 hover:text-gray-800">Create Profile</a>
                <a href="dashboard.php?tab=settings" class="text-gray-500 hover:text-gray-800">Settings</a>
            </div>
        </nav>
        
        <main class="flex-1 p-6">
            <div class="mb-6">
                <h2 class="text-2xl font-medium mb-4">Profile Library</h2>
                
                <form method="GET" class="mb-6">
                    <div class="flex w-full max-w-md">
                        <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                            class="flex-1 px-4 py-2 border border-gray-300 focus:outline-none" 
                            placeholder="Search profiles...">
                        <button type="submit" class="bg-black text-white px-4 py-2">Search</button>
                    </div>
                </form>
                
                <?php if (isset($error)): ?>
                <div class="bg-red-100 text-red-800 p-4 mb-4">
                    <?php echo $error; ?>
                </div>
                <?php endif; ?>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach ($profiles as $profile): ?>
                    <div class="bg-white border border-gray-200 rounded-lg overflow-hidden">
                        <div class="h-48 bg-gray-200 relative">
                            <?php if (!empty($profile['profile_image'])): ?>
                            <img src="<?php echo htmlspecialchars($profile['profile_image']); ?>" 
                                alt="<?php echo htmlspecialchars($profile['name']); ?>" 
                                class="w-full h-full object-cover">
                            <?php else: ?>
                            <div class="flex items-center justify-center h-full bg-gray-100 text-gray-500">
                                No image
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="p-4">
                            <h3 class="text-xl font-medium mb-1"><?php echo htmlspecialchars($profile['name']); ?></h3>
                            <p class="text-gray-500 text-sm mb-2">Added by <?php echo htmlspecialchars($profile['created_by']); ?></p>
                            
                            <p class="text-gray-700 mb-4 line-clamp-3">
                                <?php echo htmlspecialchars(substr($profile['description'], 0, 150)); ?>
                                <?php if (strlen($profile['description']) > 150): ?>...<?php endif; ?>
                            </p>
                            
                            <div class="flex justify-between items-center">
                                <a href="view-profile.php?id=<?php echo $profile['id']; ?>" class="text-black font-medium">View Details</a>
                                <span class="text-xs text-gray-500">
                                    <?php echo date('M j, Y', strtotime($profile['created_at'])); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    
                    <?php if (empty($profiles)): ?>
                    <div class="col-span-full text-center py-12">
                        <p class="text-gray-500">No profiles found</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>