<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="vérifié">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <!-- End Google Tag Manager -->
    
    <!-- HTML Meta Tags -->
    <title>Imators</title>
    <meta name="description" content="Imators est une entreprise technologique fondée au début de l'année 2024 par Izhak Aktas. Notre objectif est de jeter les bases de la deuxième phase technologique que le monde va connaître. Cela se fera petit à petit, pour que vous puissiez en profiter.">

    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="site web">
    <meta property="og:title" content="Imateurs">
    <meta property="og:description" content="Imators est une entreprise technologique fondée au début de l'année 2024 par Izhak Aktas. Notre objectif est de jeter les bases de la deuxième phase technologique que le monde va connaître. Cela se fera petit à petit, pour que vous puissiez en profiter.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="résumé_grande_image">
    <meta property="twitter:domain" content="imators.com">
    <meta property="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imateurs">
    <meta name="twitter:description" content="Imators est une entreprise technologique fondée au début de l'année 2024 par Izhak Aktas. Notre objectif est de jeter les bases de la deuxième phase technologique que le monde va connaître. Cela se fera petit à petit, pour que vous puissiez en profiter.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-out forwards;
        }

        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        

        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }


        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }

    </style>
</head>
<body class="bg-black">
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MNDDTWSM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    
    <?php include 'src/header.php'; ?>

<div id="slider" class="w-full min-h-screen">
   <div class="container relative mx-auto pt-32 pb-24 px-8">
       
       <!-- Loading Spinner -->
       <div id="loader" class="absolute inset-0 bg-black z-50 flex items-center justify-center">
           <div class="loader-spin"></div>
       </div>

       <!-- Slides Container -->
       <div class="slides-container h-[750px] relative">

           <!-- Academ -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-purple-500 text-sm font-semibold tracking-[0.2em] uppercase">Version application et plus disponible le 15 Février 2025</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">Academ</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">Trouvez un tuteur fiable à 99%, pour aider votre enfant de manière progressive et positive avec une personne de confiance.</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <a href="https://academ.my" class="inline-flex items-center gap-2 border border-purple-500/20 text-purple-500 hover:bg-purple-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">Accéder à la démo</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="./design45.webp" class="w-full h-full object-cover scale-110" alt="Academ">
                   </div>
               </div>
           </div>
           
                      <!-- Something -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-white text-sm font-semibold tracking-[0.2em] uppercase">Disponible le 18 février 2025</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">Something</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">Permettre à chaque club d'être accessible aux parents, aux organisateurs et aux enfants au même endroit</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <a href="/waitlist" class="inline-flex items-center gap-2 border border-white text-white px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">S'inscrire sur la liste d'attente</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="something_cube.webp" class="w-full h-full object-cover scale-110" alt="Quelque chose">
                   </div>
               </div>
           </div>


           <!-- OhMyPanel -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-indigo-500 text-sm font-semibold tracking-[0.2em] uppercase">Bientôt disponible</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">OhMyPanel</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">Une chose qui pourrait révolutionner le commerce pour toujours</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <button class="group inline-flex items-center gap-2 bg-indigo-500/50 px-8 py-4 rounded-xl text-white font-medium transition-all cursor-not-allowed opacity-75">
                               <span>Bientôt disponible</span>
                           </button>
                           <a href="/waitlist" class="inline-flex items-center gap-2 border border-indigo-500/20 text-indigo-500 hover:bg-indigo-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">S'inscrire sur la liste d'attente</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="design3.png" class="w-full h-full object-cover scale-110" alt="OhMyPanel">
                   </div>
               </div>
           </div>
       </div>

       <!-- Navigation -->
       <div class="flex gap-4 mt-12">
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="0"></button>
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="1"></button>
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="2"></button>
       </div>

       <!-- Arrows -->
       <button id="prevSlide" class="absolute top-1/2 -translate-y-1/2 -left-16 p-2 text-white/50 hover:text-white transition-all hover:scale-110">
           <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
               <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
           </svg>
       </button>
       <button id="nextSlide" class="absolute top-1/2 -translate-y-1/2 -right-16 p-2 text-white/50 hover:text-white transition-all hover:scale-110">
           <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
               <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
           </svg>
       </button>
   </div>
</div>



<style>
.loader-spin {
   width: 48px;
   height: 48px;
   border: 5px solid #fff;
   border-bottom-color: transparent;
   border-radius: 50%;
   animation: rotation 1s linear infinite;
}

@keyframes rotation {
   0% { transform: rotate(0deg) }
   100% { transform: rotate(360deg) }
}

.slide {
   opacity: 0;
   visibility: hidden;
   transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active {
   opacity: 1;
   visibility: visible;
   z-index: 1;
}

.slide-content > * {
   opacity: 0;
   transform: translateY(20px);
   transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active .slide-content > * {
   opacity: 1;
   transform: translateY(0);
}

.slide.active .slide-content > *:nth-child(1) { transition-delay: 200ms; }
.slide.active .slide-content > *:nth-child(2) { transition-delay: 300ms; }
.slide.active .slide-content > *:nth-child(3) { transition-delay: 400ms; }
.slide.active .slide-content > *:nth-child(4) { transition-delay: 500ms; }

.slide img {
   transform: scale(1.1);
   transition: transform 1.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active img {
   transform: scale(1);
}

@media (max-width: 1024px) {
   .slides-container {
       height: auto;
       min-height: 600px;
   }
   
   #prevSlide, #nextSlide {
       display: none;
   }
}
</style>

<script>
const slider = {
   container: document.querySelector('#slider'),
   slides: document.querySelectorAll('.slide'),
   dots: document.querySelectorAll('[data-slide]'),
   prevBtn: document.getElementById('prevSlide'),
   nextBtn: document.getElementById('nextSlide'),
   loader: document.getElementById('loader'),
   currentSlide: 0,
   isAnimating: false,
   autoplayInterval: null,

   init() {
       // Wait for images to load
       Promise.all(Array.from(document.images).map(img => {
           if (img.complete) return Promise.resolve();
           return new Promise(resolve => img.addEventListener('load', resolve));
       })).then(() => {
           this.loader.style.display = 'none';
           this.showSlide(0);
           this.bindEvents();
           this.startAutoplay();
       });
   },

   showSlide(index) {
       if (this.isAnimating) return;
       this.isAnimating = true;

       this.slides[this.currentSlide]?.classList.remove('active');
       this.dots[this.currentSlide]?.classList.remove('bg-white');

       this.currentSlide = index;
       
       this.slides[this.currentSlide].classList.add('active');
       this.dots[this.currentSlide].classList.add('bg-white');

       setTimeout(() => {
           this.isAnimating = false;
       }, 600);
   },

   next() {
       const nextIndex = (this.currentSlide + 1) % this.slides.length;
       this.showSlide(nextIndex);
   },

   prev() {
       const prevIndex = (this.currentSlide - 1 + this.slides.length) % this.slides.length;
       this.showSlide(prevIndex);
   },

   startAutoplay() {
       this.autoplayInterval = setInterval(() => this.next(), 5000);
   },

   stopAutoplay() {
       if (this.autoplayInterval) {
           clearInterval(this.autoplayInterval);
           this.autoplayInterval = null;
       }
   },

   bindEvents() {
       this.dots.forEach((dot, index) => {
           dot.addEventListener('click', () => {
               this.stopAutoplay();
               this.showSlide(index);
               this.startAutoplay();
           });
       });

       this.prevBtn?.addEventListener('click', () => {
           this.stopAutoplay();
           this.prev();
           this.startAutoplay();
       });

       this.nextBtn?.addEventListener('click', () => {
           this.stopAutoplay();
           this.next();
           this.startAutoplay();
       });

       document.addEventListener('keydown', (e) => {
           if (e.key === 'ArrowRight') {
               this.stopAutoplay();
               this.next();
               this.startAutoplay();
           }
           if (e.key === 'ArrowLeft') {
               this.stopAutoplay();
               this.prev();
               this.startAutoplay();
           }
       });

       let touchStartX = 0;
       this.container.addEventListener('touchstart', e => {
           touchStartX = e.changedTouches[0].screenX;
       });

       this.container.addEventListener('touchend', e => {
           const touchEndX = e.changedTouches[0].screenX;
           const diff = touchStartX - touchEndX;

           if (Math.abs(diff) > 50) {
               this.stopAutoplay();
               if (diff > 0) this.next();
               else this.prev();
               this.startAutoplay();
           }
       });

       this.slides.forEach(slide => {
           slide.addEventListener('mouseenter', () => this.stopAutoplay());
           slide.addEventListener('mouseleave', () => this.startAutoplay());
       });

       document.addEventListener('visibilitychange', () => {
           if (document.hidden) this.stopAutoplay();
           else this.startAutoplay();
       });
   }
};

window.addEventListener('load', () => slider.init());
</script>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Suivez-nous</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Découvrir</h5>
                <a href="/fr/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Politique de confidentialité</a>
                <a href="/fr/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Conditions d'utilisation</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Accueil</a>
                <a href="/fr/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">À propos de nous</a>
                <a href="/fr/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Nous contacter</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Réalité possible</h5>
                <p class="text-sm">Toutes les images, les vidéos et le contenu de ce site sont la propriété d'Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2024 Imators. Tous droits réservés.</p>
            <p class="text-xs">Imators est une société à responsabilité limitée (LLC). Tous nos produits, qu'ils soient technologiquement physiques ou simplement en ligne, sont soumis à nos règles, auxquelles vous pouvez accéder.</p>
        </div>
    </footer>
  

</body>
</html>