<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ads - AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">Advertising Across Our Sites</h1>
            <p class="text-sm">This page is associated with our websites which have the label "publicité" (in French "publicitée", ..) marked next to the content in question.</p>
        </header>

        <main>
            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Overview</h2>
                <p class="mb-6">
                    Our sites are fortunate enough to carry advertising from various brands and companies. These advertisements have different purposes and enable the site in question to add a touch of local or well-known content to the recurring visitors it identifies.</p>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Type of advertising category</h2>
                <ul class="space-y-4">
                    <li>- Partner brand linked to a contract with aktascorp</li>
                    <li>- Partner brand not bound by a contract with aktascorp (These partners therefore benefit from free space without anything in return. However, the brand may assert at any time that it has given its oral authorization in accordance with current legislation).</li>
                    <li>- Local business, promoted only for the purpose of promotion. (Brand images from their site are used and copied onto ours. This type of advertising is intended to promote the brand because it is present in the surrounding area, if the site communicates a place, a town, a region,... The brand can ask aktascorp at any time to remove the content on the grounds of image rights, even if no violation of the penal code is involved here.)</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Contact</h2>
                <p>
                    For advertising inquiries, please contact our team at we@aktascorp.com
                </p>
            </section>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>