<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        
        .gradient-background {
            background: rgb(34,193,195);
            background: linear-gradient(0deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
            color: #FFFFFF;
        }

        header {
            background-color: rgba(0, 0, 0, 0.8); 
            transition: background-color 0.5s;
        }
        .menu-link {
            transition: color 0.3s ease-in-out;
            color: #FFF !important; 
        }
        .footer, .mobile-menu {
            background-color: #111827;
            color: #FFF;
        }

        .category-card {
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .category-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        
        .contact-method {
            display: none;
        }
        
        .contact-method.active {
            display: block;
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .form-input {
            background-color: #1a1a1a;
            border: 1px solid #333;
            color: white;
        }
        
        .form-input:focus {
            border-color: rgba(167,45,253,1);
            outline: none;
        }

        .text-gradient {
            background: linear-gradient(90deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>
<body class="bg-black text-white">
    <!-- Header would be included here -->
    <?php include 'src/header.php'; ?>

    <!-- Hero Section -->
    <section class="py-20">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto text-center mb-16">
                <h1 class="text-4xl lg:text-5xl font-bold mb-6">How can we help you?</h1>
                <p class="text-xl text-gray-400">Select a category below to find the right support channel for your needs.</p>
            </div>
        </div>
    </section>

    <!-- Categories Section -->
    <section class="py-12">
        <div class="container px-4 mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-5xl mx-auto">
                <!-- Technical Support -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('technical')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-blue-500 to-purple-600 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Technical Support</h3>
                    <p class="text-gray-400">Having issues with our products or services? Our technical team is ready to help.</p>
                </div>
                
                <!-- Account & Billing -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('billing')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-green-400 to-blue-500 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Account & Billing</h3>
                    <p class="text-gray-400">Questions about your account, subscriptions, or payments? We're here to assist.</p>
                </div>
                
                <!-- Business Inquiries -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('business')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-purple-500 to-pink-500 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Business Inquiries</h3>
                    <p class="text-gray-400">Interested in working with us or discussing a partnership? Get in touch.</p>
                </div>
                
                <!-- Feedback & Suggestions -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('feedback')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-yellow-400 to-orange-500 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Feedback & Suggestions</h3>
                    <p class="text-gray-400">We value your input. Share your thoughts and ideas to help us improve.</p>
                </div>
                
                <!-- Press & Media -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('press')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-red-500 to-purple-500 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Press & Media</h3>
                    <p class="text-gray-400">Media inquiries, interview requests, or press materials? Contact our PR team.</p>
                </div>
                
                <!-- Other -->
                <div class="category-card bg-gray-900 rounded-xl p-8 text-center" onclick="showContactMethod('other')">
                    <div class="w-16 h-16 mx-auto mb-6 flex items-center justify-center bg-gradient-to-r from-indigo-500 to-blue-500 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Other Inquiries</h3>
                    <p class="text-gray-400">Have a question that doesn't fit the categories above? We're still happy to help.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Methods Section -->
    <section class="py-16 contact-methods">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto">
                <!-- Technical Support Contact Method -->
                <div id="technical" class="contact-method bg-gray-900 p-8 rounded-2xl">
                    <h2 class="text-3xl font-bold mb-6 text-gradient">Technical Support</h2>
                    <p class="text-gray-300 mb-8">Our technical support team is available to assist you with any issues you may be experiencing with our products or services.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Email Support</h3>
                            <p class="text-gray-400 mb-4">Send us a detailed description of your issue and we'll get back to you within 24 hours.</p>
                            <a href="mailto:support@imators.com" class="text-blue-400 hover:text-blue-300 font-medium">support@imators.com</a>
                        </div>
                        
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Live Chat</h3>
                            <p class="text-gray-400 mb-4">Get immediate assistance through our live chat system, available Monday to Friday, 9 AM - 6 PM GMT.</p>
                            <button class="bg-gradient-to-r from-blue-500 to-purple-600 text-white px-4 py-2 rounded-lg font-medium hover:opacity-90 transition-opacity">Start Chat</button>
                        </div>
                    </div>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">Submit a Support Ticket</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="subject" class="block text-sm font-medium text-gray-400 mb-2">Subject</label>
                            <input type="text" id="subject" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Brief description of your issue">
                        </div>
                        
                        <div class="mb-6">
                            <label for="description" class="block text-sm font-medium text-gray-400 mb-2">Detailed Description</label>
                            <textarea id="description" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please provide as much detail as possible about your issue"></textarea>
                        </div>
                        
                        <div class="mb-8">
                            <label for="attachments" class="block text-sm font-medium text-gray-400 mb-2">Attachments (Optional)</label>
                            <input type="file" id="attachments" class="w-full px-4 py-2 rounded-lg bg-gray-800 text-gray-300">
                            <p class="text-xs text-gray-500 mt-1">You can upload screenshots or other files that might help us understand your issue better.</p>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Ticket</button>
                    </form>
                </div>
                
                <!-- Account & Billing Contact Method -->
                <div id="billing" class="contact-method bg-gray-900 p-8 rounded-2xl">
                    <h2 class="text-3xl font-bold mb-6 text-gradient">Account & Billing Support</h2>
                    <p class="text-gray-300 mb-8">Our account and billing team is here to assist you with any questions related to your account, subscriptions, or payments.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Email Support</h3>
                            <p class="text-gray-400 mb-4">For account or billing inquiries, please email us with your account details.</p>
                            <a href="mailto:billing@imators.com" class="text-blue-400 hover:text-blue-300 font-medium">billing@imators.com</a>
                        </div>
                        
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Phone Support</h3>
                            <p class="text-gray-400 mb-4">Speak directly with our billing team, available Monday to Friday, 9 AM - 5 PM GMT.</p>
                            <a href="tel:+442012345678" class="text-blue-400 hover:text-blue-300 font-medium">+44 20 1234 5678</a>
                        </div>
                    </div>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">Billing Inquiry Form</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="billing-name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="billing-name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="billing-email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="billing-email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="account-id" class="block text-sm font-medium text-gray-400 mb-2">Account ID (if applicable)</label>
                            <input type="text" id="account-id" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your account ID">
                        </div>
                        
                        <div class="mb-6">
                            <label for="inquiry-type" class="block text-sm font-medium text-gray-400 mb-2">Inquiry Type</label>
                            <select id="inquiry-type" class="w-full px-4 py-2 rounded-lg form-input">
                                <option value="">Select an option</option>
                                <option value="subscription">Subscription Issue</option>
                                <option value="payment">Payment Problem</option>
                                <option value="refund">Refund Request</option>
                                <option value="account">Account Access</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        
                        <div class="mb-6">
                            <label for="billing-description" class="block text-sm font-medium text-gray-400 mb-2">Message Details</label>
                            <textarea id="billing-description" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please provide details of your billing inquiry"></textarea>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-green-400 to-blue-500 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Inquiry</button>
                    </form>
                </div>
                
                <!-- Business Inquiries Contact Method -->
                <div id="business" class="contact-method bg-gray-900 p-8 rounded-2xl">
                    <h2 class="text-3xl font-bold mb-6 text-gradient">Business Inquiries</h2>
                    <p class="text-gray-300 mb-8">Interested in working with Imators or discussing potential partnerships? Our business development team is ready to connect.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Email</h3>
                            <p class="text-gray-400 mb-4">For business development and partnership opportunities.</p>
                            <a href="mailto:business@imators.com" class="text-blue-400 hover:text-blue-300 font-medium">business@imators.com</a>
                        </div>
                        
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Schedule a Meeting</h3>
                            <p class="text-gray-400 mb-4">Book a virtual meeting with our business development team.</p>
                            <button class="bg-gradient-to-r from-purple-500 to-pink-500 text-white px-4 py-2 rounded-lg font-medium hover:opacity-90 transition-opacity">Schedule Now</button>
                        </div>
                    </div>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">Business Inquiry Form</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="business-name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="business-name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="business-email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="business-email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="company" class="block text-sm font-medium text-gray-400 mb-2">Company</label>
                                <input type="text" id="company" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your company name">
                            </div>
                            
                            <div>
                                <label for="position" class="block text-sm font-medium text-gray-400 mb-2">Position</label>
                                <input type="text" id="position" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your role at the company">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="inquiry-nature" class="block text-sm font-medium text-gray-400 mb-2">Nature of Inquiry</label>
                            <select id="inquiry-nature" class="w-full px-4 py-2 rounded-lg form-input">
                                <option value="">Select an option</option>
                                <option value="partnership">Partnership Opportunity</option>
                                <option value="investment">Investment Interest</option>
                                <option value="enterprise">Enterprise Solution</option>
                                <option value="collaboration">Collaboration Project</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        
                        <div class="mb-6">
                            <label for="business-message" class="block text-sm font-medium text-gray-400 mb-2">Message</label>
                            <textarea id="business-message" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please provide details of your business inquiry"></textarea>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-purple-500 to-pink-500 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Inquiry</button>
                    </form>
                </div>
                
                <!-- Feedback Contact Method -->
                <div id="feedback" class="contact-method bg-gray-900 p-8 rounded-2xl">
                    <h2 class="text-3xl font-bold mb-6 text-gradient">Feedback & Suggestions</h2>
                    <p class="text-gray-300 mb-8">We value your input. Share your thoughts, ideas, and suggestions to help us improve our products and services.</p>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">Feedback Form</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="feedback-name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="feedback-name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="feedback-email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="feedback-email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="feedback-type" class="block text-sm font-medium text-gray-400 mb-2">Feedback Type</label>
                            <select id="feedback-type" class="w-full px-4 py-2 rounded-lg form-input">
                                <option value="">Select an option</option>
                                <option value="product">Product Feedback</option>
                                <option value="website">Website Feedback</option>
                                <option value="service">Service Feedback</option>
                                <option value="suggestion">Feature Suggestion</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                        
                        <div class="mb-6">
                            <label for="feedback-message" class="block text-sm font-medium text-gray-400 mb-2">Your Feedback</label>
                            <textarea id="feedback-message" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please share your thoughts, ideas, or suggestions"></textarea>
                        </div>
                        
                        <div class="mb-6">
                            <label class="flex items-center">
                                <input type="checkbox" class="form-checkbox h-5 w-5 text-blue-600">
                                <span class="ml-2 text-sm text-gray-400">I'm willing to be contacted about my feedback if needed</span>
                            </label>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-yellow-400 to-orange-500 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Feedback</button>
                    </form>
                </div>
                
                <!-- Press Contact Method -->
                <div id="press" class="contact-method bg-gray-900 p-8 rounded-2xl">
                <h2 class="text-3xl font-bold mb-6 text-gradient">Press & Media</h2>
                    <p class="text-gray-300 mb-8">For media inquiries, interview requests, or press materials, our PR team is available to assist you.</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Press Contact</h3>
                            <p class="text-gray-400 mb-4">For press inquiries and interview requests.</p>
                            <a href="mailto:press@imators.com" class="text-blue-400 hover:text-blue-300 font-medium">press@imators.com</a>
                        </div>
                        
                        <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                            <h3 class="text-xl font-semibold mb-4">Press Kit</h3>
                            <p class="text-gray-400 mb-4">Download our press kit for logos, images, and company information.</p>
                            <button class="bg-gradient-to-r from-red-500 to-purple-500 text-white px-4 py-2 rounded-lg font-medium hover:opacity-90 transition-opacity">Download Press Kit</button>
                        </div>
                    </div>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">Media Inquiry Form</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="press-name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="press-name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="press-email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="press-email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="media-outlet" class="block text-sm font-medium text-gray-400 mb-2">Media Outlet</label>
                                <input type="text" id="media-outlet" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your media outlet">
                            </div>
                            
                            <div>
                                <label for="deadline" class="block text-sm font-medium text-gray-400 mb-2">Deadline (if applicable)</label>
                                <input type="date" id="deadline" class="w-full px-4 py-2 rounded-lg form-input">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="inquiry-details" class="block text-sm font-medium text-gray-400 mb-2">Inquiry Details</label>
                            <textarea id="inquiry-details" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please provide details of your media inquiry, including any specific questions or interview requests"></textarea>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-red-500 to-purple-500 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Inquiry</button>
                    </form>
                </div>
                
                <!-- Other Contact Method -->
                <div id="other" class="contact-method bg-gray-900 p-8 rounded-2xl">
                    <h2 class="text-3xl font-bold mb-6 text-gradient">Other Inquiries</h2>
                    <p class="text-gray-300 mb-8">Have a question that doesn't fit into the categories above? We're still here to help.</p>
                    
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl mb-8">
                        <h3 class="text-xl font-semibold mb-4">General Contact</h3>
                        <p class="text-gray-400 mb-4">For any other inquiries, please email us at:</p>
                        <a href="mailto:hello@imators.com" class="text-blue-400 hover:text-blue-300 font-medium">hello@imators.com</a>
                    </div>
                    
                    <form class="bg-black bg-opacity-50 p-8 rounded-xl">
                        <h3 class="text-xl font-semibold mb-6">General Inquiry Form</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="other-name" class="block text-sm font-medium text-gray-400 mb-2">Full Name</label>
                                <input type="text" id="other-name" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Your name">
                            </div>
                            
                            <div>
                                <label for="other-email" class="block text-sm font-medium text-gray-400 mb-2">Email Address</label>
                                <input type="email" id="other-email" class="w-full px-4 py-2 rounded-lg form-input" placeholder="your.email@example.com">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label for="subject-line" class="block text-sm font-medium text-gray-400 mb-2">Subject</label>
                            <input type="text" id="subject-line" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Subject of your inquiry">
                        </div>
                        
                        <div class="mb-6">
                            <label for="other-message" class="block text-sm font-medium text-gray-400 mb-2">Message</label>
                            <textarea id="other-message" rows="5" class="w-full px-4 py-2 rounded-lg form-input" placeholder="Please provide details of your inquiry"></textarea>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-indigo-500 to-blue-500 text-white px-6 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity">Submit Inquiry</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-16 bg-gray-900 rounded-t-3xl">
        <div class="container px-4 mx-auto">
            <div class="max-w-3xl mx-auto">
                <h2 class="text-3xl font-bold mb-12 text-center">Frequently Asked Questions</h2>
                
                <div class="space-y-6">
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                        <h3 class="text-xl font-semibold mb-3">What are your support hours?</h3>
                        <p class="text-gray-400">Our support team is available Monday to Friday, 9 AM - 6 PM GMT. For urgent issues outside of these hours, please email us, and we'll respond as soon as possible.</p>
                    </div>
                    
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                        <h3 class="text-xl font-semibold mb-3">How quickly can I expect a response?</h3>
                        <p class="text-gray-400">We aim to respond to all inquiries within 24 hours during business days. For technical support tickets, our average response time is 4-6 hours.</p>
                    </div>
                    
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                        <h3 class="text-xl font-semibold mb-3">Do you offer phone support?</h3>
                        <p class="text-gray-400">We offer phone support for account and billing inquiries. For technical issues, we provide support via email, live chat, and our ticketing system to ensure we can properly track and resolve your issue.</p>
                    </div>
                    
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                        <h3 class="text-xl font-semibold mb-3">How do I request a refund?</h3>
                        <p class="text-gray-400">Refund requests should be submitted through our Account & Billing support channel. Please include your order number and reason for requesting a refund. Our team will review your request according to our refund policy.</p>
                    </div>
                    
                    <div class="bg-black bg-opacity-50 p-6 rounded-xl">
                        <h3 class="text-xl font-semibold mb-3">Can I change my subscription plan?</h3>
                        <p class="text-gray-400">Yes, you can change your subscription plan at any time through your account settings. If you need assistance, please contact our billing team.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/itsimators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        // Function to show the selected contact method
        function showContactMethod(methodId) {
            // Hide all contact methods
            const contactMethods = document.querySelectorAll('.contact-method');
            contactMethods.forEach(method => {
                method.classList.remove('active');
            });
            
            // Show the selected contact method
            const selectedMethod = document.getElementById(methodId);
            if (selectedMethod) {
                selectedMethod.classList.add('active');
                
                // Smooth scroll to the contact method
                selectedMethod.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        }
        
        // Initialize with no contact method shown
        document.addEventListener('DOMContentLoaded', function() {
            // Add fade-in animation to elements when page loads
            const fadeElements = document.querySelectorAll('.category-card');
            fadeElements.forEach((el, index) => {
                setTimeout(() => {
                    el.style.opacity = '0';
                    el.style.transform = 'translateY(20px)';
                    setTimeout(() => {
                        el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                        el.style.opacity = '1';
                        el.style.transform = 'translateY(0)';
                    }, 100 * index);
                }, 100);
            });
        });
        
        // Mobile menu functionality
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>