<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About - Peerkinton</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://api.fontshare.com/v2/css?f[]=satoshi@400,500,700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Satoshi', sans-serif;
            background: #fafafa;
        }
    </style>
</head>
<body class="h-full">
    <?php include 'header.php'; ?>

    <main class="pt-32 pb-16 px-6">
        <div class="max-w-3xl mx-auto">
            <h1 class="text-4xl font-bold mb-8">About Peerkinton</h1>
            
            <div class="bg-white rounded-xl p-8 mb-12 border border-gray-100">
                <p class="text-lg text-gray-700 mb-8">
                Peerkinton was founded in England in March 2016. The aim in creating Peerkinton was to create an institution dedicated to technological learning and study by offering our members high-end digital access. Our institute collects data and profiles from our students and allows them to publish it, work on it, and show human knowledge.
Since our establishment, we have grown into a thriving community of tech enthusiasts and innovators. Our unique approach combines cutting-edge digital resources with hands-on learning experiences. This methodology has proven successful in developing well-rounded technology professionals who understand both theoretical foundations and practical applications.
At Peerkinton, we believe that data is the cornerstone of modern education. By collecting and analyzing student data, we create personalized learning paths that adapt to individual needs and aspirations. Our platform serves as a hub where students can showcase their work, collaborate on projects, and contribute to the ever-growing body of technological knowledge.
The digital access we provide goes beyond traditional educational resources. Our members benefit from state-of-the-art tools, comprehensive databases, and advanced analytics platforms. This technological infrastructure enables our students to explore complex concepts, conduct sophisticated analyses, and develop innovative solutions to real-world challenges.
We are committed to providing the best possible education to our students and to helping them achieve their full potential. Through continuous improvement of our systems and methodologies, we ensure that our members stay at the forefront of technological advancement. Our dedication to excellence extends to every aspect of our institution, from our curriculum design to our student support services.
As we look to the future, Peerkinton continues to evolve, embracing new technologies and methodologies while staying true to our founding principles of accessibility, innovation, and excellence in technological education.
                </p>
                
                <blockquote class="border-l-4 border-gray-900 pl-4 italic">
                    <p class="text-xl text-gray-800">"A child's education does not define who they are. Here we give a place to the person that people don't notice"</p>
                </blockquote>
            </div>
        </div>
    </main>
</body>
</html>