<?php
session_start();
require 'db.php';

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

function sendVerificationCode($email, $code) {
    $to = $email;
    $subject = 'Imators Account Security';
    $message = '<html><body style="background-color:#181818; color:#c9d1d9; font-family: Arial, sans-serif; margin:0; padding:0;">';
    $message .= '<table role="presentation" style="width:100%; border-collapse:collapse; margin:0 auto; max-width:600px;">';
    
    // Header
    $message .= '<tr><td style="background:#0d1117; padding:20px 0; text-align:center;">';
    $message .= '<img src="https://cdn.imators.com/logo.png" alt="Imators Logo" style="height:50px;">';
    $message .= '</td></tr>';
    
    // Title
    $message .= '<tr><td style="padding:40px 20px; text-align:center; background-color:#21262d;">';
    $message .= '<h1 style="color:#f0f6fc; font-size:28px; font-weight:bold; margin-bottom:20px;">Imators Account</h1>';
    
    // Content
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">To ensure secure access to your Imators account, you will be given a verification code to enable you to connect to it using end-to-end encryption. This code is as follows : <strong>' . $code . '</strong></p>';
    $message .= '</td></tr>';
    
    // Footer
    $message .= '<tr><td style="padding:20px; text-align:center; background-color:#0d1117; color:#ffffff; font-size:16px;">';
    $message .= '<p>&copy; ' . date("Y") . ' Imators LLC. All rights reserved.</p>';
    $message .= '</td></tr>';
    
    $message .= '</table>';
    $message .= '</body></html>';

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: Imators <no-reply@imators.com>' . "\r\n";

    mail($to, $subject, $message, $headers);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];
    $ip = getUserIP();

    // Prparez la requte SQL pour vrifier l'utilisateur dans la base de donnes
    $sql = "SELECT id, password, email FROM utilisateurs WHERE email = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        // Grer l'erreur de prparation de requte
        echo "Erreur de prparation de requte: " . $conn->error;
        exit();
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows == 0) {
        // Aucun utilisateur trouv avec cet email
        $_SESSION['login_error'] = 'No user found with that email address.';
        header("Location: /");
        exit();
    }

    $stmt->bind_result($id, $hashed_password, $user_email);
    $stmt->fetch();

    if (password_verify($password, $hashed_password)) {
        // Les informations d'identification sont correctes, gnrer et envoyer un code de vrification
        $verification_code = rand(100000, 999999); // Gnre un code  6 chiffres
        $_SESSION['verification_code'] = $verification_code;
        $_SESSION['user_id'] = $id;
        $_SESSION['user_email'] = $user_email;
        
        // Envoyer le code de vrification  l'utilisateur par email
        sendVerificationCode($user_email, $verification_code);

        // Rediriger vers la page de vrification du code
        header("Location: verify_code.php");
        exit(); // Important pour empcher l'excution du code suivant
    } else {
        // Le mot de passe ne correspond pas, retour  la page de connexion avec un message d'erreur
        $_SESSION['login_error'] = 'Invalid email or password. Please try again.';
        header("Location: /");
        exit();
    }

    $stmt->close();
}
$conn->close();
?>