<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Code - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300..900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .bg-pattern {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100' viewBox='0 0 100 100'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath opacity='.5' d='M96 95h4v1h-4v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9zm-1 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9z'/%3E%3Cpath d='M6 5V0H5v5H0v1h5v94h1V6h94V5H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }
        @keyframes fadeOut {
            from { opacity: 1; }
            to { opacity: 0; }
        }
        .fade-out {
            animation: fadeOut 1s ease-out forwards;
        }
    </style>
</head>

<body class="bg-black text-white min-h-screen flex flex-col">
    <?php
    // CSRF token implementation
    $token = bin2hex(random_bytes(32));

    session_start();

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $entered_code = $_POST['verification_code'];

        if ($entered_code == $_SESSION['verification_code']) {
            unset($_SESSION['verification_code']); // Supprimer le code de la session
            header("Location: dashboard.php");
            exit();
        } else {
            $error = "Invalid verification code. Please try again.";
        }
    }
    ?>

    <div class="flex-grow flex">
        <!-- Left side: Logo and decorative content -->
        <div class="hidden lg:flex lg:w-1/2 bg-pattern bg-black items-center justify-center p-12">
            <div class="max-w-md text-center">
                <div class="w-32 h-32 mx-auto mb-8 rounded-full bg-cover bg-center" style="background-image: url('https://cdn.imators.com/logo.png');"></div>
                <h1 class="text-4xl font-bold mb-4">Secure Verification</h1>
                <p class="text-xl text-gray-400">Protecting your account with an extra layer of security.</p>
            </div>
        </div>

        <!-- Right side: Verification form -->
        <div class="w-full lg:w-1/2 flex items-center justify-center p-8">
            <div class="max-w-md w-full space-y-8">
                <div>
                    <div class="w-24 h-24 mx-auto mb-4 lg:hidden rounded-full bg-cover bg-center" style="background-image: url('https://cdn.imators.com/logo.png');"></div>
                    <h2 class="mt-6 text-center text-3xl font-extrabold">Verify Your Code</h2>
                    <p class="mt-2 text-center text-sm text-gray-400">
                        Please enter the verification code sent to your email. This code is used to verify your identity and ensure the security of your account.
                    </p>
                </div>

                <form class="mt-8 space-y-6" method="post">
                    <input type="hidden" name="csrf_token" value="<?php echo $token; ?>">
                    <div>
                        <label for="verification_code" class="sr-only">Verification Code</label>
                        <input id="verification_code" name="verification_code" type="text" required 
                               class="appearance-none rounded-md relative block w-full px-3 py-2 border border-gray-700 placeholder-gray-500 text-white focus:outline-none focus:ring-2 focus:ring-white focus:border-white focus:z-10 sm:text-sm bg-gray-900" 
                               placeholder="Enter verification code"
                               pattern="\d*" inputmode="numeric" maxlength="6">
                    </div>

                    <div>
                        <button type="submit" 
                                class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-black bg-white hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-white transition-all duration-300 ease-in-out transform hover:scale-105">
                            Verify
                        </button>
                    </div>
                </form>

                <?php if (isset($error)): ?>
                    <p class="text-red-500 text-center"><?php echo $error; ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div id="footer-popup" class="fixed bottom-4 left-1/2 transform -translate-x-1/2 bg-gray-900 text-gray-200 rounded-full shadow-lg flex items-center justify-center p-2 cursor-pointer hover:bg-gray-800 transition-colors">
        <div class="w-6 h-6 mr-2 rounded-full bg-cover bg-center" style="background-image: url('https://cdn.imators.com/logo.png');"></div>
        <span class="text-sm font-medium">Powered by Imators System</span>
    </div>

    <script>
        // Restrict input to numbers only
        document.getElementById('verification_code').addEventListener('input', function (e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });

        // Footer popup animation
        setTimeout(() => {
            const popup = document.getElementById('footer-popup');
            popup.classList.add('fade-out');
            setTimeout(() => {
                popup.style.display = 'none';
            }, 1000);
        }, 4000);
    </script>
</body>
</html>