<?php
session_start();
$success = false;
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    require_once 'db.php';
    
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if (!empty($email) && !empty($password)) {
        $stmt = $conn->prepare("SELECT * FROM utilisateurs WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['USER-INFO-ACCOUNT'] = [
                    'id' => $user['id'],
                    'email' => $user['email'],
                ];
                $success = true;
                $message = 'Connexion russie !';
            } else {
                $message = 'Identifiants incorrects';
            }
        } else {
            $message = 'Identifiants incorrects';
        }
        $stmt->close();
    } else {
        $message = 'Veuillez remplir tous les champs';
    }
    $conn->close();

    if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
        echo json_encode(['success' => $success, 'message' => $message]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion Imators</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .bg-blur { backdrop-filter: blur(8px); }
        .transition-transform { transition: transform 0.3s ease-in-out; }
        .scale-0 { transform: scale(0); }
        .scale-100 { transform: scale(1); }
    </style>
</head>
<body class="bg-black text-white min-h-screen flex items-center justify-center p-4">
    <div class="bg-gray-900 p-8 rounded-2xl shadow-2xl w-full max-w-6xl flex overflow-hidden">
        <div class="w-1/2 pr-8 flex flex-col justify-center">
            <h1 class="text-4xl font-bold mb-8 text-blue-400">Connexion Imators</h1>
            <form id="loginForm" class="space-y-6">
                <div>
                    <label for="email" class="block text-sm font-medium mb-2 text-gray-300">Adresse e-mail</label>
                    <input type="email" id="email" name="email" required class="w-full bg-gray-800 border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-blue-500 text-white">
                </div>
                <div>
                    <label for="password" class="block text-sm font-medium mb-2 text-gray-300">Mot de passe</label>
                    <input type="password" id="password" name="password" required class="w-full bg-gray-800 border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-blue-500 text-white">
                </div>
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50">
                    Vrifier
                </button>
            </form>
        </div>
        <div class="w-1/2 flex items-center justify-center">
            <img src="chemin/vers/votre/logo.png" alt="Logo Imators" class="max-w-full max-h-80 object-contain">
        </div>
    </div>

    <!-- Overlay de succs -->
    <div id="successOverlay" class="fixed inset-0 bg-black bg-opacity-70 bg-blur flex items-center justify-center hidden">
        <div class="bg-gray-800 text-white p-8 rounded-2xl shadow-2xl text-center max-w-md w-full transition-transform scale-0">
            <h2 class="text-3xl font-bold mb-4 text-blue-400">Connexion russie !</h2>
            <p class="mb-6 text-gray-300">Vous tes maintenant connect  votre compte Imators.</p>
            <button onclick="hideOverlay()" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50">
                Fermer
            </button>
        </div>
    </div>

    <script>
    document.getElementById('loginForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData(this);
        
        fetch('', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showOverlay();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Une erreur est survenue. Veuillez ressayer.');
        });
    });

    function showOverlay() {
        const overlay = document.getElementById('successOverlay');
        const content = overlay.querySelector('div');
        overlay.classList.remove('hidden');
        setTimeout(() => {
            content.classList.remove('scale-0');
            content.classList.add('scale-100');
        }, 10);
    }

    function hideOverlay() {
        const overlay = document.getElementById('successOverlay');
        const content = overlay.querySelector('div');
        content.classList.remove('scale-100');
        content.classList.add('scale-0');
        setTimeout(() => {
            overlay.classList.add('hidden');
        }, 300);
    }
    </script>
</body>
</html>