<?php
session_start();

if (!isset($_SESSION['antivirus_data'])) {
    $_SESSION['antivirus_data'] = [
        'last_scan' => date('d/m/Y H:i', strtotime('-2 days')),
        'threats_found' => 0,
        'files_scanned' => 45872,
        'quarantine' => [
            ['file' => 'C:\\Windows\\Temp\\tmp3f8a.exe', 'threat' => 'Trojan.Generic', 'date' => date('d/m/Y', strtotime('-5 days'))],
            ['file' => 'C:\\Users\\Agent\\Downloads\\crack.exe', 'threat' => 'HackTool.Crack', 'date' => date('d/m/Y', strtotime('-1 week'))],
        ],
        'definitions_version' => '2024.12.17.003',
        'definitions_date' => date('d/m/Y', strtotime('-1 day')),
        'real_time' => true,
        'last_update' => date('d/m/Y H:i', strtotime('-6 hours'))
    ];
}

if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch($_POST['action']) {
        case 'scan':
            $_SESSION['antivirus_data']['scan_running'] = true;
            echo json_encode(['status' => 'started']);
            exit;
            
        case 'update':
            $_SESSION['antivirus_data']['definitions_date'] = date('d/m/Y');
            $_SESSION['antivirus_data']['last_update'] = date('d/m/Y H:i');
            echo json_encode(['status' => 'updated']);
            exit;
            
        case 'clean':
            $file = $_POST['file'];
            echo json_encode(['status' => 'cleaned', 'file' => $file]);
            exit;
    }
}
?>

<div style="height: 100%; display: flex; flex-direction: column; background: #ECE9D8;">
    
    <!-- Header -->
    <div style="background: linear-gradient(to bottom, #FFFFFF, #E4E4E4); border-bottom: 1px solid #919B9C; padding: 8px;">
        <div style="display: flex; align-items: center;">
            <img src="includes/logo.png" style="width: 32px; height: 32px; margin-right: 10px;">
            <div>
                <div style="font-size: 16px; font-weight: bold; color: #003399;">FreeLiberty Antivirus</div>
                <div style="font-size: 10px; color: #666;">Protection active depuis 1989</div>
            </div>
            <div style="margin-left: auto; display: flex; gap: 10px; align-items: center;">
                <div style="text-align: center;">
                    <div style="font-size: 10px; color: #666;">État</div>
                    <div style="font-size: 12px; color: <?= $_SESSION['antivirus_data']['real_time'] ? '#008000' : '#FF0000' ?>; font-weight: bold;">
                        <?= $_SESSION['antivirus_data']['real_time'] ? 'PROTÉGÉ' : 'EN DANGER' ?>
                    </div>
                </div>
                <div style="text-align: center;">
                    <div style="font-size: 10px; color: #666;">Dernière mise à jour</div>
                    <div style="font-size: 11px;"><?= $_SESSION['antivirus_data']['last_update'] ?></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Toolbar -->
    <div style="background: #F0F0F0; border-bottom: 1px solid #919B9C; padding: 5px; display: flex;">
        <button class="xp-toolbar-btn" onclick="startFullScan()" style="background: #E0FFE0; border: 2px solid #008000;">
            <span style="font-size: 24px;">🔍</span><br>
            <span style="font-size: 11px; font-weight: bold;">ANALYSER</span>
        </button>
        <button class="xp-toolbar-btn" onclick="updateDefinitions()" style="background: #E0E0FF; border: 2px solid #000080;">
            <span style="font-size: 24px;">🔄</span><br>
            <span style="font-size: 11px; font-weight: bold;">METTRE À JOUR</span>
        </button>
        <button class="xp-toolbar-btn" onclick="showQuarantine()" style="background: #FFFFE0; border: 2px solid #808000;">
            <span style="font-size: 24px;">⚠️</span><br>
            <span style="font-size: 11px; font-weight: bold;">QUARANTAINE</span>
        </button>
        <button class="xp-toolbar-btn" onclick="showSettings()" style="background: #F0F0F0; border: 2px solid #808080;">
            <span style="font-size: 24px;">⚙️</span><br>
            <span style="font-size: 11px; font-weight: bold;">PARAMÈTRES</span>
        </button>
        <button class="xp-toolbar-btn" onclick="showLogs()" style="background: #F0F0F0; border: 2px solid #808080;">
            <span style="font-size: 24px;">📋</span><br>
            <span style="font-size: 11px; font-weight: bold;">JOURNAUX</span>
        </button>
    </div>
    
    <!-- Main Content -->
    <div style="flex: 1; display: flex;">
        
        <!-- Left Panel -->
        <div style="width: 200px; background: white; border-right: 1px solid #919B9C; padding: 10px;">
            <div style="font-weight: bold; margin-bottom: 10px; color: #003399;">Centre de sécurité</div>
            
            <div class="left-menu-item" onclick="showTab('status')" id="menu-status">
                ▶ État de protection
            </div>
            <div class="left-menu-item" onclick="showTab('scan')" id="menu-scan">
                ▶ Analyse antivirus
            </div>
            <div class="left-menu-item" onclick="showTab('realtime')" id="menu-realtime">
                ▶ Protection temps réel
            </div>
            <div class="left-menu-item" onclick="showTab('quarantine')" id="menu-quarantine">
                ▶ Zone de quarantaine
            </div>
            <div class="left-menu-item" onclick="showTab('update')" id="menu-update">
                ▶ Mises à jour
            </div>
            <div class="left-menu-item" onclick="showTab('tools')" id="menu-tools">
                ▶ Outils
            </div>
        </div>
        
        <!-- Right Content -->
        <div style="flex: 1; padding: 15px; overflow-y: auto;">
            
            <!-- Status Tab -->
            <div id="tab-status" class="tab-content">
                <h2 style="color: #003399; font-size: 18px; margin-bottom: 15px;">État de la protection</h2>
                
                <div style="background: white; border: 1px solid #919B9C; padding: 15px; margin-bottom: 15px;">
                    <div style="display: flex; align-items: center; margin-bottom: 15px;">
                        <div style="width: 48px; height: 48px; background: #008000; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 15px;">
                            <span style="color: white; font-size: 24px;">✓</span>
                        </div>
                        <div>
                            <div style="font-size: 16px; font-weight: bold; color: #008000;">Votre ordinateur est protégé</div>
                            <div style="font-size: 12px; color: #666;">Toutes les protections sont actives</div>
                        </div>
                    </div>
                    
                    <div style="border-top: 1px solid #E0E0E0; padding-top: 10px;">
                        <table style="width: 100%; font-size: 12px;">
                            <tr>
                                <td style="padding: 5px;">Protection en temps réel:</td>
                                <td style="color: #008000; font-weight: bold;">Activée</td>
                            </tr>
                            <tr>
                                <td style="padding: 5px;">Dernière analyse:</td>
                                <td><?= $_SESSION['antivirus_data']['last_scan'] ?></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px;">Base de virus:</td>
                                <td>Version <?= $_SESSION['antivirus_data']['definitions_version'] ?></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px;">Fichiers en quarantaine:</td>
                                <td style="color: #FF6600;"><?= count($_SESSION['antivirus_data']['quarantine']) ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <div style="display: flex; gap: 10px;">
                    <button class="xp-button" onclick="startQuickScan()" style="background: #E0FFE0; border: 2px solid #008000; padding: 10px 20px; font-weight: bold;">
                        🔍 Analyse rapide
                    </button>
                    <button class="xp-button" onclick="startFullScan()" style="background: #FFE0E0; border: 2px solid #800000; padding: 10px 20px; font-weight: bold;">
                        🔎 Analyse complète
                    </button>
                    <button class="xp-button" onclick="updateDefinitions()" style="background: #E0E0FF; border: 2px solid #000080; padding: 10px 20px; font-weight: bold;">
                        🔄 Mettre à jour
                    </button>
                </div>
            </div>
            
            <!-- Scan Tab -->
            <div id="tab-scan" class="tab-content" style="display: none;">
                <h2 style="color: #003399; font-size: 18px; margin-bottom: 15px;">Analyse antivirus</h2>
                
                <div style="background: white; border: 1px solid #919B9C; padding: 15px;">
                    <div style="margin-bottom: 15px;">
                        <label style="display: block; margin-bottom: 10px;">
                            <input type="radio" name="scantype" value="quick" checked> Analyse rapide (recommandée)
                            <div style="font-size: 11px; color: #666; margin-left: 20px;">Analyse les zones système critiques</div>
                        </label>
                        <label style="display: block; margin-bottom: 10px;">
                            <input type="radio" name="scantype" value="full"> Analyse complète
                            <div style="font-size: 11px; color: #666; margin-left: 20px;">Analyse tous les fichiers de l'ordinateur</div>
                        </label>
                        <label style="display: block; margin-bottom: 10px;">
                            <input type="radio" name="scantype" value="custom"> Analyse personnalisée
                            <div style="font-size: 11px; color: #666; margin-left: 20px;">Choisir les dossiers à analyser</div>
                        </label>
                    </div>
                    
                    <button class="xp-button" onclick="startSelectedScan()" style="background: #008000; color: white; padding: 10px 30px; font-size: 14px; font-weight: bold; border: 2px solid #004000;">
                        ▶ DÉMARRER L'ANALYSE
                    </button>
                </div>
                
                <div id="scanProgress" style="display: none; background: white; border: 1px solid #919B9C; padding: 15px; margin-top: 15px;">
                    <div style="font-weight: bold; margin-bottom: 10px;">Analyse en cours...</div>
                    <div style="border: 1px solid #919B9C; height: 20px; background: white; margin-bottom: 10px;">
                        <div id="progressBar" style="height: 100%; background: linear-gradient(to right, #316AC5, #6B9BD1); width: 0%;"></div>
                    </div>
                    <div id="scanStatus" style="font-size: 11px; color: #666;">Initialisation...</div>
                    <div style="margin-top: 10px; font-size: 11px;">
                        Fichiers analysés: <span id="filesScanned">0</span><br>
                        Menaces détectées: <span id="threatsFound" style="color: #FF0000;">0</span><br>
                        Temps écoulé: <span id="timeElapsed">00:00</span>
                    </div>
                </div>
                
                <div id="scanResults" style="display: none; background: white; border: 1px solid #919B9C; padding: 15px; margin-top: 15px;">
                    <div style="font-weight: bold; margin-bottom: 10px;">Résultats de l'analyse</div>
                    <div id="resultsContent"></div>
                </div>
            </div>
            
            <!-- Quarantine Tab -->
            <div id="tab-quarantine" class="tab-content" style="display: none;">
                <h2 style="color: #003399; font-size: 18px; margin-bottom: 15px;">Zone de quarantaine</h2>
                
                <div style="background: #FFFFCC; border: 1px solid #CCCC00; padding: 10px; margin-bottom: 15px;">
                    <strong>⚠️ Attention:</strong> Les fichiers en quarantaine sont isolés et ne peuvent pas endommager votre système.
                </div>
                
                <div style="background: white; border: 1px solid #919B9C;">
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: #F0F0F0;">
                                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #919B9C;">Fichier</th>
                                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #919B9C;">Menace</th>
                                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #919B9C;">Date</th>
                                <th style="padding: 5px; text-align: left; border-bottom: 1px solid #919B9C;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($_SESSION['antivirus_data']['quarantine'] as $item): ?>
                            <tr>
                                <td style="padding: 5px; border-bottom: 1px solid #E0E0E0; font-size: 11px;">
                                    <?= htmlspecialchars($item['file']) ?>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #E0E0E0; color: #FF0000; font-size: 11px;">
                                    <?= $item['threat'] ?>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #E0E0E0; font-size: 11px;">
                                    <?= $item['date'] ?>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #E0E0E0;">
                                    <button onclick="restoreFile('<?= $item['file'] ?>')" style="font-size: 10px;">Restaurer</button>
                                    <button onclick="deleteFile('<?= $item['file'] ?>')" style="font-size: 10px;">Supprimer</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <div style="margin-top: 10px;">
                    <button class="xp-button" onclick="emptyQuarantine()">Vider la quarantaine</button>
                </div>
            </div>
            
            <!-- Update Tab -->
            <div id="tab-update" class="tab-content" style="display: none;">
                <h2 style="color: #003399; font-size: 18px; margin-bottom: 15px;">Mises à jour</h2>
                
                <div style="background: white; border: 1px solid #919B9C; padding: 15px;">
                    <div style="margin-bottom: 15px;">
                        <strong>État des mises à jour</strong>
                    </div>
                    
                    <table style="width: 100%; font-size: 12px;">
                        <tr>
                            <td style="padding: 5px;">Base de données virale:</td>
                            <td><?= $_SESSION['antivirus_data']['definitions_version'] ?></td>
                            <td><?= $_SESSION['antivirus_data']['definitions_date'] ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px;">Moteur d'analyse:</td>
                            <td>8.5.0.1989</td>
                            <td>À jour</td>
                        </tr>
                        <tr>
                            <td style="padding: 5px;">Programme principal:</td>
                            <td>6.66.1989</td>
                            <td>À jour</td>
                        </tr>
                    </table>
                    
                    <div style="margin-top: 15px;">
                        <button class="xp-button" onclick="checkUpdates()">Rechercher les mises à jour</button>
                        <label style="margin-left: 15px;">
                            <input type="checkbox" checked> Mise à jour automatique
                        </label>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    
    <!-- Status Bar -->
    <div style="background: #ECE9D8; border-top: 1px solid #919B9C; padding: 2px 5px; font-size: 11px; display: flex;">
        <div>FreeLiberty Antivirus - Version 6.66</div>
        <div style="margin-left: auto;">© 1989-2024 FreeLiberty Software</div>
    </div>
</div>

<style>
.xp-toolbar-btn {
    background: transparent;
    border: 1px solid transparent;
    padding: 5px 10px;
    cursor: pointer;
    text-align: center;
    min-width: 60px;
}

.xp-toolbar-btn:hover {
    border: 1px solid #919B9C;
    background: #E0E0E0;
}

.xp-button {
    background: #ECE9D8;
    border: 1px solid #003C74;
    padding: 5px 15px;
    cursor: pointer;
    font-size: 11px;
}

.xp-button:hover {
    background: #DDD6C1;
}

.left-menu-item {
    padding: 5px;
    cursor: pointer;
    font-size: 11px;
    margin: 2px 0;
}

.left-menu-item:hover {
    background: #316AC5;
    color: white;
}

.left-menu-item.active {
    background: #E0E0E0;
    font-weight: bold;
}

.tab-content {
    animation: fadeIn 0.3s;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}
</style>

<script>
let scanInterval;
let scanTime = 0;
let filesScanned = 0;
let threatsFound = 0;

// RENDRE TOUTES LES FONCTIONS GLOBALES
window.showTab = function(tabName) {
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.style.display = 'none';
    });
    document.querySelectorAll('.left-menu-item').forEach(item => {
        item.classList.remove('active');
    });
    
    document.getElementById('tab-' + tabName).style.display = 'block';
    document.getElementById('menu-' + tabName).classList.add('active');
}

window.startQuickScan = function() {
    window.showTab('scan');
    window.performScan('quick');
}

window.startFullScan = function() {
    window.showTab('scan');
    window.performScan('full');
}

window.startSelectedScan = function() {
    const scanType = document.querySelector('input[name="scantype"]:checked').value;
    window.performScan(scanType);
}

window.performScan = function(type) {
    document.getElementById('scanProgress').style.display = 'block';
    document.getElementById('scanResults').style.display = 'none';
    
    filesScanned = 0;
    threatsFound = 0;
    scanTime = 0;
    let progress = 0;
    
    const paths = [
        'C:\\Windows\\System32\\',
        'C:\\Program Files\\',
        'C:\\Users\\Agent\\Documents\\',
        'C:\\Windows\\Temp\\',
        'C:\\Users\\Agent\\Downloads\\'
    ];
    
    scanInterval = setInterval(() => {
        progress += Math.random() * 5;
        if (progress > 100) progress = 100;
        
        filesScanned += Math.floor(Math.random() * 500);
        scanTime++;
        
        document.getElementById('progressBar').style.width = progress + '%';
        document.getElementById('filesScanned').textContent = filesScanned;
        document.getElementById('threatsFound').textContent = threatsFound;
        document.getElementById('timeElapsed').textContent = 
            Math.floor(scanTime / 60).toString().padStart(2, '0') + ':' + 
            (scanTime % 60).toString().padStart(2, '0');
        
        if (scanTime % 10 === 0) {
            const currentPath = paths[Math.floor(Math.random() * paths.length)];
            document.getElementById('scanStatus').textContent = 'Analyse: ' + currentPath + '****.exe';
        }
        
        if (Math.random() < 0.02) {
            threatsFound++;
            document.getElementById('threatsFound').style.color = '#FF0000';
        }
        
        if (progress >= 100) {
            clearInterval(scanInterval);
            window.completeScan();
        }
    }, 100);
}

window.completeScan = function() {
    document.getElementById('scanStatus').textContent = 'Analyse terminée';
    document.getElementById('scanResults').style.display = 'block';
    
    let resultHtml = '';
    if (threatsFound > 0) {
        resultHtml = `
            <div style="color: #FF0000; font-weight: bold; margin-bottom: 10px;">
                ⚠️ ${threatsFound} menace(s) détectée(s)
            </div>
            <div style="margin-bottom: 10px;">
                Les menaces ont été mises en quarantaine automatiquement.
            </div>
        `;
        
        if (window.parent && window.parent.showNotification) {
            window.parent.showNotification('FreeLiberty', `${threatsFound} menace(s) détectée(s) et neutralisée(s)`, 'warning');
        }
    } else {
        resultHtml = `
            <div style="color: #008000; font-weight: bold;">
                ✓ Aucune menace détectée
            </div>
        `;
    }
    
    resultHtml += `
        <div style="margin-top: 10px; font-size: 11px; color: #666;">
            Fichiers analysés: ${filesScanned}<br>
            Temps total: ${Math.floor(scanTime / 60)}:${(scanTime % 60).toString().padStart(2, '0')}
        </div>
    `;
    
    document.getElementById('resultsContent').innerHTML = resultHtml;
}

window.updateDefinitions = function() {
    if (confirm('Rechercher les mises à jour maintenant?')) {
        if (window.parent && window.parent.showNotification) {
            window.parent.showNotification('FreeLiberty', 'Recherche de mises à jour...', 'info');
            setTimeout(() => {
                window.parent.showNotification('FreeLiberty', 'Base de données virale mise à jour', 'info');
            }, 3000);
        }
    }
}

window.showQuarantine = function() {
    window.showTab('quarantine');
}

window.showSettings = function() {
    alert('Paramètres FreeLiberty\n\nToutes les options sont verrouillées par l\'administrateur.');
}

window.showLogs = function() {
    alert('Journaux système\n\n' + new Date().toLocaleString() + ' - Analyse lancée\n' + 
          new Date(Date.now() - 3600000).toLocaleString() + ' - Mise à jour effectuée\n' +
          new Date(Date.now() - 7200000).toLocaleString() + ' - Menace bloquée');
}

window.restoreFile = function(file) {
    if (confirm('Restaurer ce fichier?\n\nATTENTION: Ce fichier peut être dangereux!')) {
        alert('Fichier restauré: ' + file);
    }
}

window.deleteFile = function(file) {
    if (confirm('Supprimer définitivement ce fichier?')) {
        alert('Fichier supprimé: ' + file);
    }
}

window.emptyQuarantine = function() {
    if (confirm('Vider toute la quarantaine?\n\nCette action est irréversible!')) {
        if (window.parent && window.parent.showNotification) {
            window.parent.showNotification('FreeLiberty', 'Quarantaine vidée', 'info');
        }
    }
}

window.checkUpdates = function() {
    window.updateDefinitions();
}

// Afficher l'onglet par défaut
window.showTab('status');
</script>