<!DOCTYPE html>

<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cantesso Academy - Application</title>
    <meta name="description" content="Apply to Cantesso Young Developers Academy, created by aktascorp">
    <meta property="og:url" content="https://aktascorp.com/cantesso">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Cantesso Academy - Application">
    <meta property="og:description" content="Apply to Cantesso Young Developers Academy, created by aktascorp">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/f5392a79-6b29-4512-84e5-3c1dc052831e.png?token=yN3Y4II0EPQtwleOTVO4BNENFYa5nFrzxpndsK8PzQ0&height=800&width=1200&expires=33285341982">
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="aktascorp.com">
    <meta property="twitter:url" content="https://aktascorp.com/cantesso">
    <meta name="twitter:title" content="Cantesso Academy - Application">
    <meta name="twitter:description" content="Apply to Cantesso Young Developers Academy, created by aktascorp">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/f5392a79-6b29-4512-84e5-3c1dc052831e.png?token=yN3Y4II0EPQtwleOTVO4BNENFYa5nFrzxpndsK8PzQ0&height=800&width=1200&expires=33285341982">
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">

<div class="mt-16 max-w-4xl mx-auto px-4 py-5">
    <div class="relative rounded-lg overflow-hidden mb-12 h-64">
        <div class="absolute inset-0 bg-opacity-30"></div>
        <div class="absolute left-8 top-1/2 transform -translate-y-1/2 text-black">
            <h1 class="text-4xl font-light tracking-wider">The Cantesso academy</h1>
            <p class="text-sm">young developers academy,
            by aktascorp</p>
                                <div class="text-left mt-2">
            <a href="/" class="text-sm text-gray-600 hover:text-gray-800">← Back to home</a>
        </div>
        </div>
    </div>


    <main>
        <section class="mb-12 items-center text-left">
            <h3 class="text-3xl mt-12">apply to cantesso academy</h3>
            <p class="max-w-2xl mb-8">
                Join our academy for young developers and unlock your potential in technology. Cantesso Academy is designed to nurture the next generation of brilliant minds.
            </p>

            <form action="process_application.php" method="POST" class="max-w-2xl space-y-6">
                <div>
                    <label for="first_name" class="block text-gray-700 font-medium mb-2">First Name</label>
                    <input type="text" id="first_name" name="first_name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                </div>

                <div>
                    <label for="last_name" class="block text-gray-700 font-medium mb-2">Last Name</label>
                    <input type="text" id="last_name" name="last_name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                </div>

                <div>
                    <label for="email" class="block text-gray-700 font-medium mb-2">Email Address</label>
                    <input type="email" id="email" name="email" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                </div>

                <div>
                    <label for="birth_date" class="block text-gray-700 font-medium mb-2">Date of Birth</label>
                    <input type="date" id="birth_date" name="birth_date" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                </div>

                <div>
                    <label for="country" class="block text-gray-700 font-medium mb-2">Country of Residence</label>
                    <select id="country" name="country" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                        <option value="">Select your country</option>
                        <option value="AF" data-code="+93">Afghanistan</option>
                        <option value="AL" data-code="+355">Albania</option>
                        <option value="DZ" data-code="+213">Algeria</option>
                        <option value="AD" data-code="+376">Andorra</option>
                        <option value="AO" data-code="+244">Angola</option>
                        <option value="AG" data-code="+1">Antigua and Barbuda</option>
                        <option value="AR" data-code="+54">Argentina</option>
                        <option value="AM" data-code="+374">Armenia</option>
                        <option value="AU" data-code="+61">Australia</option>
                        <option value="AT" data-code="+43">Austria</option>
                        <option value="AZ" data-code="+994">Azerbaijan</option>
                        <option value="BS" data-code="+1">Bahamas</option>
                        <option value="BH" data-code="+973">Bahrain</option>
                        <option value="BD" data-code="+880">Bangladesh</option>
                        <option value="BB" data-code="+1">Barbados</option>
                        <option value="BY" data-code="+375">Belarus</option>
                        <option value="BE" data-code="+32">Belgium</option>
                        <option value="BZ" data-code="+501">Belize</option>
                        <option value="BJ" data-code="+229">Benin</option>
                        <option value="BT" data-code="+975">Bhutan</option>
                        <option value="BO" data-code="+591">Bolivia</option>
                        <option value="BA" data-code="+387">Bosnia and Herzegovina</option>
                        <option value="BW" data-code="+267">Botswana</option>
                        <option value="BR" data-code="+55">Brazil</option>
                        <option value="BN" data-code="+673">Brunei</option>
                        <option value="BG" data-code="+359">Bulgaria</option>
                        <option value="BF" data-code="+226">Burkina Faso</option>
                        <option value="BI" data-code="+257">Burundi</option>
                        <option value="CV" data-code="+238">Cabo Verde</option>
                        <option value="KH" data-code="+855">Cambodia</option>
                        <option value="CM" data-code="+237">Cameroon</option>
                        <option value="CA" data-code="+1">Canada</option>
                        <option value="CF" data-code="+236">Central African Republic</option>
                        <option value="TD" data-code="+235">Chad</option>
                        <option value="CL" data-code="+56">Chile</option>
                        <option value="CN" data-code="+86">China</option>
                        <option value="CO" data-code="+57">Colombia</option>
                        <option value="KM" data-code="+269">Comoros</option>
                        <option value="CG" data-code="+242">Congo</option>
                        <option value="CD" data-code="+243">Congo (Democratic Republic)</option>
                        <option value="CR" data-code="+506">Costa Rica</option>
                        <option value="CI" data-code="+225">Côte d'Ivoire</option>
                        <option value="HR" data-code="+385">Croatia</option>
                        <option value="CU" data-code="+53">Cuba</option>
                        <option value="CY" data-code="+357">Cyprus</option>
                        <option value="CZ" data-code="+420">Czech Republic</option>
                        <option value="DK" data-code="+45">Denmark</option>
                        <option value="DJ" data-code="+253">Djibouti</option>
                        <option value="DM" data-code="+1">Dominica</option>
                        <option value="DO" data-code="+1">Dominican Republic</option>
                        <option value="EC" data-code="+593">Ecuador</option>
                        <option value="EG" data-code="+20">Egypt</option>
                        <option value="SV" data-code="+503">El Salvador</option>
                        <option value="GQ" data-code="+240">Equatorial Guinea</option>
                        <option value="ER" data-code="+291">Eritrea</option>
                        <option value="EE" data-code="+372">Estonia</option>
                        <option value="SZ" data-code="+268">Eswatini</option>
                        <option value="ET" data-code="+251">Ethiopia</option>
                        <option value="FJ" data-code="+679">Fiji</option>
                        <option value="FI" data-code="+358">Finland</option>
                        <option value="FR" data-code="+33">France</option>
                        <option value="GA" data-code="+241">Gabon</option>
                        <option value="GM" data-code="+220">Gambia</option>
                        <option value="GE" data-code="+995">Georgia</option>
                        <option value="DE" data-code="+49">Germany</option>
                        <option value="GH" data-code="+233">Ghana</option>
                        <option value="GR" data-code="+30">Greece</option>
                        <option value="GD" data-code="+1">Grenada</option>
                        <option value="GT" data-code="+502">Guatemala</option>
                        <option value="GN" data-code="+224">Guinea</option>
                        <option value="GW" data-code="+245">Guinea-Bissau</option>
                        <option value="GY" data-code="+592">Guyana</option>
                        <option value="HT" data-code="+509">Haiti</option>
                        <option value="HN" data-code="+504">Honduras</option>
                        <option value="HU" data-code="+36">Hungary</option>
                        <option value="IS" data-code="+354">Iceland</option>
                        <option value="IN" data-code="+91">India</option>
                        <option value="ID" data-code="+62">Indonesia</option>
                        <option value="IR" data-code="+98">Iran</option>
                        <option value="IQ" data-code="+964">Iraq</option>
                        <option value="IE" data-code="+353">Ireland</option>
                        <option value="IL" data-code="+972">Israel</option>
                        <option value="IT" data-code="+39">Italy</option>
                        <option value="JM" data-code="+1">Jamaica</option>
                        <option value="JP" data-code="+81">Japan</option>
                        <option value="JO" data-code="+962">Jordan</option>
                        <option value="KZ" data-code="+7">Kazakhstan</option>
                        <option value="KE" data-code="+254">Kenya</option>
                        <option value="KI" data-code="+686">Kiribati</option>
                        <option value="KP" data-code="+850">Korea (North)</option>
                        <option value="KR" data-code="+82">Korea (South)</option>
                        <option value="KW" data-code="+965">Kuwait</option>
                        <option value="KG" data-code="+996">Kyrgyzstan</option>
                        <option value="LA" data-code="+856">Laos</option>
                        <option value="LV" data-code="+371">Latvia</option>
                        <option value="LB" data-code="+961">Lebanon</option>
                        <option value="LS" data-code="+266">Lesotho</option>
                        <option value="LR" data-code="+231">Liberia</option>
                        <option value="LY" data-code="+218">Libya</option>
                        <option value="LI" data-code="+423">Liechtenstein</option>
                        <option value="LT" data-code="+370">Lithuania</option>
                        <option value="LU" data-code="+352">Luxembourg</option>
                        <option value="MG" data-code="+261">Madagascar</option>
                        <option value="MW" data-code="+265">Malawi</option>
                        <option value="MY" data-code="+60">Malaysia</option>
                        <option value="MV" data-code="+960">Maldives</option>
                        <option value="ML" data-code="+223">Mali</option>
                        <option value="MT" data-code="+356">Malta</option>
                        <option value="MH" data-code="+692">Marshall Islands</option>
                        <option value="MR" data-code="+222">Mauritania</option>
                        <option value="MU" data-code="+230">Mauritius</option>
                        <option value="MX" data-code="+52">Mexico</option>
                        <option value="FM" data-code="+691">Micronesia</option>
                        <option value="MD" data-code="+373">Moldova</option>
                        <option value="MC" data-code="+377">Monaco</option>
                        <option value="MN" data-code="+976">Mongolia</option>
                        <option value="ME" data-code="+382">Montenegro</option>
                        <option value="MA" data-code="+212">Morocco</option>
                        <option value="MZ" data-code="+258">Mozambique</option>
                        <option value="MM" data-code="+95">Myanmar</option>
                        <option value="NA" data-code="+264">Namibia</option>
                        <option value="NR" data-code="+674">Nauru</option>
                        <option value="NP" data-code="+977">Nepal</option>
                        <option value="NL" data-code="+31">Netherlands</option>
                        <option value="NZ" data-code="+64">New Zealand</option>
                        <option value="NI" data-code="+505">Nicaragua</option>
                        <option value="NE" data-code="+227">Niger</option>
                        <option value="NG" data-code="+234">Nigeria</option>
                        <option value="MK" data-code="+389">North Macedonia</option>
                        <option value="NO" data-code="+47">Norway</option>
                        <option value="OM" data-code="+968">Oman</option>
                        <option value="PK" data-code="+92">Pakistan</option>
                        <option value="PW" data-code="+680">Palau</option>
                        <option value="PA" data-code="+507">Panama</option>
                        <option value="PG" data-code="+675">Papua New Guinea</option>
                        <option value="PY" data-code="+595">Paraguay</option>
                        <option value="PE" data-code="+51">Peru</option>
                        <option value="PH" data-code="+63">Philippines</option>
                        <option value="PL" data-code="+48">Poland</option>
                        <option value="PT" data-code="+351">Portugal</option>
                        <option value="QA" data-code="+974">Qatar</option>
                        <option value="RO" data-code="+40">Romania</option>
                        <option value="RU" data-code="+7">Russia</option>
                        <option value="RW" data-code="+250">Rwanda</option>
                        <option value="KN" data-code="+1">Saint Kitts and Nevis</option>
                        <option value="LC" data-code="+1">Saint Lucia</option>
                        <option value="VC" data-code="+1">Saint Vincent and the Grenadines</option>
                        <option value="WS" data-code="+685">Samoa</option>
                        <option value="SM" data-code="+378">San Marino</option>
                        <option value="ST" data-code="+239">São Tomé and Príncipe</option>
                        <option value="SA" data-code="+966">Saudi Arabia</option>
                        <option value="SN" data-code="+221">Senegal</option>
                        <option value="RS" data-code="+381">Serbia</option>
                        <option value="SC" data-code="+248">Seychelles</option>
                        <option value="SL" data-code="+232">Sierra Leone</option>
                        <option value="SG" data-code="+65">Singapore</option>
                        <option value="SK" data-code="+421">Slovakia</option>
                        <option value="SI" data-code="+386">Slovenia</option>
                        <option value="SB" data-code="+677">Solomon Islands</option>
                        <option value="SO" data-code="+252">Somalia</option>
                        <option value="ZA" data-code="+27">South Africa</option>
                        <option value="SS" data-code="+211">South Sudan</option>
                        <option value="ES" data-code="+34">Spain</option>
                        <option value="LK" data-code="+94">Sri Lanka</option>
                        <option value="SD" data-code="+249">Sudan</option>
                        <option value="SR" data-code="+597">Suriname</option>
                        <option value="SE" data-code="+46">Sweden</option>
                        <option value="CH" data-code="+41">Switzerland</option>
                        <option value="SY" data-code="+963">Syria</option>
                        <option value="TW" data-code="+886">Taiwan</option>
                        <option value="TJ" data-code="+992">Tajikistan</option>
                        <option value="TZ" data-code="+255">Tanzania</option>
                        <option value="TH" data-code="+66">Thailand</option>
                        <option value="TL" data-code="+670">Timor-Leste</option>
                        <option value="TG" data-code="+228">Togo</option>
                        <option value="TO" data-code="+676">Tonga</option>
                        <option value="TT" data-code="+1">Trinidad and Tobago</option>
                        <option value="TN" data-code="+216">Tunisia</option>
                        <option value="TR" data-code="+90">Turkey</option>
                        <option value="TM" data-code="+993">Turkmenistan</option>
                        <option value="TV" data-code="+688">Tuvalu</option>
                        <option value="UG" data-code="+256">Uganda</option>
                        <option value="UA" data-code="+380">Ukraine</option>
                        <option value="AE" data-code="+971">United Arab Emirates</option>
                        <option value="GB" data-code="+44">United Kingdom</option>
                        <option value="US" data-code="+1">United States</option>
                        <option value="UY" data-code="+598">Uruguay</option>
                        <option value="UZ" data-code="+998">Uzbekistan</option>
                        <option value="VU" data-code="+678">Vanuatu</option>
                        <option value="VA" data-code="+39">Vatican City</option>
                        <option value="VE" data-code="+58">Venezuela</option>
                        <option value="VN" data-code="+84">Vietnam</option>
                        <option value="YE" data-code="+967">Yemen</option>
                        <option value="ZM" data-code="+260">Zambia</option>
                        <option value="ZW" data-code="+263">Zimbabwe</option>
                    </select>
                </div>

                <div>
                    <label for="phone" class="block text-gray-700 font-medium mb-2">Phone Number</label>
                    <div class="flex">
                        <input type="text" id="country_code" name="country_code" readonly class="w-20 px-4 py-2 border border-gray-300 rounded-l-lg bg-gray-100 focus:outline-none" placeholder="+">
                        <input type="tel" id="phone" name="phone" required class="flex-1 px-4 py-2 border border-gray-300 rounded-r-lg focus:outline-none focus:ring-2 focus:ring-gray-400">
                    </div>
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-gray-800 text-white py-3 px-6 rounded-lg hover:bg-gray-700 transition duration-200 font-medium">
                        Submit Application
                    </button>
                </div>
            </form>

            <div class="mt-8 p-6 bg-gray-100 rounded-lg">
                <h4 class="text-xl font-medium mb-2">Requirements</h4>
                <p class="text-gray-700">Applicants must be at least 13 years old to apply to Cantesso Academy. Our programme is designed for passionate young minds interested in technology and development.</p>
            </div>
        </section>
    </main>

    <div class="p-8 rounded">
        <blockquote class="border-l-4 border-gray-300 pl-6 py-4">
            <p class="text-xl font-light text-gray-700 mb-4">
                "The future belongs to those who learn, adapt, and create. At Cantesso Academy, we shape tomorrow's innovators."
            </p>
            <cite class="text-gray-500 text-sm">— Aktas Izhak, CEO aktascorp</cite>
        </blockquote>
    </div>

    <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
        <p>&copy; 2025 aktascorp, all rights reserved. aktascorp operates as a centralized network of independent enterprises. For any inquiries or to contact our coordination team, please write to msg@aktascorp.com. All content on aktascorp-affiliated websites displaying the « copyright » label are protected by copyright law.</p>
    </footer>
</div>

<script>
    document.getElementById('country').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const countryCode = selectedOption.getAttribute('data-code');
        document.getElementById('country_code').value = countryCode || '';
    });

    document.getElementById('birth_date').addEventListener('change', function() {
        const birthDate = new Date(this.value);
        const today = new Date();
        const age = today.getFullYear() - birthDate.getFullYear();
        const monthDiff = today.getMonth() - birthDate.getMonth();
        
        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
            age--;
        }
        
        if (age < 13) {
            alert('You must be at least 13 years old to apply to Cantesso Academy.');
            this.value = '';
        }
    });
</script>
```

</body>
</html>