<?php
// Informations de connexion à la base de données
$host = 'localhost:3306';
$dbname = 'gqdcvggs_cergies';
$username = 'gqdcvggs';
$password = 'imaors_management.346980*#@-onlyforcpanel;forchange';
$charset = 'utf8mb4';

// Configuration DSN
$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

// Options PDO pour une meilleure gestion des erreurs
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    // Création de la connexion PDO
    $pdo = new PDO($dsn, $username, $password, $options);
} catch (PDOException $e) {
    // En cas d'erreur, afficher un message d'erreur
    die("Erreur de connexion à la base de données: " . $e->getMessage());
}

/**
 * Fonction pour récupérer tous les magasins
 * @return array Liste des magasins
 */
function getAllStores() {
    global $pdo;
    
    try {
        $stmt = $pdo->query("SELECT * FROM stores ORDER BY name ASC");
        return $stmt->fetchAll();
    } catch (PDOException $e) {
        die("Erreur lors de la récupération des magasins: " . $e->getMessage());
    }
}

/**
 * Fonction pour récupérer un magasin par son ID
 * @param int $id ID du magasin
 * @return array Détails du magasin
 */
function getStoreById($id) {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM stores WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch();
    } catch (PDOException $e) {
        die("Erreur lors de la récupération du magasin: " . $e->getMessage());
    }
}
?>