<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cergies - The world center</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cal+Sans&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --accent: #3b82f6;
        }

        body {
            font-family: 'Cal Sans', sans-serif;
        }

        .menu-overlay {
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }

        .menu-overlay.active {
            opacity: 1;
            visibility: visible;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const menuButton = document.getElementById('menu-button');
            const menuOverlay = document.getElementById('menu-overlay');
            const closeButton = document.getElementById('close-button');

            menuButton.addEventListener('click', function() {
                menuOverlay.classList.add('active');
            });

            closeButton.addEventListener('click', function() {
                menuOverlay.classList.remove('active');
            });
        });
    </script>
</head>
<body class="bg-white text-gray-900 min-h-screen">
    <!-- Header -->
    <header class="py-6 px-4 md:px-8 border-b border-gray-200">
        <div class="max-w-7xl mx-auto flex justify-between items-center">
            <!-- Logo et tagline -->
            <div>
                <h1 class="text-3xl font-light tracking-tight">Cergies</h1>
                <p class="text-xs text-gray-500 mt-1">The world center</p>
            </div>

            <!-- Navigation desktop -->
            <nav class="hidden md:flex items-center space-x-8">
                <a href="index.php" class="text-sm hover:text-blue-600 transition-colors">Find a store</a>
                <a href="#stores" class="text-sm hover:text-blue-600 transition-colors">Contact support</a>
                <a href="#about" class="text-sm hover:text-blue-600 transition-colors">Find help quickly at home</a>
                
            </nav>

            <!-- Bouton hamburger (mobile) -->
            <button id="menu-button" class="md:hidden flex flex-col space-y-1.5">
                <span class="w-6 h-0.5 bg-gray-900"></span>
                <span class="w-6 h-0.5 bg-gray-900"></span>
            </button>
        </div>
    </header>

    <!-- Menu overlay pour mobile -->
    <div id="menu-overlay" class="menu-overlay fixed inset-0 bg-white z-50 flex flex-col">
        <div class="p-6 flex justify-between items-center border-b border-gray-100">
            <h2 class="text-xl">Find all you need.</h2>
            <button id="close-button" class="p-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
        <nav class="flex flex-col p-6 space-y-6">
            <a href="index.php" class="text-lg border-b border-gray-100 pb-2">Find a store</a>
            <a href="#stores" class="text-lg border-b border-gray-100 pb-2">Contact support</a>
            <a href="#about" class="text-lg border-b border-gray-100 pb-2">Find help quickly at home</a>
        </nav>
    </div>