<?php
require_once('vendor/autoload.php');
require_once('config.php');

header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $payment_method_id = $input['payment_method_id'];
    $email = $input['email'];
    $env = $input['env'] ?? 'test';

    // Utiliser les clés appropriées selon l'environnement
    \Stripe\Stripe::setApiKey($stripe[$env]['secret_key']);

    // Créer le paiement
    $payment_intent = \Stripe\PaymentIntent::create([
        'amount' => 2000000, // 2000€ en centimes
        'currency' => 'eur',
        'payment_method' => $payment_method_id,
        'confirmation_method' => 'manual',
        'confirm' => true,
        'receipt_email' => $email,
        'description' => 'Paiement 2Me',
    ]);

    if ($payment_intent->status === 'succeeded') {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Le paiement a échoué.']);
    }
} catch (\Stripe\Exception\CardException $e) {
    echo json_encode(['error' => $e->getMessage()]);
} catch (\Exception $e) {
    echo json_encode(['error' => 'Une erreur est survenue.']);
}
?>