<?php
header('Content-Type: application/json');
require_once 'db.php';

try {
    $db = getDB2Connection();
    
    // Récupérer tous les objectifs, ordonnés par date d'échéance
    $stmt = $db->query("
        SELECT id, title, type, target, current, start_date, end_date, notes, completed
        FROM finance_goals
        ORDER BY end_date ASC
    ");
    
    $goals = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'goals' => $goals
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur de base de données: ' . $e->getMessage()
    ]);
}
?>