<?php
require_once '../db.php';
session_start();
header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        $db2 = getDB2Connection();
        $stmt = $db2->prepare("SELECT * FROM mailboxforstaff WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $config = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($config) {
            echo json_encode([
                'success' => true,
                'config' => [
                    'email' => $config['email'],
                    'imap_host' => $config['imap_host'],
                    'imap_port' => $config['imap_port'],
                    'imap_encryption' => $config['imap_encryption'],
                    'smtp_host' => $config['smtp_host'],
                    'smtp_port' => $config['smtp_port'],
                    'smtp_encryption' => $config['smtp_encryption']
                ]
            ]);
        } else {
            echo json_encode([
                'success' => true,
                'config' => null
            ]);
        }
    } 
    else if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!isset($data['email']) || !isset($data['password']) || 
            !isset($data['imap_host']) || !isset($data['smtp_host'])) {
            throw new Exception('Missing required fields');
        }

        $db2 = getDB2Connection();
        
        $testConnection = function($host, $port, $email, $password, $encryption) {
            $mailbox = "{" . $host . ":" . $port . "/imap/" . $encryption . "}INBOX";
            $connection = @imap_open($mailbox, $email, $password);
            if (!$connection) {
                throw new Exception('Failed to connect to mail server: ' . imap_last_error());
            }
            imap_close($connection);
        };

        $testConnection(
            $data['imap_host'],
            $data['imap_port'] ?? 993,
            $data['email'],
            $data['password'],
            $data['imap_encryption'] ?? 'ssl'
        );

        $stmt = $db2->prepare("SELECT id FROM mailboxforstaff WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $existing = $stmt->fetch();

        if ($existing) {
            $stmt = $db2->prepare("
                UPDATE mailboxforstaff 
                SET email = ?, password = ?, 
                    imap_host = ?, imap_port = ?, imap_encryption = ?,
                    smtp_host = ?, smtp_port = ?, smtp_encryption = ?,
                    updated_at = CURRENT_TIMESTAMP
                WHERE user_id = ?
            ");
            
            $stmt->execute([
                $data['email'],
                $data['password'],
                $data['imap_host'],
                $data['imap_port'] ?? 993,
                $data['imap_encryption'] ?? 'ssl',
                $data['smtp_host'],
                $data['smtp_port'] ?? 465,
                $data['smtp_encryption'] ?? 'ssl',
                $_SESSION['user_id']
            ]);
        } else {
            $stmt = $db2->prepare("
                INSERT INTO mailboxforstaff 
                (user_id, email, password, imap_host, imap_port, imap_encryption, 
                 smtp_host, smtp_port, smtp_encryption)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $_SESSION['user_id'],
                $data['email'],
                $data['password'],
                $data['imap_host'],
                $data['imap_port'] ?? 993,
                $data['imap_encryption'] ?? 'ssl',
                $data['smtp_host'],
                $data['smtp_port'] ?? 465,
                $data['smtp_encryption'] ?? 'ssl'
            ]);
        }

        echo json_encode([
            'success' => true,
            'message' => 'Email settings saved successfully'
        ]);
    } 
    else {
        throw new Exception('Invalid request method');
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}