<?php
require_once 'db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $db1 = getDB1Connection();
    
    $stmt = $db1->prepare("SELECT roleinimators FROM utilisateurs WHERE id = :id");
    $stmt->bindParam(':id', $user_id);
    $stmt->execute();
    
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result && isset($result['roleinimators']) && !empty($result['roleinimators'])) {
        $_SESSION['roleinimators'] = $result['roleinimators'];
    }
    
    if (!isset($_SESSION['roleinimators']) || empty($_SESSION['roleinimators'])) {
        if ($_SESSION['username'] == 'Izhak') {
            $_SESSION['roleinimators'] = 'CEO';
        } else {
            $_SESSION['roleinimators'] = 'User';
        }
    }
    
    header('Location: dashboard.php');
} catch (PDOException $e) {
    header('Location: dashboard.php?error=database');
    exit;
}
?>