<?php
session_start();
?>
<!DOCTYPE html>
<html class="h-full bg-black">
<head>
    <meta charset="UTF-8">
    <title>Email Distribution System | Imators</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="h-full bg-black text-white antialiased">
    <div class="min-h-screen flex flex-col">
        <!-- Header -->
        <header class="bg-zinc-900 border-b border-zinc-800">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-5">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <h1 class="text-xl font-bold text-white">Imators Email System</h1>
                        <span class="px-2 py-1 text-xs font-medium bg-white text-black rounded-md">Admin</span>
                    </div>
                    <div class="text-sm text-zinc-400">
                        <?php echo date('l, d F Y'); ?>
                    </div>
                </div>
            </div>
        </header>

        <main class="flex-1 max-w-7xl w-full mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="bg-zinc-900 rounded-lg shadow-xl overflow-hidden">
                <!-- Status Messages -->
                <?php if(isset($_SESSION['message'])): ?>
                    <div class="bg-zinc-800 px-6 py-4 border-b border-zinc-700">
                        <div class="flex items-center">
                            <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <p class="ml-3 text-sm font-medium text-zinc-200">
                                <?php echo $_SESSION['message']; unset($_SESSION['message']); ?>
                            </p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Email Form -->
                <form action="process-email.php" method="post" class="divide-y divide-zinc-800">
                    <div class="px-8 py-6 space-y-6">
                        <div>
                            <label for="testEmail" class="block text-sm font-medium text-zinc-300">
                                Test Email (optional)
                            </label>
                            <div class="mt-1 relative rounded-md shadow-sm">
                                <input 
                                    type="email" 
                                    name="testEmail" 
                                    id="testEmail"
                                    placeholder="email@example.com"
                                    class="block w-full rounded-md border-zinc-700 bg-zinc-800 text-white placeholder-zinc-500 focus:border-white focus:ring-white sm:text-sm px-4 py-3"
                                >
                            </div>
                            <p class="mt-2 text-sm text-zinc-400">Leave empty to send to all users</p>
                        </div>

                        <div>
                            <label for="bannerUrl" class="block text-sm font-medium text-zinc-300">
                                Banner URL
                            </label>
                            <div class="mt-1">
                                <input 
                                    type="url" 
                                    name="bannerUrl" 
                                    id="bannerUrl"
                                    placeholder="https://example.com/banner.jpg"
                                    class="block w-full rounded-md border-zinc-700 bg-zinc-800 text-white placeholder-zinc-500 focus:border-white focus:ring-white sm:text-sm px-4 py-3"
                                >
                            </div>
                        </div>

                        <div>
                            <label for="emailTitle" class="block text-sm font-medium text-zinc-300">
                                Email Subject
                            </label>
                            <div class="mt-1">
                                <input 
                                    type="text" 
                                    name="emailTitle" 
                                    id="emailTitle"
                                    required
                                    placeholder="Enter the subject of your email"
                                    class="block w-full rounded-md border-zinc-700 bg-zinc-800 text-white placeholder-zinc-500 focus:border-white focus:ring-white sm:text-sm px-4 py-3"
                                >
                            </div>
                        </div>

                        <div>
                            <label for="emailContent" class="block text-sm font-medium text-zinc-300">
                                Email Content
                            </label>
                            <div class="mt-1">
                                <textarea
                                    name="emailContent"
                                    id="emailContent"
                                    rows="10"
                                    required
                                    placeholder="Write your message here..."
                                    class="block w-full rounded-md border-zinc-700 bg-zinc-800 text-white placeholder-zinc-500 focus:border-white focus:ring-white sm:text-sm px-4 py-3"
                                ></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="px-8 py-5 bg-zinc-950">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-zinc-400" id="recipientInfo">
                                Sending to all users
                            </span>
                            <button 
                                type="submit"
                                class="inline-flex items-center px-5 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-black bg-white hover:bg-zinc-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-white transition-colors duration-200"
                            >
                                <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                                </svg>
                                Send Email
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </main>

        <!-- Footer -->
        <footer class="bg-zinc-900 border-t border-zinc-800">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
                <p class="text-center text-sm text-zinc-400">
                    © <?php echo date('Y'); ?> Imators LLC. All rights reserved.
                </p>
            </div>
        </footer>
    </div>

    <script>
        // Update recipient info based on test email
        const testEmailInput = document.getElementById('testEmail');
        const recipientInfo = document.getElementById('recipientInfo');

        testEmailInput.addEventListener('input', function() {
            if (this.value) {
                recipientInfo.textContent = `Sending to ${this.value} (test)`;
            } else {
                recipientInfo.textContent = 'Sending to all users';
            }
        });
    </script>
</body>
</html>