<?php
$allowedIPs = [
    '127.0.0.1',
    '192.168.1.1',
    '109.128.120.118'
];

$clientIP = $_SERVER['REMOTE_ADDR'];
$isAllowed = in_array($clientIP, $allowedIPs);

if (isset($_GET['redirect']) && $_GET['redirect'] === 'true' && $isAllowed) {
    header('Location: /systems');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.9.4/leaflet.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.9.4/leaflet.css" />
    <style>
        body {
            background-color: #000;
            font-family: 'Inter', sans-serif;
        }
        
        @keyframes fadeBlur {
            0% { filter: blur(20px); opacity: 0; }
            100% { filter: blur(0); opacity: 1; }
        }
        
        @keyframes loaderAnim {
            0% { width: 0%; }
            40% { width: 100%; }
            60% { width: 100%; }
            100% { width: 0%; }
        }
        
        .title-animation {
            animation: fadeBlur 2.5s forwards;
        }
        
        .desc-animation {
            animation: fadeBlur 2s forwards;
            animation-delay: 1s;
        }
        
        .loader {
            animation: loaderAnim 3s infinite;
        }
        
        #map {
            border-radius: 4px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(255, 255, 255, 0.1);
        }
        
        .time-display {
            font-weight: 200;
            letter-spacing: 1px;
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen flex items-center justify-center overflow-hidden">
    <?php if (!$isAllowed): ?>
    
    <div class="fixed inset-0 flex items-center justify-center">
        <div class="bg-black bg-opacity-90 p-8 rounded-lg border border-red-600 shadow-lg shadow-red-600/20">
            <div class="text-red-500 text-2xl font-light mb-2">Access Denied</div>
            <div class="text-gray-400">Imators Systems: Your IP address is not authorized.</div>
        </div>
    </div>
    
    <?php else: ?>
    
    <div class="fixed inset-0 flex flex-col items-center justify-center p-6 z-10">
        <h1 id="appTitle" class="text-7xl font-light mb-12 opacity-0 tracking-tight">Peerkinton.</h1>
        
        <div id="appDescription" class="opacity-0 mb-16 text-center space-y-4">
            <p class="text-2xl font-light">Connection to the requested service...</p>
        </div>
        
        <div class="w-80 h-0.5 bg-gray-900 overflow-hidden">
            <div id="progressBar" class="h-full bg-white loader"></div>
        </div>
    </div>
    
    <div id="map" class="fixed bottom-6 right-6 w-40 h-40 z-20"></div>
    
    <div id="timeDisplay" class="fixed bottom-6 left-6 text-sm time-display text-gray-400 z-20"></div>
    
    <?php endif; ?>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php if ($isAllowed): ?>
            
            // Animate title and description
            setTimeout(() => {
                document.getElementById('appTitle').classList.add('title-animation');
            }, 300);
            
            setTimeout(() => {
                document.getElementById('appDescription').classList.add('desc-animation');
            }, 800);
            
            // Setup location map
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(position => {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;
                    
                    const map = L.map('map', {
                        zoomControl: false,
                        attributionControl: false
                    }).setView([lat, lng], 12);
                    
                    L.tileLayer('https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png', {
                        maxZoom: 19
                    }).addTo(map);
                    
                    L.circle([lat, lng], {
                        radius: 600,
                        color: '#ffffff',
                        fillColor: '#ffffff',
                        fillOpacity: 0.5,
                        weight: 1
                    }).addTo(map);
                    
                }, error => {
                    console.error("Location error:", error);
                    document.getElementById('map').innerHTML = `
                        <div class="h-full w-full flex items-center justify-center bg-gray-900">
                            <div class="text-xs text-gray-500">Location unavailable</div>
                        </div>
                    `;
                });
            }
            
            // Update time and date
            function updateClock() {
                const now = new Date();
                
                const hours = String(now.getHours()).padStart(2, '0');
                const minutes = String(now.getMinutes()).padStart(2, '0');
                const seconds = String(now.getSeconds()).padStart(2, '0');
                
                const options = { 
                    weekday: 'long', 
                    year: 'numeric', 
                    month: 'long', 
                    day: 'numeric'
                };
                
                const dateString = now.toLocaleDateString('en-GB', options);
                const timeString = `${hours}:${minutes}:${seconds}`;
                
                document.getElementById('timeDisplay').innerHTML = `
                    <div class="text-lg mb-1">${timeString}</div>
                    <div class="text-xs opacity-70">${dateString}</div>
                `;
            }
            
            updateClock();
            setInterval(updateClock, 1000);
            
            // Redirect after 5 seconds
            setTimeout(() => {
                window.location.href = '?redirect=true';
            }, 5000);
            
            <?php endif; ?>
        });
    </script>
</body>
</html>