<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

if ($method === 'POST') {
    if (!isset($input['event_id']) || !isset($input['user_id']) || !isset($input['status'])) {
        jsonResponse(['error' => 'Missing required fields'], 400);
    }
    
    $pdo = getDB();
    
    $stmt = $pdo->prepare("SELECT * FROM event_responses WHERE event_id = ? AND user_id = ?");
    $stmt->execute([$input['event_id'], $input['user_id']]);
    
    if ($stmt->fetch()) {
        $stmt = $pdo->prepare("UPDATE event_responses SET status = ? WHERE event_id = ? AND user_id = ?");
        $stmt->execute([$input['status'], $input['event_id'], $input['user_id']]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO event_responses (event_id, user_id, status) VALUES (?, ?, ?)");
        $stmt->execute([$input['event_id'], $input['user_id'], $input['status']]);
    }
    
    jsonResponse(['success' => true, 'message' => 'Response updated']);
}
?>