<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak | Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Assistant:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Assistant', 'ui-sans-serif', 'system-ui']
                    }
                }
            }
        }
    </script>
    <style>
        @keyframes blurAppear {
            from { opacity: 0; filter: blur(10px); }
            to { opacity: 1; filter: blur(0); }
        }
        .blur-appear { 
            animation: blurAppear 1s ease-out forwards; 
            opacity: 0;
        }
        .fade-slide-in {
            animation: fadeSlideIn 0.8s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        @keyframes fadeSlideIn {
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        body {
            background-color: white;
            color: black;
        }
        @media (prefers-color-scheme: dark) {
            body {
                background-color: black;
                color: white;
            }
        }
    </style>
</head>
<body class="font-sans">
    <div class="container mx-auto px-4">
        <!-- Section Hero -->
        <section class="min-h-screen flex items-center relative">
            <div class="space-y-6">
                <div class="blur-appear">
                    <p class="text-lg text-gray-600 mb-2">Hello, I am</p>
                    <h1 class="text-5xl mb-4">Izhak</h1>
                    <p class="text-xl max-w-2xl mb-6">
                        CEO of Imators, passionate developer creating innovative digital experiences.
                    </p>
                </div>
                <div class="h-1 bg-black dark:bg-white w-full"></div>
            </div>
        </section>

        <!-- Competences Section -->
        <section class="py-16">
            <h2 class="text-4xl text-left mb-8">My Skills</h2>
            <div class="space-y-4">
                <div class="fade-slide-in delay-100">HTML</div>
                <div class="fade-slide-in delay-200">PHP</div>
                <div class="fade-slide-in delay-300">JavaScript</div>
                <div class="fade-slide-in delay-400">CSS</div>
            </div>
        </section>

        <!-- Projects Section -->
        <section class="py-16">
            <h2 class="text-4xl mb-8">Accomplished Projects</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="border p-6">
                    <h3 class="text-2xl mb-4">Project Name</h3>
                    <p class="mb-4">Project description</p>
                    <p class="mb-4">Language: HTML, PHP</p>
                    <a href="#" class="text-blue-600">Project Link</a>
                </div>
            </div>
        </section>

        <!-- Favourite Musicians Section -->
        <section class="py-16">
            <h2 class="text-4xl mb-8">Favourite Musicians</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="relative">
                    <img src="/api/placeholder/400/300" alt="Musician" class="w-full object-cover md:h-64 h-48">
                    <div class="mt-4">
                        <h3 class="text-2xl">Artist Name</h3>
                        <a href="#" class="text-blue-600">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Favourite Movies Section -->
        <section class="py-16">
            <h2 class="text-4xl mb-8">Favourite Movies</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div>
                    <h3 class="text-2xl mb-4">Movie Title</h3>
                    <a href="#" class="text-blue-600">Streaming Platform</a>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="py-8 text-center">
            <p>&copy; 2024 Izhak. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>