<!DOCTYPE html>
<html lang="fr" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>En-tete - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
		@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

:root {
    --primary-color: #3B82F6;
    --secondary-color: #10B981;
}

body {
    color: #FFFFFF;
}

.header {
    background-color: #000000;
    position: fixed;
    width: 100%;
    top: 0;
    z-index: 1001;
}

.menu-item {
    position: relative;
    transition: all 0.3s ease;
}

.menu-item::after {
    content: '';
    position: absolute;
    width: 0;
    height: 2px;
    bottom: -2px;
    left: 50%;
    background-color: var(--primary-color);
    transition: all 0.3s ease;
}

.menu-item:hover::after,
.menu-item:focus::after {
    width: 100%;
    left: 0;
}

.desktop-menu {
    position: fixed;
    top: 64px;
    left: 0;
    width: 100%;
    height: calc(100% - 64px);
    background: #000000;
    transform: scale(0.9);
    opacity: 0;
    visibility: hidden;
    transition: transform 0.3s ease-in-out, opacity 0.3s ease-in-out, visibility 0.3s ease-in-out;
    overflow-y: auto;
    z-index: 1000;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}

.desktop-menu.active {
    transform: scale(1);
    opacity: 1;
    visibility: visible;
}

.desktop-menu-item {
    margin-bottom: 1rem;
    text-align: center;
}

.desktop-menu-item > button {
    font-size: 2rem;
    color: skyblue;
    background: none;
    border: none;
    padding: 0.5rem 1rem;
    transition: color 0.3s ease;
}

.desktop-menu-item > button:hover,
.desktop-menu-item > button:focus {
    color: #FFFFFF;
}

.desktop-submenu {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease-in-out;
}

.desktop-submenu.active {
    max-height: 500px;
}

.desktop-submenu a {
    display: block;
    font-size: 1.5rem;
    color: #FFFFFF;
    padding: 0.5rem 0;
    transition: color 0.2s ease-in-out;
}

.desktop-submenu a:hover,
.desktop-submenu a:focus {
    color: var(--primary-color);
}

.zajidhiadj {
    width: 30px;
    height: 20px;
    position: relative;
    transform: rotate(0deg);
    transition: .5s ease-in-out;
    cursor: pointer;
}

.zajidhiadj span {
    display: block;
    position: absolute;
    height: 3px;
    width: 100%;
    background: #FFFFFF;
    border-radius: 9px;
    opacity: 1;
    left: 0;
    transform: rotate(0deg);
    transition: .25s ease-in-out;
}

.zajidhiadj span:nth-child(1) {
    top: 0px;
}

.zajidhiadj span:nth-child(2) {
    top: 10px;
}

.zajidhiadj.open span:nth-child(1) {
    top: 10px;
    transform: rotate(135deg);
}

.zajidhiadj.open span:nth-child(2) {
    top: 10px;
    transform: rotate(-135deg);
}
    </style>
</head>
<body class="h-full bg-gray-900">
    <header class="header fixed w-full top-0">
        <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <div class="flex-shrink-0 flex items-center">
                    <a href="/fr/" class="flex items-center">
                        <img class="h-8 w-auto" src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                    </a>
                </div>
                <div class="flex items-center">
                    <a href="https://auth.imators.com/fr" class="bg-gradient-to-r from-primary-color to-secondary-color text-white px-6 py-2 rounded-full text-sm font-medium transition-all duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-color">
                        Imators account
                    </a>
                    <button id="desktop-menu-button" class="zajidhiadj ml-4" aria-label="Basculer le menu">
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </nav>
        <div id="desktop-menu" class="desktop-menu">
            <!-- Les elements du menu de bureau seront inseres dynamiquement ici -->
        </div>
    </header>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const menuItems = [
                { 
                    name: 'Produits', 
                    submenu: [
                        { name: 'Progm', link: '/fr/progm' },
                        { name: 'OhMyPanel', link: 'https://ohmypanel.com' },
                        { name: 'Owtfitt', link: 'https://owtiftt.com' },
                        { name: 'ForMore', link: 'https://formore.tv' },
                        { name: 'Gemance', link: 'https://gemance.com' }
                    ]
                },
                { 
                    name: 'Outils pour developpeurs', 
                    submenu: [
                        { name: 'Systemen Imators', link: 'https://imators.systems' },
                        { name: 'Imators Ontwikkelaar', link: 'https://developer.imators.com' },
                    ]
                },
                { 
                    name: 'Het bedrijf', 
                    submenu: [
                        { name: 'Geschiedenis van Imators', link: '/fr/about-us' },
                        { name: 'Klantenondersteuning', link: '/fr/contact-us' }
                    ]
                }
            ];
            const desktopMenu = document.getElementById('desktop-menu');
            const desktopMenuButton = document.getElementById('desktop-menu-button');
            const header = document.querySelector('.header');

            function createMenuItem(item) {
                const menuItem = document.createElement('div');
                menuItem.className = 'desktop-menu-item';
                
                menuItem.innerHTML = `
                    <button class="text-skyblue hover:text-white text-2xl font-medium focus:outline-none focus:text-white w-full">
                        ${item.name}
                    </button>
                    <div class="desktop-submenu">
                        ${item.submenu.map(subItem => `
                            <a href="${subItem.link}" class="text-xl">
                                ${subItem.name}
                            </a>
                        `).join('')}
                    </div>
                `;

                const button = menuItem.querySelector('button');
                const submenu = menuItem.querySelector('.desktop-submenu');

                button.addEventListener('click', () => {
                    submenu.classList.toggle('active');
                });

                return menuItem;
            }

            menuItems.forEach(item => {
                desktopMenu.appendChild(createMenuItem(item));
            });

            desktopMenuButton.addEventListener('click', () => {
                desktopMenu.classList.toggle('active');
                desktopMenuButton.classList.toggle('open');
                document.body.style.overflow = desktopMenu.classList.contains('active') ? 'hidden' : '';
            });

            // Effet de defilement
            let lastScrollTop = 0;
            const scrollThreshold = 50;

            window.addEventListener('scroll', () => {
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (scrollTop > 0) {
                    header.classList.add('scrolled');
                } else {
                    header.classList.remove('scrolled');
                }

                if (Math.abs(scrollTop - lastScrollTop) > scrollThreshold) {
                    if (scrollTop > lastScrollTop && scrollTop > header.offsetHeight) {
                        header.classList.add('hidden');
                    } else {
                        header.classList.remove('hidden');
                    }
                    lastScrollTop = scrollTop;
                }
            }, { passive: true });
        });
    </script>
</body>
</html>