<?php
$dotenv = parse_ini_file('.env');
$event_date = new DateTime($dotenv['EVENT_DATE']);
$address = $dotenv['EVENT_ADDRESS'];
$latitude = $dotenv['EVENT_LAT'];
$longitude = $dotenv['EVENT_LONG'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $dotenv['EVENT_TITLE']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Outfit:wght@200;300;400&display=swap">
    <style>
        .smooth-scroll { scroll-behavior: smooth; }
        .countdown { font-variant-numeric: tabular-nums; }
    </style>
</head>
<body class="bg-white font-['Outfit'] text-neutral-900 smooth-scroll">
    <div class="fixed top-0 left-0 right-0 h-[65vh] md:h-screen z-0">
        <div class="grid grid-cols-2 md:grid-cols-4 h-full">
            <div class="relative overflow-hidden">
                <img src="/image1.jpg" class="absolute inset-0 w-full h-full object-cover opacity-90" alt="">
            </div>
            <div class="relative overflow-hidden">
                <img src="/image2.jpg" class="absolute inset-0 w-full h-full object-cover opacity-90" alt="">
            </div>
            <div class="relative overflow-hidden hidden md:block">
                <img src="/image3.jpg" class="absolute inset-0 w-full h-full object-cover opacity-90" alt="">
            </div>
            <div class="relative overflow-hidden hidden md:block">
                <img src="/image4.jpg" class="absolute inset-0 w-full h-full object-cover opacity-90" alt="">
            </div>
        </div>
    </div>

    <main class="relative z-10 mt-[60vh] md:mt-[95vh] bg-white min-h-screen">
        <div class="max-w-[90%] md:max-w-[1200px] mx-auto">
            <div class="grid md:grid-cols-2 gap-24 py-24">
                <div class="space-y-20">
                    <div class="space-y-8">
                        <h1 class="text-4xl md:text-5xl font-extralight tracking-tight">
                            <?php echo $dotenv['EVENT_TITLE']; ?>
                        </h1>
                        <p class="text-neutral-500 leading-relaxed font-light text-lg">
                            <?php echo $dotenv['EVENT_DESCRIPTION']; ?>
                        </p>
                    </div>

                    <div class="countdown font-extralight text-5xl md:text-7xl tracking-tighter flex justify-between w-full md:w-3/4" id="countdown">
                        <span class="countdown-days">00</span>
                        <span class="countdown-hours">00</span>
                        <span class="countdown-minutes">00</span>
                        <span class="countdown-seconds">00</span>
                    </div>
                </div>

                <div class="aspect-[4/5] md:aspect-square relative rounded-lg overflow-hidden" id="map"></div>
            </div>
        </div>
    </main>

    <script>
    function updateCountdown() {
        const eventDate = new Date('<?php echo $event_date->format('Y-m-d H:i:s'); ?>');
        const now = new Date();
        const diff = eventDate - now;

        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        document.querySelector('.countdown-days').textContent = String(days).padStart(2, '0');
        document.querySelector('.countdown-hours').textContent = String(hours).padStart(2, '0');
        document.querySelector('.countdown-minutes').textContent = String(minutes).padStart(2, '0');
        document.querySelector('.countdown-seconds').textContent = String(seconds).padStart(2, '0');
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();

    mapkit.init({
        authorizationCallback: function(done) {
            done('<?php echo $dotenv['MAPKIT_TOKEN']; ?>');
        }
    });

    const map = new mapkit.Map('map', {
        mapType: mapkit.Map.MapTypes.MutedStandard,
        showsZoomControl: false,
        showsMapTypeControl: false,
        showsCompass: false,
        showsScale: false
    });
    
    const coordinate = new mapkit.Coordinate(<?php echo $latitude; ?>, <?php echo $longitude; ?>);
    const annotation = new mapkit.MarkerAnnotation(coordinate, {
        color: "#000000",
        selected: true,
        animates: true
    });

    map.colorScheme = mapkit.Map.ColorSchemes.Light;
    map.addAnnotation(annotation);
    map.setCenterAnimated(coordinate, true);
    map.setRegionAnimated(new mapkit.CoordinateRegion(
        coordinate,
        new mapkit.CoordinateSpan(0.005, 0.005)
    ));
    </script>
</body>
</html>