<?php
$transparent_header = true;

require_once 'db.php';

$sql = "SELECT id, title, content, image_url, DATE_FORMAT(date_created, '%d/%m/%Y') AS formatted_date, 
               author FROM news_blog ORDER BY date_created DESC LIMIT 6";
$stmt = $conn->prepare($sql);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="verified">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="b467e8c1-b13e-4744-80ac-d625ad1403b4"></script>
    
    
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:domain" content="imators.com">
    <meta name="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            overflow-x: hidden;
        }
        
        .section {
            position: relative;
            width: 100%;
            min-height: 85vh;
            overflow: hidden;
        }

        .mini-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            overflow: hidden;
        }
        
        .section-divider {
            height: 1px;
            width: 100%;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        
        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }
        
        .grid-bg {
            background: linear-gradient(90deg,rgba(255,255,255,.1) 1px,transparent 0), 
                        linear-gradient(rgba(255,255,255,.1) 1px,transparent 0);
            background-size: 40px 40px;
        }
        
        .premium-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            background-color: #fff;
            overflow: hidden;
        }
        
        .transparent-button {
            opacity: 0;
            transition: opacity 0.5s ease;
        }
        
        .transparent-button.visible {
            opacity: 1;
        }
        
        .premium-grid {
            background: linear-gradient(90deg,rgba(0,0,0,.03) 1px,transparent 0), 
                      linear-gradient(rgba(0,0,0,.03) 1px,transparent 0);
            background-size: 30px 30px;
        }

        .stacked-hero-section {
            position: relative;
            height: 100vh;
            width: 100vw;
            overflow: hidden;
            display: flex;
            align-items: center;
            flex-shrink: 0;
        }

        .stacked-container {
            position: relative;
        }

        .horizontal-scroll-wrapper {
            position: relative;
            height: 100vh;
            overflow: hidden;
        }

        .horizontal-sections {
            display: flex;
            width: fit-content;
            height: 100vh;
        }

        .minimal-cookie-box {
            position: fixed;
            bottom: 2rem;
            right: 2rem;
            max-width: 320px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            padding: 1.5rem;
            color: white;
            z-index: 1000;
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.4s ease;
        }

        .minimal-cookie-box.show {
            opacity: 1;
            transform: translateY(0);
        }

        .cookie-minimized {
            position: fixed;
            bottom: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px 8px 0 0;
            padding: 0.5rem 1rem;
            color: white;
            font-size: 0.75rem;
            cursor: pointer;
            z-index: 1000;
            opacity: 0;
            transition: all 0.3s ease;
        }

        .cookie-minimized.show {
            opacity: 1;
        }

        .cookie-minimized:hover {
            background: rgba(255, 255, 255, 0.15);
        }

        @media (max-width: 768px) {
            .minimal-cookie-box {
                left: 1rem;
                right: 1rem;
                max-width: none;
            }
        }
    </style>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                document.getElementById('redirect-button').classList.add('visible');
            }, 5000);
        });
    </script>
</head>
<body class="bg-black">
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MNDDTWSM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    
    <?php include 'src/header.php'; ?>
    

    <style>
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-image {
            animation: fadeInUp 1s ease-out;
        }
        
        .fade-in-title {
            animation: fadeInUp 1s ease-out 0.3s both;
        }
        
        .fade-in-description {
            animation: fadeInUp 1s ease-out 0.6s both;
        }
        
        .fade-in-date {
            animation: fadeInUp 1s ease-out 0.9s both;
        }
        
        .fade-in-button {
            animation: fadeInUp 1s ease-out 1.2s both;
        }
    </style>

<div class="stacked-container">

  <div class="horizontal-scroll-wrapper">
    <div class="horizontal-sections">

      <section class="stacked-hero-section">
        <img src="IMG_8743.jpg" alt="Fond" class="absolute inset-0 w-full h-full object-cover filter brightness-75">
        
        <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
          
          <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
            <ul class="flex flex-col gap-4 text-white">
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For everyday</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the business</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the professionnel</a></li>
            </ul>
          </div>
          
          <div class="mb-12 self-start text-white max-w-sm">
            <div class="w-12 h-px bg-white mb-6"></div>
            <h1 class="text-3xl md:text-5xl font-extralight mb-5">Every moment,<br> marked by you.</h1>
            <p class="text-sm md:text-base font-light mb-8">Our online and physical product collection is designed so that every detail of your daily life reaches the perfection you deserve</p>
            <a href="/about-us" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">About the enterprise</a>
          </div>
          
        </div>
      </section>

      <section class="stacked-hero-section">
        <img src="https://images.unsplash.com/photo-1441986300917-64674bd600d8?w=1920" alt="Technology" class="absolute inset-0 w-full h-full object-cover filter brightness-50">
        
        <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
          
          <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
          </div>
          
        <div class="mb-12 self-start text-white max-w-sm">
        <div class="w-12 h-px bg-white mb-6"></div>
        <h1 class="text-3xl md:text-5xl font-extralight mb-5">parmovie</h1>
        <p class="text-sm md:text-base font-light mb-8">Get the perfect film of an evening that won't be ruined because you were looking for more than just fun.</p>
        <div class="flex items-center gap-4">
            <a href="/products" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">View the app</a>
            <button class="w-12 h-12 rounded-full border border-white hover:bg-white transition-all flex items-center justify-center group overflow-hidden">
            <img src="ton-image.svg" alt="Icon" class="w-6 h-6 transition-transform group-hover:scale-110 filter brightness-0 invert group-hover:brightness-100 group-hover:invert-0">
            </button>
        </div>
        </div>
          
        </div>
      </section>

      <section class="stacked-hero-section">
        <img src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?w=1920" alt="Innovation" class="absolute inset-0 w-full h-full object-cover filter brightness-50">
        
        <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
          
          <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
            <ul class="flex flex-col gap-4 text-white">
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Innovation lab</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">R&D center</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Future projects</a></li>
            </ul>
          </div>
          
          <div class="mb-12 self-start text-white max-w-sm">
            <div class="w-12 h-px bg-white mb-6"></div>
            <h1 class="text-3xl md:text-5xl font-extralight mb-5">Innovation<br> without limits.</h1>
            <p class="text-sm md:text-base font-light mb-8">We push the boundaries of what's possible, creating solutions that don't just solve today's problems but tomorrow's challenges</p>
            <a href="/innovation" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">See innovation</a>
          </div>
          
        </div>
      </section>

      <section class="stacked-hero-section">
        <img src="https://images.unsplash.com/photo-1504384308090-c894fdcc538d?w=1920" alt="Community" class="absolute inset-0 w-full h-full object-cover filter brightness-50">
        
        <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
          
          <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
            <ul class="flex flex-col gap-4 text-white">
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Community hub</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">User stories</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Feedback</a></li>
            </ul>
          </div>
          
          <div class="mb-12 self-start text-white max-w-sm">
            <div class="w-12 h-px bg-white mb-6"></div>
            <h1 class="text-3xl md:text-5xl font-extralight mb-5">Built by you,<br> for you.</h1>
            <p class="text-sm md:text-base font-light mb-8">Every product we create is shaped by our community. Your feedback, your needs, your vision drives our innovation forward</p>
            <a href="/community" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">Join community</a>
          </div>
          
        </div>
      </section>

      <section class="stacked-hero-section">
        <img src="https://images.unsplash.com/photo-1451187580459-43490279c0fa?w=1920" alt="Future" class="absolute inset-0 w-full h-full object-cover filter brightness-50">
        
        <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
          
          <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
            <ul class="flex flex-col gap-4 text-white">
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Vision 2030</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Sustainability</a></li>
              <li><a href="#" class="text-sm md:text-base hover:underline transition-all">Impact</a></li>
            </ul>
          </div>
          
          <div class="mb-12 self-start text-white max-w-sm">
            <div class="w-12 h-px bg-white mb-6"></div>
            <h1 class="text-3xl md:text-5xl font-extralight mb-5">Your future<br> starts today.</h1>
            <p class="text-sm md:text-base font-light mb-8">The choices we make today shape the world of tomorrow. Join us in creating a future that's sustainable, inclusive, and innovative</p>
            <a href="/future" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">Shape the future</a>
          </div>
          
        </div>
      </section>

    </div>
  </div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const lights = document.getElementById('lights');
    const logoContainer = document.getElementById('logo-container');
    const title = document.getElementById('title');
    const description = document.getElementById('description');
    const buttonsContainer = document.getElementById('buttons-container');
    
    setTimeout(() => {
        if(lights) {
            lights.style.opacity = '1';
            lights.style.transition = 'opacity 1.5s ease';
        }
    }, 800);
    
    const animateElement = (element, delay) => {
        if(element) {
            setTimeout(() => {
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
                element.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            }, delay);
        }
    };
    
    animateElement(logoContainer, 1000);
    animateElement(title, 1500);
    animateElement(description, 2000);
    animateElement(buttonsContainer, 2500);
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    
    const horizontalSections = document.querySelector('.horizontal-sections');
    const sections = document.querySelectorAll('.stacked-hero-section');
    
    if (horizontalSections && sections.length > 0) {
        const totalWidth = sections.length * window.innerWidth;
        
        gsap.to(horizontalSections, {
            x: -(totalWidth - window.innerWidth),
            ease: "none",
            scrollTrigger: {
                trigger: ".horizontal-scroll-wrapper",
                start: "top top",
                end: () => `+=${totalWidth}`,
                pin: true,
                scrub: 1,
                snap: {
                    snapTo: (progress) => {
                        const snapPoints = [];
                        for (let i = 0; i < sections.length; i++) {
                            snapPoints.push(i / (sections.length - 1));
                        }
                        return snapPoints.reduce((prev, curr) => 
                            Math.abs(curr - progress) < Math.abs(prev - progress) ? curr : prev
                        );
                    },
                    duration: 0.5,
                    delay: 0.2
                }
            }
        });
    }
});
</script>

<footer><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

<div class="minimal-cookie-box" id="cookieBox">
    <p class="text-sm font-light mb-4">
        Nous utilisons uniquement les cookies essentiels au fonctionnement du site. 
        <a href="./terms-of-use" class="underline opacity-75 hover:opacity-100">En savoir plus</a>
    </p>
    <div class="flex gap-3">
        <button class="text-sm underline opacity-75 hover:opacity-100" onclick="showCookieDetails()">
            Détails
        </button>
        <button class="bg-white text-black px-4 py-1 text-sm hover:bg-gray-100 transition-colors" onclick="acceptCookies()">
            Accepter
        </button>
    </div>
</div>

<div class="cookie-minimized" id="cookieMinimized" onclick="showCookieBox()">
    Cookies
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    const cookieMinimized = document.getElementById('cookieMinimized');
    
    cookieBox.style.transform = 'translateY(20px)';
    cookieBox.style.opacity = '0';
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      cookieMinimized.classList.add('show');
      localStorage.setItem('cookiesAccepted', 'true');
    }, 400);
  }

  function showCookieBox() {
    const cookieBox = document.getElementById('cookieBox');
    const cookieMinimized = document.getElementById('cookieMinimized');
    
    cookieMinimized.classList.remove('show');
    cookieBox.style.display = 'block';
    
    setTimeout(() => {
      cookieBox.classList.add('show');
    }, 10);
  }

  function showCookieDetails() {
    window.open('./terms-of-use', '_blank');
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    const cookieMinimized = document.getElementById('cookieMinimized');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
      cookieMinimized.classList.add('show');
    } else {
      setTimeout(() => {
        cookieBox.classList.add('show');
      }, 2000);
    }
  }
</script>
</body>
</html>