<?php
require_once 'functions.php';
checkLogin();

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$profile = $id ? getProfile($id) : [];
$errors = [];
$success = false;

$isEdit = !empty($profile);
$pageTitle = $isEdit ? 'Modifier le profil' : 'Créer un nouveau profil';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'full_name' => $_POST['full_name'] ?? '',
        'email' => $_POST['email'] ?? '',
        'phone' => $_POST['phone'] ?? '',
        'address' => $_POST['address'] ?? '',
        'birth_date' => $_POST['birth_date'] ?? '',
        'occupation' => $_POST['occupation'] ?? '',
        'notes' => $_POST['notes'] ?? ''
    ];
    
    if (empty($data['full_name'])) {
        $errors[] = 'Le nom complet est requis';
    }
    
    if (empty($data['email'])) {
        $errors[] = 'L\'email est requis';
    } else if (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'L\'email n\'est pas valide';
    }
    
    if (empty($errors)) {
        if ($isEdit) {
            updateProfile($id, $data);
            $success = true;
        } else {
            $id = createProfile($data);
            header("Location: profile.php?id=$id");
            exit();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - <?php echo $pageTitle; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="min-h-screen flex flex-col">
        <header class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center">
                    <h1 class="text-2xl font-light">PEERKINTON</h1>
                </div>
                <nav class="flex space-x-8">
                    <a href="index.php" class="text-gray-600 hover:text-blue-600 font-light">Accueil</a>
                    <a href="search.php" class="text-gray-600 hover:text-blue-600 font-light">Recherche</a>
                    <a href="logout.php" class="text-gray-600 hover:text-red-600 font-light">Déconnexion</a>
                </nav>
            </div>
        </header>

        <main class="flex-grow max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="mb-8">
                <h2 class="text-2xl font-light"><?php echo $pageTitle; ?></h2>
            </div>

            <?php if (!empty($errors)): ?>
                <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                    <div class="font-medium text-red-700">Des erreurs sont survenues :</div>
                    <ul class="mt-2 ml-4 text-sm text-red-700 list-disc">
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo htmlspecialchars($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
                    <div class="font-medium text-green-700">Le profil a été mis à jour avec succès !</div>
                </div>
            <?php endif; ?>

            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <form method="POST" action="">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="full_name" class="block text-sm font-light mb-2">Nom complet *</label>
                            <input 
                                type="text" 
                                id="full_name" 
                                name="full_name" 
                                value="<?php echo htmlspecialchars($profile['full_name'] ?? ''); ?>" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                required
                            >
                        </div>
                        
                        <div>
                            <label for="email" class="block text-sm font-light mb-2">Email *</label>
                            <input 
                                type="email" 
                                id="email" 
                                name="email" 
                                value="<?php echo htmlspecialchars($profile['email'] ?? ''); ?>" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                required
                            >
                        </div>
                        
                        <div>
                            <label for="phone" class="block text-sm font-light mb-2">Téléphone</label>
                            <input 
                                type="text" 
                                id="phone" 
                                name="phone" 
                                value="<?php echo htmlspecialchars($profile['phone'] ?? ''); ?>" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            >
                        </div>
                        
                        <div>
                            <label for="birth_date" class="block text-sm font-light mb-2">Date de naissance</label>
                            <input 
                                type="date" 
                                id="birth_date" 
                                name="birth_date" 
                                value="<?php echo htmlspecialchars($profile['birth_date'] ?? ''); ?>" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            >
                        </div>
                        
                        <div>
                            <label for="occupation" class="block text-sm font-light mb-2">Profession</label>
                            <input 
                                type="text" 
                                id="occupation" 
                                name="occupation" 
                                value="<?php echo htmlspecialchars($profile['occupation'] ?? ''); ?>" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            >
                        </div>
                    </div>
                    
                    <div class="mt-6">
                        <label for="address" class="block text-sm font-light mb-2">Adresse</label>
                        <input 
                            type="text" 
                            id="address" 
                            name="address" 
                            value="<?php echo htmlspecialchars($profile['address'] ?? ''); ?>" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        >
                    </div>
                    
                    <div class="mt-6">
                        <label for="notes" class="block text-sm font-light mb-2">Notes</label>
                        <textarea 
                            id="notes" 
                            name="notes" 
                            rows="6" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                        ><?php echo htmlspecialchars($profile['notes'] ?? ''); ?></textarea>
                    </div>
                    
                    <div class="mt-8 flex justify-between">
                        <a href="<?php echo $isEdit ? "profile.php?id=$id" : 'search.php'; ?>" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-md">
                            Annuler
                        </a>
                        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-md">
                            <?php echo $isEdit ? 'Enregistrer les modifications' : 'Créer le profil'; ?>
                        </button>
                    </div>
                </form>
            </div>
        </main>

        <footer class="bg-white border-t border-gray-200 py-6 mt-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <p class="text-center text-sm text-gray-500">
                    &copy; <?php echo date('Y'); ?> Peerkinton - Centre privé d'analyse de profils - Tous droits réservés
                </p>
            </div>
        </footer>
    </div>
</body>
</html>