<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant.">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Exile&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Archivo+Black&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Urbanist', serif;
            letter-spacing: -0.01em;
        }
        .card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-6px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.08);
        }
        .dark .card-hover:hover {
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }
        .txt-waterloo {
            font-family: "Exile", serif;
            font-weight: 400;
        }
        .txt-ad-title {
            font-family: "Abril Fatface", serif;
            font-weight: 400;
        }
        .police-sandro {
            font-family: "Archivo Black", sans-serif;
            font-weight: 400;
        }
        .deli-gradient {
            background: linear-gradient(90deg, 
                #a9d7d0 0%, 
                #a9d7d0 25%, 
                #ef6f56 25%, 
                #ef6f56 50%, 
                #bbbae3 50%, 
                #bbbae3 75%, 
                #ffe076 75%, 
                #ffe076 100%);
        }
        .pub-image-bg {
            background-image: url('https://www.pa-sport.fr/wp-content/uploads/unnamed-32-2.jpg');
            background-size: cover;
            background-position: center;
        }
    </style>
</head>
<body class="bg-stone-50 dark:bg-stone-950 transition-colors duration-300">
<?php include 'header.php'; ?>
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
        
        document.addEventListener('DOMContentLoaded', function() {
            const pubContainer = document.getElementById('pub-container');
            
            let visitCount = localStorage.getItem('visitCount');
            
            if (!visitCount) {
                visitCount = 1;
            } else {
                visitCount = parseInt(visitCount) + 1;
            }
            
            localStorage.setItem('visitCount', visitCount);
            
            if (visitCount % 2 === 1) {
                pubContainer.href = "https://vertchasseur.com/shop-details?id=3";
                pubContainer.classList.add('deli-gradient');
                pubContainer.classList.remove('pub-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
                        <div class="absolute top-6 right-6 bg-white/10 text-white text-sm px-3 py-1.5 rounded-full backdrop-blur-sm">
                            <a class="underline" href="https://aktascorp.com/ads">Publicité</a>
                        </div>
                        <div class="max-w-xs space-y-4">
                            <h2 class="text-white text-3xl font-medium leading-tight">
                                Delitraiteur,<br> 
                                le coin de douceur<br> 
                                de Vert Chasseur
                            </h2>
                            <p class="text-white/90 text-base leading-relaxed">
                                Smile and quality, with simplicity.
                            </p>
                            <button class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors">
                                Découvrir
                            </button>
                        </div>
                    </div>
                `;
            } else {
                pubContainer.href = "https://theaceclubparis.com/en-be";
                pubContainer.classList.remove('deli-gradient');
                pubContainer.classList.add('pub-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
                        <div class="absolute top-6 right-6 bg-white/10 text-white text-sm px-3 py-1.5 rounded-full backdrop-blur-sm">
                            <a class="underline" href="https://aktascorp.com/ads">Publicité</a>
                        </div>
                        <div class="max-w-xs space-y-4">
                            <h2 class="text-white text-3xl font-medium leading-tight">
                                Discover<br> 
                                The Ace Club, and preserve the legacy.
                            </h2>
                            <p class="text-white/90 text-base leading-relaxed">
                                Marque de vêtements de sport et de style de vie haut de gamme
                            </p>
                            <button class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors">
                                Explorer
                            </button>
                        </div>
                    </div>
                `;
            }
        });
    </script>

    <main class="min-h-screen flex flex-col items-center justify-center px-4 py-20">
        <div class="text-center max-w-3xl mx-auto mb-20">
            <p class="text-stone-500 dark:text-stone-400 text-sm tracking-wider uppercase mb-6 font-light">Waterloo · Wallonie</p>
            <h1 class="text-5xl md:text-7xl font-light mb-8 text-stone-900 dark:text-white tracking-tight">Bienvenue à <span class="txt-waterloo font-extrabold">Waterloo</span></h1>
            <p class="text-xl text-stone-600 dark:text-stone-300 leading-relaxed max-w-xl mx-auto font-light">
                Un havre de paix, qui ne s'arretera jamais.
            </p>
        </div>

        <div class="w-full max-w-6xl mx-auto grid md:grid-cols-2 lg:grid-cols-3 gap-8 px-4">
            <a id="pub-container" class="card-hover aspect-square group block rounded-2xl overflow-hidden relative">
            </a>
            
            <a href="https://vertchasseur.com/shop" class="card-hover aspect-square group block rounded-2xl p-8 bg-white dark:bg-stone-900 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-stone-900 dark:text-white">Commerces & Restaurants</h2>
                        <p class="text-stone-600 dark:text-stone-300 leading-relaxed">Découvrez les établissements qui font la richesse de notre quartier avec une qualité irréprochable dans la majorité.</p>
                    </div>
                    <div class="flex items-center text-stone-900 dark:text-white mt-6 group-hover:translate-x-1 transition-transform">
                        <span class="mr-2 text-sm font-medium">Explorer</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </div>
                </div>
            </a>

            <div class="card-hover aspect-square block rounded-2xl p-8 bg-white dark:bg-stone-900 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-stone-900 dark:text-white"><span class="txt-chasseur">Le poème du jour</span></h2>
                        <p class="text-stone-600 dark:text-stone-300 leading-relaxed">
                            Dans le silence d'un matin pur,<br>
                            La brise chante, douce et sûre.<br>
                            Les arbres dansent, pleins de lumière,<br>
                            Offrant leur paix à l'univers.
                        </p>
                    </div>
                    <p class="text-right text-stone-500 dark:text-stone-400 text-sm italic mt-6">Par Alois Passareiro</p>
                </div>
            </div>
        </div>
    </main>

    <footer class="w-full py-6 mt-10 border-t border-stone-200 dark:border-stone-800">
        <p class="text-xs text-stone-500 dark:text-stone-400 text-center">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-stone-700 dark:hover:text-stone-300">Confidentialité</a></p>
    </footer>
</body>
</html>