<?php
$dotenv = parse_ini_file('.env');
$event_date = new DateTime($dotenv['EVENT_DATE']);
$address = $dotenv['EVENT_ADDRESS'];
$latitude = $dotenv['EVENT_LAT'];
$longitude = $dotenv['EVENT_LONG'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événement</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://js.api.here.com/v3/3.1/mapsjs-core.js"></script>
    <script src="https://js.api.here.com/v3/3.1/mapsjs-service.js"></script>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 py-8">
            <div class="aspect-square bg-white rounded-lg shadow-md overflow-hidden">
                <img src="/image1.jpg" class="w-full h-full object-cover" alt="Image 1">
            </div>
            <div class="aspect-square bg-white rounded-lg shadow-md overflow-hidden">
                <img src="/image2.jpg" class="w-full h-full object-cover" alt="Image 2">
            </div>
            <div class="aspect-square bg-white rounded-lg shadow-md overflow-hidden">
                <img src="/image3.jpg" class="w-full h-full object-cover" alt="Image 3">
            </div>
            <div class="aspect-square bg-white rounded-lg shadow-md overflow-hidden">
                <img src="/image4.jpg" class="w-full h-full object-cover" alt="Image 4">
            </div>
        </div>

        <div class="flex flex-col md:flex-row gap-8 py-8">
            <div class="w-full md:w-1/2">
                <h1 class="text-4xl font-bold mb-4"><?php echo $dotenv['EVENT_TITLE']; ?></h1>
                <p class="text-gray-600 mb-8"><?php echo $dotenv['EVENT_DESCRIPTION']; ?></p>
                
                <div class="bg-white rounded-full px-6 py-4 shadow-md inline-block" id="countdown">
                    <span class="countdown-days font-bold">00</span>j 
                    <span class="countdown-hours font-bold">00</span>h 
                    <span class="countdown-minutes font-bold">00</span>m 
                    <span class="countdown-seconds font-bold">00</span>s
                </div>
            </div>
            
            <div class="w-full md:w-1/2 h-96 bg-white rounded-lg shadow-md" id="map"></div>
        </div>
    </div>

    <script>
    function updateCountdown() {
        const eventDate = new Date('<?php echo $event_date->format('Y-m-d H:i:s'); ?>');
        const now = new Date();
        const diff = eventDate - now;

        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        document.querySelector('.countdown-days').textContent = String(days).padStart(2, '0');
        document.querySelector('.countdown-hours').textContent = String(hours).padStart(2, '0');
        document.querySelector('.countdown-minutes').textContent = String(minutes).padStart(2, '0');
        document.querySelector('.countdown-seconds').textContent = String(seconds).padStart(2, '0');
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();

    const platform = new H.service.Platform({
        apikey: '<?php echo $dotenv['HERE_API_KEY']; ?>'
    });

    const defaultLayers = platform.createDefaultLayers();
    const map = new H.Map(
        document.getElementById('map'),
        defaultLayers.vector.normal.map,
        {
            center: { lat: <?php echo $latitude; ?>, lng: <?php echo $longitude; ?> },
            zoom: 15
        }
    );

    const marker = new H.map.Marker({ lat: <?php echo $latitude; ?>, lng: <?php echo $longitude; ?> });
    map.addObject(marker);
    </script>
</body>
</html>