<?php
$transparent_header = true;

require_once 'db.php';

$sql = "SELECT id, title, content, image_url, DATE_FORMAT(date_created, '%d/%m/%Y') AS formatted_date, 
               author FROM news_blog ORDER BY date_created DESC LIMIT 6";
$stmt = $conn->prepare($sql);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="verified">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="b467e8c1-b13e-4744-80ac-d625ad1403b4"></script>
    
    
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:domain" content="imators.com">
    <meta name="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            overflow-x: hidden;
        }
        
        .section {
            position: relative;
            width: 100%;
            min-height: 85vh;
            overflow: hidden;
        }

        .mini-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            overflow: hidden;
        }
        
        .section-divider {
            height: 1px;
            width: 100%;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        
        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }
        
        .grid-bg {
            background: linear-gradient(90deg,rgba(255,255,255,.1) 1px,transparent 0), 
                        linear-gradient(rgba(255,255,255,.1) 1px,transparent 0);
            background-size: 40px 40px;
        }
        
        .premium-section {
            position: relative;
            width: 100%;
            min-height: 60vh;
            background-color: #fff;
            overflow: hidden;
        }
        
        .transparent-button {
            opacity: 0;
            transition: opacity 0.5s ease;
        }
        
        .transparent-button.visible {
            opacity: 1;
        }
        
        .premium-grid {
            background: linear-gradient(90deg,rgba(0,0,0,.03) 1px,transparent 0), 
                      linear-gradient(rgba(0,0,0,.03) 1px,transparent 0);
            background-size: 30px 30px;
        }

        .stacked-section {
            position: relative;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1;
        }

        .product-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            padding: 3rem;
            max-width: 500px;
            text-align: center;
            color: white;
        }

        .product-image {
            width: 200px;
            height: 200px;
            object-fit: cover;
            border-radius: 15px;
            margin: 0 auto 2rem;
        }

        @media (max-width: 768px) {
            .product-card {
                padding: 2rem;
                max-width: 350px;
                margin: 0 1rem;
            }
            
            .product-image {
                width: 150px;
                height: 150px;
            }
        }
    </style>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                document.getElementById('redirect-button').classList.add('visible');
            }, 5000);
        });
    </script>
</head>
<body class="bg-black">
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MNDDTWSM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    
    <?php include 'src/header.php'; ?>
    

    <style>
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-image {
            animation: fadeInUp 1s ease-out;
        }
        
        .fade-in-title {
            animation: fadeInUp 1s ease-out 0.3s both;
        }
        
        .fade-in-description {
            animation: fadeInUp 1s ease-out 0.6s both;
        }
        
        .fade-in-date {
            animation: fadeInUp 1s ease-out 0.9s both;
        }
        
        .fade-in-button {
            animation: fadeInUp 1s ease-out 1.2s both;
        }
    </style>

<section class="relative w-full h-screen overflow-hidden flex items-center">
  <img src="IMG_8743.jpg" alt="Fond" class="absolute inset-0 w-full h-full object-cover filter brightness-75">
  
  <div class="relative z-10 w-full h-full flex flex-col justify-between px-6 py-12 md:px-16">
    
    <div class="mt-20 self-start md:self-center md:text-right md:ml-auto">
      <ul class="flex flex-col gap-4 text-white">
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For everyday</a></li>
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the business</a></li>
        <li><a href="#" class="text-sm md:text-base hover:underline transition-all">For the professionnel</a></li>
      </ul>
    </div>
    
    <div class="mb-12 self-start text-white max-w-sm">
      <div class="w-12 h-px bg-white mb-6"></div>
      <h1 class="text-3xl md:text-5xl font-extralight mb-5">Every moment,<br> marked by you.</h1>
      <p class="text-sm md:text-base font-light mb-8">Our online and physical product collection is designed so that every detail of your daily life reaches the perfection you deserve</p>
      <a href="/about-us" class="rounded-full inline-block px-6 py-2 border border-white hover:bg-white hover:text-black transition-all">About the enterprise</a>
    </div>
    
  </div>
  
</section>

<div class="stacked-container">
  
  <section class="stacked-section" data-bg-color="#1a1a2e">
    <div class="product-card">
      <img src="https://images.unsplash.com/photo-1572635196237-14b3f281503f?w=400" alt="Product 1" class="product-image">
      <h2 class="text-2xl font-light mb-4">SmartWatch Pro</h2>
      <p class="text-gray-300 mb-6">L'avenir du temps, à ton poignet</p>
      <div class="text-3xl font-light mb-6">€299</div>
      <button class="bg-white text-black px-8 py-3 rounded-full hover:bg-gray-100 transition-all">Découvrir</button>
    </div>
  </section>

  <section class="stacked-section" data-bg-color="#2d1b69">
    <div class="product-card">
      <img src="https://images.unsplash.com/photo-1542291026-7eec264c27ff?w=400" alt="Product 2" class="product-image">
      <h2 class="text-2xl font-light mb-4">AirPods Elite</h2>
      <p class="text-gray-300 mb-6">Le son qui transforme ton quotidien</p>
      <div class="text-3xl font-light mb-6">€199</div>
      <button class="bg-white text-black px-8 py-3 rounded-full hover:bg-gray-100 transition-all">Découvrir</button>
    </div>
  </section>

  <section class="stacked-section" data-bg-color="#8b0000">
    <div class="product-card">
      <img src="https://images.unsplash.com/photo-1585386959984-a4155224a1ad?w=400" alt="Product 3" class="product-image">
      <h2 class="text-2xl font-light mb-4">Phone Infinity</h2>
      <p class="text-gray-300 mb-6">Redéfinir les limites de la communication</p>
      <div class="text-3xl font-light mb-6">€899</div>
      <button class="bg-white text-black px-8 py-3 rounded-full hover:bg-gray-100 transition-all">Découvrir</button>
    </div>
  </section>

  <section class="stacked-section" data-bg-color="#2c3e50">
    <div class="product-card">
      <img src="https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=400" alt="Product 4" class="product-image">
      <h2 class="text-2xl font-light mb-4">Laptop Vision</h2>
      <p class="text-gray-300 mb-6">La puissance créative sans compromis</p>
      <div class="text-3xl font-light mb-6">€1299</div>
      <button class="bg-white text-black px-8 py-3 rounded-full hover:bg-gray-100 transition-all">Découvrir</button>
    </div>
  </section>

  <section class="stacked-section" data-bg-color="#4a5568">
    <div class="product-card">
      <img src="https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=400" alt="Product 5" class="product-image">
      <h2 class="text-2xl font-light mb-4">Speaker Wave</h2>
      <p class="text-gray-300 mb-6">L'acoustique parfaite pour ton espace</p>
      <div class="text-3xl font-light mb-6">€399</div>
      <button class="bg-white text-black px-8 py-3 rounded-full hover:bg-gray-100 transition-all">Découvrir</button>
    </div>
  </section>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const lights = document.getElementById('lights');
    const logoContainer = document.getElementById('logo-container');
    const title = document.getElementById('title');
    const description = document.getElementById('description');
    const buttonsContainer = document.getElementById('buttons-container');
    
    setTimeout(() => {
        if(lights) {
            lights.style.opacity = '1';
            lights.style.transition = 'opacity 1.5s ease';
        }
    }, 800);
    
    const animateElement = (element, delay) => {
        if(element) {
            setTimeout(() => {
                element.style.opacity = '1';
                element.style.transform = 'translateY(0)';
                element.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            }, delay);
        }
    };
    
    animateElement(logoContainer, 1000);
    animateElement(title, 1500);
    animateElement(description, 2000);
    animateElement(buttonsContainer, 2500);
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    
    const sections = document.querySelectorAll('.stacked-section');
    
    sections.forEach((section, i) => {
        const isLast = i === sections.length - 1;
        
        if (!isLast) {
            gsap.set(section, { zIndex: sections.length - i });
        }
        
        gsap.to(section, {
            scrollTrigger: {
                trigger: section,
                start: "top top",
                end: "bottom top",
                scrub: true,
                pin: !isLast,
                pinSpacing: false,
                onUpdate: self => {
                    const bgColor = section.dataset.bgColor;
                    if (bgColor) {
                        document.body.style.backgroundColor = bgColor;
                    }
                }
            },
            ease: "none"
        });
        
        const card = section.querySelector('.product-card');
        gsap.fromTo(card, 
            { 
                y: 100, 
                opacity: 0,
                scale: 0.8 
            },
            {
                y: 0,
                opacity: 1,
                scale: 1,
                duration: 1,
                ease: "power2.out",
                scrollTrigger: {
                    trigger: section,
                    start: "top center",
                    end: "center center",
                    scrub: 1
                }
            }
        );
        
        if (!isLast) {
            gsap.to(card, {
                y: -100,
                opacity: 0,
                scale: 0.8,
                scrollTrigger: {
                    trigger: section,
                    start: "center top",
                    end: "bottom top",
                    scrub: 1
                }
            });
        }
    });
});
</script>

<footer><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>

<div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
  <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
    <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
    Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use<a>.
    </div>
    <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
    Accept
    </button>
  </div>
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    cookieBox.classList.add('opacity-0', 'translate-y-8');
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      localStorage.setItem('cookiesAccepted', 'true');
    }, 500);
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
    } else {
      setTimeout(() => {
        cookieBox.classList.remove('opacity-0', 'translate-y-8');
      }, 2000);
    }
  }
</script>
</body>
</html>