<?php
session_start();
require_once 'db.php';

// Si déjà connecté, rediriger vers l'index
if(isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}



// Traitement de la connexion
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    try {
        $db1 = getDB1Connection();
        $stmt = $db1->prepare("SELECT * FROM utilisateurs WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user && password_verify($password, $user['password'])) {
            if ($user['role'] == 1) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['email'] = $user['email'];
                $_SESSION['role_imators'] = $user['roleinimators'];
                $_SESSION['profile_picture'] = $user['profile-picture'];
                
                header('Location: index.php');
                exit;
            } else {
                $error = "Unauthorized access. You need proper permissions.";
            }
        } else {
            $error = "Invalid email or password.";
        }
    } catch (PDOException $e) {
        $error = "An error occurred. Please try again later.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Imators Systems</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900 min-h-screen flex flex-col">
    <!-- Header avec Dark Mode Toggle -->
    <header class="bg-white dark:bg-gray-800 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="h-10 w-auto">
                    <div>
                        <h1 class="text-xl font-semibold text-gray-900 dark:text-white">Imators</h1>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Reserved for the Imators team</p>
                    </div>
                </div>
                <button id="theme-toggle" class="p-2 rounded-lg bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors">
                    <i class="fas fa-sun dark:hidden"></i>
                    <i class="fas fa-moon hidden dark:block"></i>
                </button>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="flex-grow flex items-center justify-center px-4 py-12 sm:px-6 lg:px-8">
        <div class="max-w-md w-full">
            <!-- Login Box -->
            <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg px-8 py-6">
                <div class="text-center mb-8">
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Welcome Back</h2>
                    <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">Please sign in to your Imators account</p>
                </div>

                <?php if(isset($error)): ?>
                <div class="mb-6 bg-red-50 dark:bg-red-900/50 border-l-4 border-red-500 p-4 rounded">
                    <div class="flex items-center space-x-2">
                        <i class="fas fa-exclamation-circle text-red-500"></i>
                        <p class="text-sm text-red-600 dark:text-red-400"><?= htmlspecialchars($error) ?></p>
                    </div>
                </div>
                <?php endif; ?>

                <form method="POST" class="space-y-6">
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            <i class="fas fa-envelope mr-2"></i>Email Address
                        </label>
                        <input type="email" id="email" name="email" required
                               class="w-full px-4 py-2 rounded-lg bg-gray-50 dark:bg-gray-700 
                                      border border-gray-300 dark:border-gray-600
                                      focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white
                                      text-gray-900 dark:text-white"
                               placeholder="Enter your email">
                    </div>

                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            <i class="fas fa-key mr-2"></i>Password
                        </label>
                        <input type="password" id="password" name="password" required
                               class="w-full px-4 py-2 rounded-lg bg-gray-50 dark:bg-gray-700 
                                      border border-gray-300 dark:border-gray-600
                                      focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white
                                      text-gray-900 dark:text-white"
                               placeholder="Enter your password">
                    </div>

                    <button type="submit"
                            class="w-full flex items-center justify-center space-x-2 px-4 py-2 
                                   bg-black dark:bg-white text-white dark:text-black rounded-lg
                                   hover:bg-gray-800 dark:hover:bg-gray-200 transition-colors
                                   focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black dark:focus:ring-white">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Sign In</span>
                    </button>
                    <p class="mt-2 text-xs text-gray-700 dark:text-gray-600">Your account must be recognised as belonging to a member of the Imators team in some sector.</p>
                </form>
            </div>

            <!-- Additional Info -->
            <div class="mt-6 text-center">
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    Need help? Contact your administrator
                </p>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-white dark:bg-gray-800 shadow-sm mt-auto">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <p class="text-center text-sm text-gray-600 dark:text-gray-400">
                &copy; <?= date('Y') ?> Imators. All rights reserved.
            </p>
        </div>
    </footer>

    <script>
        // Dark Mode Toggle
        document.addEventListener('DOMContentLoaded', () => {
            const themeToggle = document.getElementById('theme-toggle');

            // Initialize theme
            if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }

            // Toggle theme
            themeToggle.addEventListener('click', () => {
                document.documentElement.classList.toggle('dark');
                localStorage.theme = document.documentElement.classList.contains('dark') ? 'dark' : 'light';
            });
        });
    </script>
</body>
</html>