<?php
session_start();
$is_logged_in = isset($_SESSION['admin']) && $_SESSION['admin'] === true;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Documentation - TrafficLight</title>
    <link rel="icon" type="image/png" href="traffic_logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.28.0/themes/prism.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'sans-serif'],
                        'mono': ['SFMono-Regular', 'Menlo', 'Monaco', 'Consolas', 'Liberation Mono', 'Courier New', 'monospace']
                    },
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e'
                        },
                        traffic: {
                            red: '#ef4444',
                            green: '#10b981',
                            amber: '#f59e0b'
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50">
    <header class="bg-white shadow-sm sticky top-0 z-10">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <img src="traffic_logo.png" alt="Logo" class="w-8 h-8 mr-2">
                    <h1 class="text-xl font-semibold text-gray-800">TrafficLight API</h1>
                </div>
                <div class="flex items-center">
                    <?php if ($is_logged_in): ?>
                        <a href="api-key-manager.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">API Keys</a>
                        <a href="admin-logout.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Logout</a>
                    <?php else: ?>
                        <a href="admin-login.php" class="text-gray-600 hover:text-gray-900 px-3 py-2 rounded-md text-sm font-medium">Admin Login</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="lg:grid lg:grid-cols-12 lg:gap-8">
            <div class="lg:col-span-3">
                <nav class="sticky top-20 space-y-1 py-4">
                    <a href="#introduction" class="text-primary-600 hover:text-primary-800 font-medium block py-2">Introduction</a>
                    <a href="#authentication" class="text-gray-700 hover:text-primary-600 block py-2">Authentication</a>
                    <a href="#rate-limits" class="text-gray-700 hover:text-primary-600 block py-2">Rate Limits</a>
                    <a href="#error-handling" class="text-gray-700 hover:text-primary-600 block py-2">Error Handling</a>
                    
                    <div class="py-2 font-medium text-gray-900">Endpoints</div>
                    <a href="#get-all-lights" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">Get All Lights</a>
                    <a href="#get-light-by-id" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">Get Light by ID</a>
                    <a href="#get-nearby-lights" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">Get Nearby Lights</a>
                    <a href="#add-light" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">Add Light</a>
                    <a href="#update-light" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">Update Light</a>
                    
                    <div class="py-2 font-medium text-gray-900">SDK</div>
                    <a href="#javascript-sdk" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">JavaScript</a>
                    <a href="#php-sdk" class="text-gray-700 hover:text-primary-600 block py-2 pl-4">PHP</a>
                </nav>
            </div>
            
            <div class="mt-6 lg:mt-0 lg:col-span-9">
                <div class="prose prose-primary max-w-none">
                    <section id="introduction" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Introduction</h2>
                        <p class="text-gray-700 mb-4">
                            The TrafficLight API provides programmatic access to traffic light data including status, timing, and location information. 
                            This API allows developers to integrate real-time traffic light information into their applications.
                        </p>
                        <div class="bg-green-50 border-l-4 border-green-400 p-4 mb-4">
                            <p class="text-green-700">
                                <strong>Base URL:</strong> <code>https://yourdomain.com/api.php</code>
                            </p>
                        </div>
                    </section>
                    
                    <section id="authentication" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Authentication</h2>
                        <p class="text-gray-700 mb-4">
                            All API requests require authentication using an API key. You can obtain an API key from the admin panel.
                        </p>
                        <p class="text-gray-700 mb-4">
                            Include your API key as a query parameter in all requests:
                        </p>
                        <div class="bg-gray-100 rounded-md p-4 overflow-x-auto mb-4">
                            <pre><code class="language-http">GET https://yourdomain.com/api.php?endpoint=lights&api_key=YOUR_API_KEY</code></pre>
                        </div>
                    </section>
                    
                    <section id="rate-limits" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Rate Limits</h2>
                        <p class="text-gray-700 mb-4">
                            The API currently has the following rate limits:
                        </p>
                        <ul class="list-disc pl-6 mb-4 text-gray-700">
                            <li>100 requests per minute</li>
                            <li>5,000 requests per day</li>
                        </ul>
                        <p class="text-gray-700 mb-4">
                            Exceeding these limits will result in a 429 Too Many Requests response.
                        </p>
                    </section>
                    
                    <section id="error-handling" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Error Handling</h2>
                        <p class="text-gray-700 mb-4">
                            The API uses standard HTTP status codes to indicate the success or failure of a request.
                        </p>
                        <table class="min-w-full border border-gray-300 mb-4">
                            <thead>
                                <tr>
                                    <th class="px-4 py-2 bg-gray-100 border-b border-gray-300 text-left">Status Code</th>
                                    <th class="px-4 py-2 bg-gray-100 border-b border-gray-300 text-left">Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="px-4 py-2 border-b border-gray-300">200</td>
                                    <td class="px-4 py-2 border-b border-gray-300">OK - The request was successful</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 border-b border-gray-300">400</td>
                                    <td class="px-4 py-2 border-b border-gray-300">Bad Request - The request is invalid or missing required parameters</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 border-b border-gray-300">401</td>
                                    <td class="px-4 py-2 border-b border-gray-300">Unauthorized - Invalid or missing API key</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 border-b border-gray-300">404</td>
                                    <td class="px-4 py-2 border-b border-gray-300">Not Found - The requested resource was not found</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 border-b border-gray-300">429</td>
                                    <td class="px-4 py-2 border-b border-gray-300">Too Many Requests - Rate limit exceeded</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 border-gray-300">500</td>
                                    <td class="px-4 py-2 border-gray-300">Internal Server Error - Something went wrong on the server</td>
                                </tr>
                            </tbody>
                        </table>
                        <p class="text-gray-700 mb-4">Error responses include a JSON body with details:</p>
                        <div class="bg-gray-100 rounded-md p-4 overflow-x-auto mb-4">
                            <pre><code class="language-json">{
  "status": "error",
  "message": "Description of the error"
}</code></pre>
                        </div>
                    </section>
                    
                    <section id="get-all-lights" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Get All Lights</h2>
                        <p class="text-gray-700 mb-4">
                            Retrieve a list of all traffic lights in the system.
                        </p>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Request</h4>
                            <pre><code class="language-http">GET https://yourdomain.com/api.php?endpoint=lights&api_key=YOUR_API_KEY</code></pre>
                        </div>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Response</h4>
                            <pre><code class="language-json">{
  "status": "success",
  "data": [
    {
      "id": "1",
      "name": "Main Street & First Avenue",
      "latitude": "51.509865",
      "longitude": "-0.118092",
      "direction": "north",
      "red_duration": "60",
      "green_duration": "30",
      "status": {
        "current": "RED",
        "next_change": 25,
        "next_state": "GREEN",
        "cycle_position": 58.33
      }
    },
    {
      "id": "2",
      "name": "Broadway & Park Place",
      "latitude": "51.507652",
      "longitude": "-0.127758",
      "direction": "east",
      "red_duration": "45",
      "green_duration": "30",
      "status": {
        "current": "GREEN",
        "next_change": 12,
        "next_state": "RED",
        "cycle_position": 70.0
      }
    }
  ]
}</code></pre>
                        </div>
                    </section>
                    
                    <section id="get-light-by-id" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Get Light by ID</h2>
                        <p class="text-gray-700 mb-4">
                            Retrieve detailed information about a specific traffic light.
                        </p>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Request</h4>
                            <pre><code class="language-http">GET https://yourdomain.com/api.php?endpoint=light&id=1&api_key=YOUR_API_KEY</code></pre>
                        </div>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Parameters</h4>
                            <table class="min-w-full">
                                <thead>
                                    <tr>
                                        <th class="text-left">Parameter</th>
                                        <th class="text-left">Type</th>
                                        <th class="text-left">Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>id</td>
                                        <td>integer</td>
                                        <td>The ID of the traffic light (required)</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Response</h4>
                            <pre><code class="language-json">{
  "status": "success",
  "data": {
    "id": "1",
    "name": "Main Street & First Avenue",
    "latitude": "51.509865",
    "longitude": "-0.118092",
    "direction": "north",
    "red_duration": "60",
    "green_duration": "30",
    "status": {
      "current": "RED",
      "next_change": 25,
      "next_state": "GREEN",
      "cycle_position": 58.33
    }
  }
}</code></pre>
                        </div>
                    </section>
                    
                    <section id="get-nearby-lights" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Get Nearby Lights</h2>
                        <p class="text-gray-700 mb-4">
                            Retrieve traffic lights within a specified radius of a location.
                        </p>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Request</h4>
                            <pre><code class="language-http">GET https://yourdomain.com/api.php?endpoint=nearby&lat=51.509865&lng=-0.118092&radius=1&api_key=YOUR_API_KEY</code></pre>
                        </div>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Parameters</h4>
                            <table class="min-w-full">
                                <thead>
                                    <tr>
                                        <th class="text-left">Parameter</th>
                                        <th class="text-left">Type</th>
                                        <th class="text-left">Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>lat</td>
                                        <td>float</td>
                                        <td>Latitude of the center point (required)</td>
                                    </tr>
                                    <tr>
                                        <td>lng</td>
                                        <td>float</td>
                                        <td>Longitude of the center point (required)</td>
                                    </tr>
                                    <tr>
                                        <td>radius</td>
                                        <td>float</td>
                                        <td>Radius in kilometers (default: 1)</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Response</h4>
                            <pre><code class="language-json">{
  "status": "success",
  "data": [
    {
      "id": "1",
      "name": "Main Street & First Avenue",
      "latitude": "51.509865",
      "longitude": "-0.118092",
      "direction": "north",
      "red_duration": "60",
      "green_duration": "30",
      "distance": 0.0,
      "status": {
        "current": "RED",
        "next_change": 25,
        "next_state": "GREEN",
        "cycle_position": 58.33
      }
    },
    {
      "id": "5",
      "name": "Oxford Street & Bond Street",
      "latitude": "51.514756",
      "longitude": "-0.119434",
      "direction": "west",
      "red_duration": "50",
      "green_duration": "40",
      "distance": 0.78,
      "status": {
        "current": "GREEN",
        "next_change": 15,
        "next_state": "RED",
        "cycle_position": 62.5
      }
    }
  ]
}</code></pre>
                        </div>
                    </section>
                    
                    <section id="add-light" class="mb-12">
                        <h2 class="text-3xl font-bold text-gray-900 mb-4">Add Light</h2>
                        <p class="text-gray-700 mb-4">
                            Add a new traffic light to the system.
                        </p>
                        
                        <div class="bg-gray-100 rounded-md p-4 mb-4">
                            <h4 class="font-bold mb-2">Request</h4>
                            <pre><code class="language-http">POST https://yourdomain.com/api.php?endpoint=light&api_key=YOUR_API_KEY
Content-Type: application/json

{
  "name": "Oak Street &