<header class="fixed top-0 left-0 w-full z-50 px-4 py-4">
    <div class="max-w-7xl mx-auto">
        <div class="bg-white/90 backdrop-blur-md rounded-lg py-3 px-6 flex items-center justify-between">
            <a href="/" class="flex items-center">
                <img src="logo.png" alt="Imators Logo" class="h-8 w-auto">
            </a>
            
            <nav class="hidden md:flex items-center space-x-8">
                <a href="https://imators.com/contact-us" class="text-gray-600 hover:text-gray-900 transition-colors">Support</a>
                <a href="/hub" class="bg-black text-white rounded-full px-5 py-2 hover:bg-gray-800 transition-colors">Get Started</a>
            </nav>
            
            <button id="menuBtn" class="md:hidden text-gray-700 focus:outline-none">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                </svg>
            </button>
        </div>
        
        <div id="mobileMenu" class="md:hidden bg-white/90 backdrop-blur-md rounded-lg mt-2 py-4 px-6 hidden">
            <nav class="flex flex-col items-center space-y-4">
                <a href="https://imators.com/contact-us" class="text-gray-600 hover:text-gray-900 transition-colors w-full text-center py-2">Support</a>
                <a href="/hub" class="bg-black text-white rounded-full px-5 py-2 hover:bg-gray-800 transition-colors w-full text-center">Get Started</a>
            </nav>
        </div>
    </div>
</header>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuBtn = document.getElementById('menuBtn');
        const mobileMenu = document.getElementById('mobileMenu');
        
        menuBtn.addEventListener('click', function() {
            mobileMenu.classList.toggle('hidden');
        });
    });
    
    window.addEventListener('scroll', function() {
        const header = document.querySelector('header');
        if (window.scrollY > 50) {
            header.classList.add('py-2');
            header.classList.remove('py-4');
        } else {
            header.classList.add('py-4');
            header.classList.remove('py-2');
        }
    });
</script>