<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            height: 70px;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            backdrop-filter: none;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 350;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        .mega-menu {
            position: absolute;
            top: 90px;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 1001;
            padding: 40px 0;
        }

        .desktop-menu-item:hover .mega-menu {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .mega-menu-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
        }

        .mega-menu-column {
            display: flex;
            flex-direction: column;
        }

        .mega-menu-title {
            font-size: 1.1rem;
            font-weight: 500;
            margin-bottom: 15px;
            color: #FFFFFF;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding-bottom: 10px;
        }

        .mega-menu-link {
            display: flex;
            align-items: center;
            padding: 10px 0;
            color: rgba(255, 255, 255, 0.7);
            transition: all 0.2s ease;
            font-weight: 300;
        }

        .mega-menu-link:hover {
            color: #FFFFFF;
            transform: translateX(5px);
        }

        .mega-menu-link svg {
            margin-right: 10px;
            opacity: 0.7;
        }

        .featured-item {
            background: linear-gradient(135deg, rgba(255,255,255,0.05), rgba(255,255,255,0.1));
            border-radius: 16px;
            padding: 20px;
            margin-top: 20px;
        }

        .featured-item-title {
            font-weight: 500;
            margin-bottom: 10px;
        }

        .featured-item-desc {
            font-size: 0.9rem;
            opacity: 0.7;
            margin-bottom: 15px;
        }

        .featured-item-button {
            display: inline-flex;
            align-items: center;
            padding: 8px 15px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            font-size: 0.9rem;
            transition: all 0.2s ease;
        }

        .featured-item-button:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .featured-item-button svg {
            margin-left: 5px;
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
        }

        .menu-title {
            font-size: 1.1rem;
            font-weight: 500;
        }

        .mobile-menu-items {
            padding: 15px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px;
            margin-bottom: 8px;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-menu-item:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.06);
        }

        .mobile-submenu-panel {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000000;
            z-index: 1002;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(100%);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu-panel.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-submenu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            align-items: center;
            padding: 15px 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            gap: 15px;
            backdrop-filter: blur(10px);
        }

        .mobile-submenu-content {
            padding: 15px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 12px;
            margin-bottom: 8px;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-submenu-link:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.06);
        }

        .hamburger {
            width: 36px;
            height: 36px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 18px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 9px;
            transition: transform 0.3s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 13px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 23px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(5px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-5px) rotate(-45deg);
        }

        .close-button {
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 12px;
            transition: all 0.2s ease;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
        }

        .header-content {
            height: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo-container {
            display: flex;
            align-items: center;
        }

        .logo-container img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo-container img {
                height: 36px;
            }
        }

        .mobile-account-button {
            display: block;
            margin-top: 15px;
            padding: 12px;
            background: #FFFFFF;
            color: #000000;
            text-align: center;
            border-radius: 12px;
            font-weight: 500;
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 header-content">
            <div class="logo-container">
                <a href="/" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item font-light">
                    Products
                    <div class="mega-menu">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="mega-menu-container">
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">Education</h3>
                                    <a href="https://academ.my" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M22 12h-4l-3 9L9 3l-3 9H2"/>
                                        </svg>
                                        Academ
                                    </a>
                                    <a href="/progm" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M16 18l6-6-6-6M8 6l-6 6 6 6"/>
                                        </svg>
                                        Progm
                                    </a>
                                    <div class="featured-item">
                                        <h4 class="featured-item-title">Discover Academ</h4>
                                        <p class="featured-item-desc">The solution that transforms education for students and teachers.</p>
                                        <a href="https://academ.my" class="featured-item-button">
                                            Explore
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M5 12h14M12 5l7 7-7 7"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">Shopping</h3>
                                    <a href="https://ohmypanel.com" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M20 22H4a2 2 0 0 1-2-2V7a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v13a2 2 0 0 1-2 2z"/>
                                            <rect x="8" y="2" width="8" height="5" rx="1"/>
                                        </svg>
                                        OhMyPanel
                                    </a>
                                    <a href="https://owtfitt.com" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"/>
                                            <path d="M3 6h18"/>
                                            <path d="M16 10a4 4 0 0 1-8 0"/>
                                        </svg>
                                        Owtfitt
                                    </a>
                                    <div class="featured-item">
                                        <h4 class="featured-item-title">Try OhMyPanel</h4>
                                        <p class="featured-item-desc">Simplify your shopping and save time with our innovative solution.</p>
                                        <a href="https://ohmypanel.com" class="featured-item-button">
                                            Discover
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M5 12h14M12 5l7 7-7 7"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Developer Tools
                    <div class="mega-menu">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="mega-menu-container">
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">Developer Resources</h3>
                                    <a href="https://imators.systems" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"/>
                                            <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"/>
                                        </svg>
                                        Imators Systems
                                    </a>
                                    <a href="https://developer.imators.com" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M12 2a3 3 0 0 0-3 3v7a3 3 0 0 0 6 0V5a3 3 0 0 0-3-3Z"/>
                                            <path d="M19 10v2a7 7 0 0 1-14 0v-2"/>
                                            <path d="M12 19v3"/>
                                        </svg>
                                        Imators Developer
                                    </a>
                                    <div class="featured-item">
                                        <h4 class="featured-item-title">Imators Developers</h4>
                                        <p class="featured-item-desc">Access our resources and tools to integrate our solutions into your projects.</p>
                                        <a href="https://developer.imators.com" class="featured-item-button">
                                            Documentation
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M5 12h14M12 5l7 7-7 7"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">APIs & Integrations</h3>
                                    <a href="https://developer.imators.com/api" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M16 18l6-6-6-6"/>
                                            <path d="M8 6l-6 6 6 6"/>
                                        </svg>
                                        APIs
                                    </a>
                                    <a href="https://developer.imators.com/sdk" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"/>
                                            <path d="M8 21h8"/>
                                            <path d="M12 17v4"/>
                                        </svg>
                                        SDKs
                                    </a>
                                    <a href="https://developer.imators.com/plugins" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M12 2v4M12 18v4M4.93 4.93l2.83 2.83M16.24 16.24l2.83 2.83M2 12h4M18 12h4M4.93 19.07l2.83-2.83M16.24 7.76l2.83-2.83"/>
                                        </svg>
                                        Plugins
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Company
                    <div class="mega-menu">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="mega-menu-container">
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">About</h3>
                                    <a href="/about-us" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10z"/>
                                            <path d="M12 16v-4"/>
                                            <path d="M12 8h.01"/>
                                        </svg>
                                        About Imators
                                    </a>
                                    <a href="/careers" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M20 7H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2Z"/>
                                            <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"/>
                                        </svg>
                                        Careers
                                    </a>
                                    <a href="/press" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                            <path d="M14 2v6h6"/>
                                            <path d="M16 13H8"/>
                                            <path d="M16 17H8"/>
                                            <path d="M10 9H8"/>
                                        </svg>
                                        Press
                                    </a>
                                </div>
                                <div class="mega-menu-column">
                                    <h3 class="mega-menu-title">Support</h3>
                                    <a href="/support" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"/>
                                        </svg>
                                        Support Centre
                                    </a>
                                    <a href="/contact-us" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                            <polyline points="22,6 12,13 2,6"/>
                                        </svg>
                                        Contact Us
                                    </a>
                                    <a href="/faq" class="mega-menu-link">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <circle cx="12" cy="12" r="10"/>
                                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/>
                                            <line x1="12" y1="17" x2="12.01" y2="17"/>
                                        </svg>
                                        FAQ
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    Imators Account
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </header>
    
    <div class="mobile-overlay"></div>

    <div class="mobile-menu">
        <div class="mobile-menu-header">
            <span class="menu-title">Welcome back.</span>
        </div>
  
        <div class="mobile-menu-items">
            <div class="mobile-menu-item" data-submenu="products">
                <span>Products</span>
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="dev-tools">
                <span>Developer Tools</span>
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-menu-item" data-submenu="company">
                <span>Company</span>
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <a href="https://idsma.imators.com" class="mobile-account-button">
                Imators Account
            </a>
        </div>
    </div>
    
    <div class="mobile-submenu-panel" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Products</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://academ.my" class="mobile-submenu-link">Academ</a>
            <a href="/progm" class="mobile-submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="dev-tools-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="https://imators.systems" class="mobile-submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">Imators Developer</a>
            <a href="https://developer.imators.com/api" class="mobile-submenu-link">APIs</a>
            <a href="https://developer.imators.com/sdk" class="mobile-submenu-link">SDKs</a>
            <a href="https://developer.imators.com/plugins" class="mobile-submenu-link">Plugins</a>
        </div>
    </div>

    <div class="mobile-submenu-panel" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="close-button back-button">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="menu-title">Company</span>
        </div>
        <div class="mobile-submenu-content">
            <a href="/about-us" class="mobile-submenu-link">About Imators</a>
            <a href="/careers" class="mobile-submenu-link">Careers</a>
            <a href="/press" class="mobile-submenu-link">Press</a>
            <a href="/support" class="mobile-submenu-link">Support Centre</a>
            <a href="/contact-us" class="mobile-submenu-link">Contact Us</a>
            <a href="/faq" class="mobile-submenu-link">FAQ</a>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger');
            const mobileMenu = document.querySelector('.mobile-menu');
            const mobileOverlay = document.querySelector('.mobile-overlay');
            const backButtons = document.querySelectorAll('.back-button');
            const menuItems = document.querySelectorAll('.mobile-menu-item');
            const header = document.querySelector('.header');
            const submenus = document.querySelectorAll('.mobile-submenu-panel');
            
            let isTransitioning = false;
            let lastScrollTop = 0;
            let scrollTimeout;

            function openMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = 'hidden';
                mobileOverlay.classList.add('active');
                mobileMenu.classList.add('active');
                hamburger.classList.add('active');
            }

            function closeMenu() {
                if (isTransitioning) return;
                document.body.style.overflow = '';
                mobileOverlay.classList.remove('active');
                mobileMenu.classList.remove('active');
                hamburger.classList.remove('active');
                submenus.forEach(submenu => {
                    submenu.classList.remove('active');
                });
            }

            hamburger.addEventListener('click', () => {
                mobileMenu.classList.contains('active') ? closeMenu() : openMenu();
            });

            backButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const submenuPanel = button.closest('.mobile-submenu-panel');
                    if (submenuPanel) {
                        submenuPanel.classList.remove('active');
                    }
                });
            });

            mobileOverlay.addEventListener('click', closeMenu);

            menuItems.forEach(item => {
                item.addEventListener('click', () => {
                    if (isTransitioning) return;
                    isTransitioning = true;

                    const submenuId = item.getAttribute('data-submenu') + '-submenu';
                    const submenu = document.getElementById(submenuId);

                    if (submenu) {
                        submenu.classList.add('active');
                    }

                    setTimeout(() => {
                        isTransitioning = false;
                    }, 300);
                });
            });

            window.addEventListener('scroll', () => {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }

                if (!mobileMenu.classList.contains('active') && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }

                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });

            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', (e) => {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });

            mobileMenu.addEventListener('touchmove', (e) => {
                const touchEndY = e.touches[0].clientY;
                const deltaY = touchEndY - touchStartY;

                if (deltaY > 70) {
                    closeMenu();
                    touchStartY = 0;
                }
            }, { passive: true });
        });
    </script>
</body>
</html>