<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Product</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
            min-height: 100vh;
        }

        .main-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .content-area {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .grid-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 50% 50%, rgba(255, 255, 255, 0.15) 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.3;
            z-index: -1;
        }

        .highlight {
            color: #FFFFFF;
            position: relative;
            display: inline-block;
        }

        .highlight::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 8px;
            bottom: 5px;
            left: 0;
            background-color: rgba(255, 255, 255, 0.15);
            z-index: -1;
        }

        .feature-item {
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            padding-left: 1rem;
            margin-bottom: 1.5rem;
        }

        .feature-item:hover {
            border-left: 1px solid rgba(255, 255, 255, 0.3);
        }

        .product-tab {
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
            white-space: nowrap;
            flex: 1;
            text-align: center;
        }

        .product-tab.active {
            border-bottom: 2px solid #FFFFFF;
        }

        .product-tab:hover:not(.active) {
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
        }

        .demo-button {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            text-align: center;
            width: 100%;
            max-width: 300px;
        }

        .demo-button:hover {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .api-box {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
            width: 100%;
            max-width: 500px;
        }

        .footer {
            padding: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Cookie Box */
        .cookie-box {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            margin: 1rem;
            padding: 1rem;
            background-color: #000000;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 0.5rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
            z-index: 50;
            opacity: 0;
            transform: translateY(1rem);
            transition: all 0.5s ease-out;
        }

        .cookie-box.visible {
            opacity: 1;
            transform: translateY(0);
        }

        @media (max-width: 768px) {
            .content-area {
                padding: 1.5rem 1rem;
            }
            
            h2 {
                font-size: 1.75rem;
                line-height: 1.3;
            }
            
            .footer {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>
<?php include 'src/header.php'; ?>

    <div class="grid-background"></div>
    <div class="main-container">
        <div class="mt-24 content-area">
            <div class="w-full max-w-4xl mx-auto">
                <!-- Logo and Main Text -->
                <div class="mb-8 md:mb-12">
                    <div class="flex items-center mb-6">
                        <img src="https://imators.systems/traffic/traffic_logo.png" alt="Imators Product" class="rounded-md w-10 h-10 md:w-12 md:h-12 mr-3">
                        <h1 class="text-xl md:text-2xl font-light">TrafficLight</h1>
                    </div>
                    <h2 class="text-3xl md:text-4xl font-light leading-tight mb-4 md:mb-6">
                        A solution to see<br class="hidden md:block"> what your city hasn't added.
                    </h2>
                    <p class="text-zinc-400 text-base md:text-xl max-w-2xl">
                        With TrafficLight, you can get detailed, live traffic information, thanks to the addition of the community and a cutting-edge system.
                    </p>
                </div>
                
                <!-- Product Tabs -->
                <div class="mb-8">
                    <div class="product-tabs flex mb-6 border-b border-zinc-800 overflow-x-auto">
                        <div class="product-tab active px-4 py-3 md:px-6 cursor-pointer" onclick="changeTab('features')">
                            <i class="fa fa-cube mr-2"></i> Features
                        </div>
                        <div class="product-tab px-4 py-3 md:px-6 cursor-pointer" onclick="changeTab('api')">
                            <i class="fa fa-code mr-2"></i> API
                        </div>
                    </div>
                    
                    <!-- Features Tab Content -->
                    <div id="features" class="tab-content">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8 mb-8">
                            <div class="feature-item">
                                <div class="flex items-center mb-2">
                                    <i class="fa fa-road text-zinc-300 mr-3"></i>
                                    <h3 class="text-base md:text-lg font-medium">Faster, all the time.</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Avoid an average 15-minute delay at your destination*</p>
                            </div>
                            
                            <div class="feature-item">
                                <div class="flex items-center mb-2">
                                    <i class="fa fa-map-marker text-zinc-300 mr-3"></i>
                                    <h3 class="text-base md:text-lg font-medium">You change everything</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">No need to stop or pick up your phone! The application automatically adds traffic lights**</p>
                            </div>
                            
                            <div class="feature-item">
                                <div class="flex items-center mb-2">
                                    <i class="fa fa-mobile-screen text-zinc-300 mr-3"></i>
                                    <h3 class="text-base md:text-lg font-medium">Mobile Ready</h3>
                                </div>
                                <p class="text-zinc-400 text-sm">Optimised user experience on all devices.</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- API Tab Content -->
                    <div id="api" class="tab-content hidden">
                        <div class="flex flex-col items-center justify-center py-8 md:py-12 text-center">
                            <i class="fa fa-code-branch text-3xl md:text-4xl mb-4 text-zinc-400"></i>
                            <h3 class="text-xl md:text-2xl font-light mb-3">API Integration</h3>
                            <div class="text-lg md:text-xl font-medium text-white mt-3 mb-5">Available in JS or PHP SDK</div>
                            <div class="api-box p-4 rounded-md mb-4 mx-4">
                                <p class="text-sm text-zinc-400">Connect your application to the TrafficLight service for a major addition to car navigation</p>
                            </div>
                            <a href="https://imators.systems/traffic/api-documentation" class="mt-3 px-5 py-2 border border-zinc-700 rounded-md text-zinc-400 hover:text-white hover:border-zinc-500 transition-colors text-sm md:text-base">
                                Obtain an API key
                            </a>
                        </div>
                        <div class="text-lg items-center justify-center text-center md:text-xl font-medium text-white mb-5">or</div>
                    </div>
                </div>
                
                <div class="flex justify-center mt-4 mb-8">
                    <a href="https://imators.systems/traffic" class="demo-button px-6 py-3 md:px-8 md:py-4 rounded-md text-base md:text-lg hover:text-white transition-colors">
                        <i class="fa fa-play-circle mr-2"></i>
                        Go to the application
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
  <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
    <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
    Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use</a>.
    </div>
    <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
    Accept
    </button>
  </div>
</div>

    <script>
    function changeTab(tabId) {
        // Hide all tab contents
        document.querySelectorAll('.tab-content').forEach(tab => {
            tab.classList.add('hidden');
        });
        
        // Remove active class from all tabs
        document.querySelectorAll('.product-tab').forEach(tab => {
            tab.classList.remove('active');
        });
        
        // Show selected tab content
        document.getElementById(tabId).classList.remove('hidden');
        
        // Add active class to clicked tab
        event.currentTarget.classList.add('active');
    }

    // Cookie functions
    function acceptCookies() {
        const cookieBox = document.getElementById('cookieBox');
        cookieBox.classList.remove('visible');
        
        setTimeout(() => {
            cookieBox.style.display = 'none';
        }, 500);
        
        // Set cookie with 30 days expiration
        const expiryDate = new Date();
        expiryDate.setDate(expiryDate.getDate() + 30);
        
        document.cookie = "cookiesAccepted=true; expires=" + expiryDate.toUTCString() + "; path=/";
    }

    // Check if cookies have been accepted
    function checkCookies() {
        if (!document.cookie.split(';').some((item) => item.trim().startsWith('cookiesAccepted='))) {
            const cookieBox = document.getElementById('cookieBox');
            
            setTimeout(() => {
                cookieBox.classList.add('visible');
            }, 2000);
        }
    }

    // Run when page loads
    window.onload = function() {
        checkCookies();
    }
    </script>

<footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
        <p class="text-sm text-gray-200">
            *This estimate depends on the route you are taking and a number of road logic factors that may vary.
        </p>
        <p class="text-sm">
        **This feature is automatically activated, called "Add to stop". It can be deactivated at any time. By activating it, you are constantly improving the application.
        </p>
    </div>
</div>


<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-4">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div>
</footer>
</body>
</html>