<?php
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_pdf'])) {
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('defaultFont', 'Helvetica');
    
    $dompdf = new Dompdf($options);
    
    $html = '
    <html>
    <head>
        <style>
            @page { margin: 10px; }
            body { font-family: Helvetica, Arial, sans-serif; }
            .planner { width: 100%; }
            .day { 
                page-break-inside: avoid;
                border: 1px solid #e5e7eb;
                border-radius: 8px;
                padding: 15px;
                margin-bottom: 15px;
            }
            .day-header {
                display: flex;
                justify-content: space-between;
                border-bottom: 2px solid #f3f4f6;
                padding-bottom: 10px;
                margin-bottom: 10px;
            }
            .day-title {
                font-size: 18px;
                font-weight: bold;
                color: #1f2937;
            }
            .section {
                margin: 10px 0;
                padding: 5px 0;
            }
            .label {
                color: #4b5563;
                font-size: 12px;
                margin-bottom: 4px;
            }
            .task {
                padding: 3px 0;
                display: flex;
                align-items: center;
            }
            .checkbox {
                width: 12px;
                height: 12px;
                border: 1px solid #9ca3af;
                margin-right: 8px;
            }
        </style>
    </head>
    <body>' . $_POST['pdfContent'] . '</body></html>';
    
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $dompdf->stream("MyDayBetter.pdf", ["Attachment" => true]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MyDayBetter</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-50 min-h-screen">
    <div class="container max-w-5xl mx-auto p-4 md:p-8">
        <div id="plannerContent">
            <div class="text-center mb-12">
                <h1 class="text-4xl font-bold text-gray-900 mb-2">MyDayBetter</h1>
                <p class="text-gray-600">Planifie ta semaine, améliore tes journées</p>
            </div>
            
            <div class="grid gap-6">
                <?php 
                $jours = ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'];
                foreach($jours as $jour): ?>
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 transition-all hover:shadow-md">
                        <div class="flex justify-between items-center p-6 border-b border-gray-100">
                            <h2 class="text-xl font-semibold text-gray-900"><?= $jour ?></h2>
                            <div class="flex gap-4">
                                <label class="flex items-center cursor-pointer">
                                    <input type="checkbox" class="weekendCheck hidden">
                                    <div class="w-16 h-7 flex items-center bg-gray-200 rounded-full p-1 duration-300 ease-in-out">
                                        <div class="bg-white w-5 h-5 rounded-full shadow-md transform duration-300 ease-in-out"></div>
                                    </div>
                                    <span class="ml-2 text-sm text-gray-600">Weekend</span>
                                </label>
                                <label class="flex items-center cursor-pointer">
                                    <input type="checkbox" class="congeCheck hidden">
                                    <div class="w-16 h-7 flex items-center bg-gray-200 rounded-full p-1 duration-300 ease-in-out">
                                        <div class="bg-white w-5 h-5 rounded-full shadow-md transform duration-300 ease-in-out"></div>
                                    </div>
                                    <span class="ml-2 text-sm text-gray-600">Congé</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="p-6 grid gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Rappel</label>
                                <input type="text" class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Devoir</label>
                                <div class="w-8 h-8 border-2 border-gray-300 rounded-lg transition-all hover:border-blue-500 cursor-pointer"></div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Motivation</label>
                                <textarea rows="2" class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all"></textarea>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Humeur</label>
                                <div class="flex gap-6">
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="good" class="hidden">
                                        <span class="text-3xl opacity-50 hover:opacity-100 transition-opacity">😊</span>
                                    </label>
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="neutral" class="hidden">
                                        <span class="text-3xl opacity-50 hover:opacity-100 transition-opacity">😐</span>
                                    </label>
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="bad" class="hidden">
                                        <span class="text-3xl opacity-50 hover:opacity-100 transition-opacity">😔</span>
                                    </label>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Tâches</label>
                                <div class="space-y-2">
                                    <input type="text" class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all new-task" placeholder="Ajouter une tâche et appuyer sur Entrée">
                                    <div class="task-list space-y-2"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="mt-12 flex justify-center">
            <form method="POST" id="pdfForm">
                <input type="hidden" name="pdfContent">
                <button type="submit" name="generate_pdf" class="bg-gradient-to-r from-blue-500 to-indigo-600 text-white px-8 py-3 rounded-lg font-medium hover:opacity-90 transition-opacity focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Télécharger en PDF
                </button>
            </form>
        </div>
    </div>

    <script>
        document.querySelectorAll('input[type="checkbox"]').forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const slider = this.nextElementSibling.querySelector('div');
                if (this.checked) {
                    this.nextElementSibling.classList.remove('bg-gray-200');
                    this.nextElementSibling.classList.add('bg-blue-500');
                    slider.classList.add('translate-x-9');
                } else {
                    this.nextElementSibling.classList.remove('bg-blue-500');
                    this.nextElementSibling.classList.add('bg-gray-200');
                    slider.classList.remove('translate-x-9');
                }
            });
        });

        document.querySelectorAll('[type="radio"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const container = this.closest('.flex.gap-6');
                container.querySelectorAll('span').forEach(span => span.style.opacity = '0.5');
                this.nextElementSibling.style.opacity = '1';
            });
        });

        document.querySelectorAll('.new-task').forEach(input => {
            input.addEventListener('keypress', function(e) {
                if (e.key === 'Enter' && this.value.trim()) {
                    const taskList = this.nextElementSibling;
                    const taskDiv = document.createElement('div');
                    taskDiv.className = 'flex items-center gap-2 p-2 bg-gray-50 rounded-lg group';
                    taskDiv.innerHTML = `
                        <input type="checkbox" class="form-checkbox h-4 w-4 text-blue-500 rounded border-gray-300 focus:ring-blue-500">
                        <span class="flex-1 text-gray-700">${this.value}</span>
                        <button type="button" onclick="this.parentElement.remove()" class="opacity-0 group-hover:opacity-100 text-red-500 hover:text-red-600 transition-opacity">&times;</button>
                    `;
                    taskList.appendChild(taskDiv);
                    this.value = '';
                }
            });
        });

        document.querySelector('#pdfForm').addEventListener('submit', function(e) {
            const planner = document.getElementById('plannerContent').cloneNode(true);
            planner.querySelectorAll('button, input[type="text"], .new-task').forEach(el => el.remove());
            document.querySelector('input[name="pdfContent"]').value = planner.innerHTML;
        });

        function saveToLocalStorage() {
            const data = {};
            document.querySelectorAll('.rounded-xl').forEach(day => {
                const dayName = day.querySelector('h2').textContent;
                data[dayName] = {
                    weekend: day.querySelector('.weekendCheck').checked,
                    conge: day.querySelector('.congeCheck').checked,
                    rappel: day.querySelector('input[type="text"]').value,
                    motivation: day.querySelector('textarea').value,
                    humeur: Array.from(day.querySelectorAll('[type="radio"]')).find(r => r.checked)?.value,
                    tasks: Array.from(day.querySelectorAll('.task-list div')).map(task => ({
                        text: task.querySelector('span').textContent,
                        done: task.querySelector('[type="checkbox"]').checked
                    }))
                };
            });
            localStorage.setItem('mydaybetter', JSON.stringify(data));
        }

        function loadFromLocalStorage() {
            const data = JSON.parse(localStorage.getItem('mydaybetter') || '{}');
            Object.entries(data).forEach(([dayName, dayData]) => {
                const dayElement = Array.from(document.querySelectorAll('.rounded-xl'))
                    .find(day => day.querySelector('h2').textContent === dayName);
                if (dayElement) {
                    const weekendCheck = dayElement.querySelector('.weekendCheck');
                    const congeCheck = dayElement.querySelector('.congeCheck');
                    weekendCheck.checked = dayData.weekend;
                    congeCheck.checked = dayData.conge;
                    weekendCheck.dispatchEvent(new Event('change'));
                    congeCheck.dispatchEvent(new Event('change'));
                    
                    dayElement.querySelector('input[type="text"]').value = dayData.rappel;
                    dayElement.querySelector('textarea').value = dayData.motivation;
                    
                    if (dayData.humeur) {
                        const radio = dayElement.querySelector(`[value="${dayData.humeur}"]`);
                        if (radio) {
                            radio.checked = true;
                            radio.dispatchEvent(new Event('change'));
                        }
                    }
                    
                    dayData.tasks.forEach(task => {
                        const taskList = dayElement.querySelector('.task-list');
                        const taskDiv = document.createElement('div');
                        taskDiv.className = 'flex items-center gap-2 p-2 bg-gray-50 rounded-lg group';
                        taskDiv.innerHTML = `
                            <input type="checkbox" class="form-checkbox h-4 w-4 text-blue-500 rounded border-gray-300 focus:ring-blue-500" ${task.done ? 'checked' : ''}>
                            <span class="flex-1 text-gray-700">${task.text}</span>
                            <button type="button" onclick="this.parentElement.remove()" class="opacity-0 group-hover:opacity-100 text-red-500 hover:text-red-600 transition-opacity">&times;</button>
                        `;
                        taskList.appendChild(taskDiv);
                    });
                }
            });
        }

        document.addEventListener('change', saveToLocalStorage);
        document.addEventListener('keyup', saveToLocalStorage);
        window.addEventListener('load', loadFromLocalStorage);
    </script>
</body>
</html>