<?php
$dotenv = parse_ini_file('.env');
$event_date = new DateTime($dotenv['EVENT_DATE']);
$address = $dotenv['EVENT_ADDRESS'];
$latitude = $dotenv['EVENT_LAT'];
$longitude = $dotenv['EVENT_LONG'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événement</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@200;300;400&display=swap">
</head>
<body class="bg-white font-['DM_Sans'] antialiased">
    <main class="min-h-screen flex flex-col">
        <div class="h-screen md:h-[70vh] grid grid-cols-2 md:grid-cols-4">
            <div class="relative overflow-hidden">
                <img src="/image1.jpg" class="absolute inset-0 w-full h-full object-cover" alt="">
            </div>
            <div class="relative overflow-hidden">
                <img src="/image2.jpg" class="absolute inset-0 w-full h-full object-cover" alt="">
            </div>
            <div class="relative overflow-hidden hidden md:block">
                <img src="/image3.jpg" class="absolute inset-0 w-full h-full object-cover" alt="">
            </div>
            <div class="relative overflow-hidden hidden md:block">
                <img src="/image4.jpg" class="absolute inset-0 w-full h-full object-cover" alt="">
            </div>
        </div>

        <div class="container mx-auto px-6 py-20">
            <div class="grid md:grid-cols-2 gap-20">
                <div class="space-y-16">
                    <div class="space-y-6">
                        <h1 class="text-3xl md:text-4xl font-light"><?php echo $dotenv['EVENT_TITLE']; ?></h1>
                        <p class="text-neutral-600 leading-relaxed font-light"><?php echo $dotenv['EVENT_DESCRIPTION']; ?></p>
                    </div>

                    <div class="flex space-x-6 text-4xl md:text-6xl font-extralight tracking-tight" id="countdown">
                        <span class="countdown-days">00</span>
                        <span class="countdown-hours">00</span>
                        <span class="countdown-minutes">00</span>
                        <span class="countdown-seconds">00</span>
                    </div>
                </div>

                <div class="aspect-square md:aspect-auto" id="map"></div>
            </div>
        </div>
    </main>

    <script>
    function updateCountdown() {
        const eventDate = new Date('<?php echo $event_date->format('Y-m-d H:i:s'); ?>');
        const now = new Date();
        const diff = eventDate - now;

        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        document.querySelector('.countdown-days').textContent = String(days).padStart(2, '0');
        document.querySelector('.countdown-hours').textContent = String(hours).padStart(2, '0');
        document.querySelector('.countdown-minutes').textContent = String(minutes).padStart(2, '0');
        document.querySelector('.countdown-seconds').textContent = String(seconds).padStart(2, '0');
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();

    mapkit.init({
        authorizationCallback: function(done) {
            done('<?php echo $dotenv['MAPKIT_TOKEN']; ?>');
        }
    });

    const map = new mapkit.Map('map', {
        showsZoomControl: false,
        showsMapTypeControl: false,
        showsCompass: false,
        showsScale: false
    });
    
    const coordinate = new mapkit.Coordinate(<?php echo $latitude; ?>, <?php echo $longitude; ?>);
    const annotation = new mapkit.MarkerAnnotation(coordinate, {
        color: "#000000",
        selected: true
    });

    map.addAnnotation(annotation);
    map.setCenterAnimated(coordinate, true);
    map.setRegionAnimated(new mapkit.CoordinateRegion(
        coordinate,
        new mapkit.CoordinateSpan(0.01, 0.01)
    ));
    </script>
</body>
</html>