<?php
require_once 'functions.php';

if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

$error = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $full_name = $_POST['full_name'] ?? '';
    $email = $_POST['email'] ?? '';
    
    // Validation
    if (empty($username) || empty($password) || empty($confirm_password) || empty($full_name)) {
        $error = 'Tous les champs marqués * sont obligatoires';
    } else if ($password !== $confirm_password) {
        $error = 'Les mots de passe ne correspondent pas';
    } else if (strlen($password) < 8) {
        $error = 'Le mot de passe doit contenir au moins 8 caractères';
    } else {
        // Vérifier si le nom d'utilisateur existe déjà
        $stmt = $db->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->execute([$username]);
        
        if ($stmt->rowCount() > 0) {
            $error = 'Ce nom d\'utilisateur est déjà utilisé';
        } else {
            // Hachage du mot de passe
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            // Insertion de l'utilisateur
            $stmt = $db->prepare("INSERT INTO users (username, password, full_name, email, is_admin, created_at) VALUES (?, ?, ?, ?, 0, NOW())");
            $stmt->execute([$username, $hashed_password, $full_name, $email]);
            
            $success = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Création de compte</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white text-gray-800 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md">
        <div class="text-center mb-10">
            <h1 class="text-4xl font-light mb-2">PEERKINTON</h1>
            <p class="text-sm text-gray-500">Centre privé d'analyse de profils</p>
        </div>
        
        <div class="bg-white p-8 rounded-lg shadow-lg border border-gray-200">
            <h2 class="text-2xl font-light mb-6 text-center">Création de compte</h2>
            
            <?php if (!empty($error)): ?>
                <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                    <p class="text-red-700"><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
                    <p class="text-green-700">Votre compte a été créé avec succès !</p>
                    <p class="mt-2"><a href="login.php" class="text-blue-600 hover:underline">Se connecter</a></p>
                </div>
            <?php else: ?>
                <form method="POST" action="">
                    <div class="mb-4">
                        <label for="username" class="block text-sm font-light mb-2">Nom d'utilisateur *</label>
                        <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div class="mb-4">
                        <label for="full_name" class="block text-sm font-light mb-2">Nom complet *</label>
                        <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div class="mb-4">
                        <label for="email" class="block text-sm font-light mb-2">Email</label>
                        <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div class="mb-4">
                        <label for="password" class="block text-sm font-light mb-2">Mot de passe *</label>
                        <input type="password" id="password" name="password" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Minimum 8 caractères</p>
                    </div>
                    
                    <div class="mb-6">
                        <label for="confirm_password" class="block text-sm font-light mb-2">Confirmer le mot de passe *</label>
                        <input type="password" id="confirm_password" name="confirm_password" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <button type="submit" class="w-full bg-blue-600 text-white py-2 px-4 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                        Créer mon compte
                    </button>
                </form>
            <?php endif; ?>
            
            <div class="mt-6 text-center">
                <p class="text-sm text-gray-600">
                    Déjà un compte? <a href="login.php" class="text-blue-600 hover:underline">Se connecter</a>
                </p>
            </div>
        </div>
        
        <div class="mt-6 text-center text-xs text-gray-500">
            &copy; <?php echo date('Y'); ?> Peerkinton - Tous droits réservés
        </div>
    </div>
</body>
</html>