<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gallery - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
            .modal-content {
                background-color: var(--bg-dark);
                border: 1px solid var(--border-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
            .modal-content {
                background-color: var(--bg-light);
                border: 1px solid var(--border-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        .gallery-item {
            transition: opacity 0.3s ease;
            cursor: pointer;
        }

        .gallery-item:hover {
            opacity: 0.9;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.8);
        }

        .modal-content {
            position: relative;
            margin: 5% auto;
            padding: 20px;
            max-width: 90%;
            max-height: 90vh;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .close {
            position: absolute;
            top: 15px;
            right: 15px;
            font-size: 24px;
            cursor: pointer;
        }

        .modal-image {
            width: 100%;
            max-height: 80vh;
            object-fit: contain;
        }

        .image-caption {
            margin-top: 15px;
            text-align: center;
            font-weight: 300;
        }

        .nav-button {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            font-size: 28px;
            cursor: pointer;
            padding: 10px;
            opacity: 0.7;
            transition: opacity 0.3s ease;
        }

        .nav-button:hover {
            opacity: 1;
        }

        .prev {
            left: 15px;
        }

        .next {
            right: 15px;
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="index.html" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- MENU
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4">
                    Photography
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6">
                    Gallery
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12">
                    A collection of moments captured through my lens. Click on any image to view it in full size.
                </p>
            </div>
        </section>

        <section id="gallery" class="mb-16">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
                <!-- Image 1 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(1)">
                    <img src="https://images.unsplash.com/photo-1504198322253-cfa87a0ff60f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Sunset cityscape" data-caption="Sunset over the city - Paris, 2023">
                </div>
                
                <!-- Image 2 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(2)">
                    <img src="https://images.unsplash.com/photo-1501785888041-af3ef285b470?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Mountain landscape" data-caption="Mountain range - Swiss Alps, 2022">
                </div>
                
                <!-- Image 3 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(3)">
                    <img src="https://images.unsplash.com/photo-1470252649378-9c29740c9fa8?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Sunset over field" data-caption="Golden hour in the countryside - Provence, 2023">
                </div>
                
                <!-- Image 4 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(4)">
                    <img src="https://images.unsplash.com/photo-1682687980961-78fa83781450?ixlib=rb-4.0.3&ixid=M3wxMjA3fDF8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2071&q=80" 
                         class="w-full h-full object-cover" alt="Ocean waves" data-caption="Ocean waves at sunset - Mediterranean Sea, 2022">
                </div>
                
                <!-- Image 5 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(5)">
                    <img src="https://images.unsplash.com/photo-1501854140801-50d01698950b?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2075&q=80" 
                         class="w-full h-full object-cover" alt="Night sky" data-caption="Stars over the mountain - Mont Blanc, 2021">
                </div>
                
                <!-- Image 6 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(6)">
                    <img src="https://images.unsplash.com/photo-1493246507139-91e8fad9978e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Forest path" data-caption="Morning light in the forest - Black Forest, 2022">
                </div>
                
                <!-- Image 7 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(7)">
                    <img src="https://images.unsplash.com/photo-1447752875215-b2761acb3c5d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Autumn forest" data-caption="Autumn colors - Ardennes, 2023">
                </div>
                
                <!-- Image 8 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(8)">
                    <img src="https://images.unsplash.com/photo-1507525428034-b723cf961d3e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2073&q=80" 
                         class="w-full h-full object-cover" alt="Beach sunset" data-caption="Sunset at the beach - Normandy, 2022">
                </div>
                
                <!-- Image 9 -->
                <div class="gallery-item aspect-square overflow-hidden" onclick="openModal();currentSlide(9)">
                    <img src="https://images.unsplash.com/photo-1470770841072-f978cf4d019e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="Mountain lake" data-caption="Reflections on the lake - Austrian Alps, 2021">
                </div>
            </div>
        </section>
    </main>

    <!-- Modal for fullscreen view -->
    <div id="imageModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            
            <!-- Modal images -->
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1504198322253-cfa87a0ff60f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Sunset cityscape">
                <div class="image-caption">Sunset over the city - Paris, 2023</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1501785888041-af3ef285b470?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Mountain landscape">
                <div class="image-caption">Mountain range - Swiss Alps, 2022</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1470252649378-9c29740c9fa8?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Sunset over field">
                <div class="image-caption">Golden hour in the countryside - Provence, 2023</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1682687980961-78fa83781450?ixlib=rb-4.0.3&ixid=M3wxMjA3fDF8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2071&q=80" 
                     class="modal-image" alt="Ocean waves">
                <div class="image-caption">Ocean waves at sunset - Mediterranean Sea, 2022</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1501854140801-50d01698950b?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2075&q=80" 
                     class="modal-image" alt="Night sky">
                <div class="image-caption">Stars over the mountain - Mont Blanc, 2021</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1493246507139-91e8fad9978e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Forest path">
                <div class="image-caption">Morning light in the forest - Black Forest, 2022</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1447752875215-b2761acb3c5d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Autumn forest">
                <div class="image-caption">Autumn colors - Ardennes, 2023</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1507525428034-b723cf961d3e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2073&q=80" 
                     class="modal-image" alt="Beach sunset">
                <div class="image-caption">Sunset at the beach - Normandy, 2022</div>
            </div>
            
            <div class="slides">
                <img src="https://images.unsplash.com/photo-1470770841072-f978cf4d019e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                     class="modal-image" alt="Mountain lake">
                <div class="image-caption">Reflections on the lake - Austrian Alps, 2021</div>
            </div>
            
            <!-- Navigation buttons -->
            <button class="nav-button prev" onclick="plusSlides(-1)">&#10094;</button>
            <button class="nav-button next" onclick="plusSlides(1)">&#10095;</button>
        </div>
    </div>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
        <p>All photos © Izhak. All rights reserved.</p>
    </footer>

    <script>
        // Modal functionality
        let slideIndex = 1;
        
        function openModal() {
            document.getElementById("imageModal").style.display = "block";
        }
        
        function closeModal() {
            document.getElementById("imageModal").style.display = "none";
        }
        
        function plusSlides(n) {
            showSlides(slideIndex += n);
        }
        
        function currentSlide(n) {
            showSlides(slideIndex = n);
        }
        
        function showSlides(n) {
            let i;
            let slides = document.getElementsByClassName("slides");
            
            if (n > slides.length) {slideIndex = 1}
            if (n < 1) {slideIndex = slides.length}
            
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            
            slides[slideIndex-1].style.display = "block";
        }
        
        // Close modal when clicking outside of content
        window.onclick = function(event) {
            let modal = document.getElementById("imageModal");
            if (event.target == modal) {
                closeModal();
            }
        }
        
        // Initialize slides
        document.addEventListener("DOMContentLoaded", function() {
            showSlides(slideIndex);
        });
        
        // Keyboard navigation
        document.addEventListener("keydown", function(e) {
            if (document.getElementById("imageModal").style.display === "block") {
                if (e.key === "ArrowLeft") {
                    plusSlides(-1);
                } else if (e.key === "ArrowRight") {
                    plusSlides(1);
                } else if (e.key === "Escape") {
                    closeModal();
                }
            }
        });
    </script>
</body>
</html>