<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy - AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">Privacy Policy</h1>
            <p class="text-sm">This document presents and is associated with the site where the link to this page was presented.</p>
        </header>

        <main>
            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Data Collection</h2>
                <p class="mb-6">
                    We collect minimal data necessary to improve user experience across our partner sites. This includes basic analytics and essential cookies. The data is collected by the <a class="underline italic" href="https://umami.is/">Umami service</a>
                </p>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Information Usage</h2>
                <ul class="space-y-4">
                    <li>Analytics for site improvement</li>
                    <li>Essential functionality</li>
                    <li>Advertising preferences</li>
                    <li>User experience optimization</li>
                </ul>
            </section>

            <section class="mb-12">
                <h2 class="text-2xl font-light mb-6">Your Rights</h2>
                <p class="mb-6">
                    You can manage your data preferences or request information about your data by contacting privacy@aktascorp.com
                </p>
            </section>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>