<?php
session_start();
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['emailContent'])) {
    $emailContent = $_POST['emailContent'];
    $bannerUrl = $_POST['bannerUrl'];
    $emailTitle = $_POST['emailTitle'];
    
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "From: Imators <no-reply@imators.com>\r\n";
    
    $template = '<!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="x-apple-disable-message-reformatting">
        <meta name="format-detection" content="telephone=no, address=no, email=no, date=no">
        <title>Imators Communication</title>
    </head>
    <body style="background-color: #1a1a1a; margin: 0; padding: 0; font-family: Arial, sans-serif; color: #ffffff;">
        <div style="max-width: 600px; margin: 0 auto; background-color: #262626;">
            <div style="padding: 20px; background-color: #000000;">
                <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 100%;">
                    <tr>
                        <td style="padding-left: 15px; border-left: 1px solid #333333; vertical-align: middle;">
                            <h1 style="margin: 0; font-size: 18px; color: #ffffff; line-height: 1.2;">Imators</h1>
                            <p style="margin: 5px 0 0 0; font-size: 12px; color: #888888; line-height: 1.2;">Official Communication</p>
                        </td>
                    </tr>
                </table>
            </div>
            ' . ($bannerUrl ? '<div style="width: 100%;"><img src="' . $bannerUrl . '" style="width: 100%; height: auto; display: block;"></div>' : '') . '
            ' . ($emailTitle ? '<div style="padding: 20px 30px 0 30px;"><h2 style="margin: 0; color: #ffffff; font-size: 24px;">' . $emailTitle . '</h2></div>' : '') . '
            <div style="padding: 30px; color: #ffffff; line-height: 1.5;">' . $emailContent . '</div>
            <div style="background-color: #1a1a1a; padding: 20px; text-align: center; border-top: 1px solid #333333;">
                <p style="margin: 0; color: #888888; font-size: 12px;">
                    This email was sent by an official Imators team member.<br>
                    © ' . date('Y') . ' Imators LLC. All rights reserved.
                </p>
                <div style="margin-top: 15px;">
                    <a href="https://imators.com" style="color: #888888; text-decoration: none; font-size: 12px;">imators.com</a>
                    <span style="color: #888888; margin: 0 10px;">|</span>
                    <a href="https://imators.com/privacy" style="color: #888888; text-decoration: none; font-size: 12px;">Privacy Policy</a>
                </div>
            </div>
        </div>
    </body>
    </html>';

    try {
        $stmt = $pdo->query("SELECT email FROM utilisateurs");
        $count = 0;
        
        while ($user = $stmt->fetch()) {
            if (mail($user['email'], $emailTitle ?: "Imators Communication", $template, $headers)) {
                $count++;
            }
        }
        
        $_SESSION['message'] = "Emails envoyés avec succès à " . $count . " utilisateurs.";
    } catch (PDOException $e) {
        $_SESSION['message'] = "Erreur lors de l'envoi des emails.";
    }
} else {
    $_SESSION['message'] = "Veuillez fournir un contenu pour l'email.";
}

header("Location: send-email.php");
exit;