<?php
session_start();
require_once 'db.php';

if (isset($_POST['submit'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    $query = $db->prepare("SELECT * FROM users WHERE email = :email");
    $query->execute(['email' => $email]);
    $user = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['email'] = $user['email'];
        header('Location: dashboard.php');
        exit();
    } else {
        $error = "Email ou mot de passe incorrect";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">
    <div class="max-w-4xl mx-auto px-4 py-20">
        <header class="mb-24">
            <h1 class="text-4xl font-light tracking-wider">aktascorp</h1>
            <p class="text-sm">to be there in everything.</p>
        </header>

        <main>
            <div class="max-w-md mx-auto">
                <h2 class="text-2xl font-light mb-6">Connexion</h2>
                
                <?php if (isset($error)): ?>
                    <div class="text-red-700 mb-4">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form action="" method="post">
                    <div class="mb-4">
                        <label for="email" class="block text-sm mb-1">Email</label>
                        <input type="email" id="email" name="email" required 
                            class="w-full px-3 py-2 border border-gray-300 bg-transparent rounded-md focus:outline-none">
                    </div>
                    
                    <div class="mb-6">
                        <label for="password" class="block text-sm mb-1">Mot de passe</label>
                        <input type="password" id="password" name="password" required 
                            class="w-full px-3 py-2 border border-gray-300 bg-transparent rounded-md focus:outline-none">
                    </div>
                    
                    <div>
                        <button type="submit" name="submit" 
                            class="w-full border border-gray-300 py-2 px-4 rounded-md hover:bg-gray-100 focus:outline-none">
                            Se connecter
                        </button>
                    </div>
                </form>
            </div>
        </main>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All right reserved. AktasCorp is a company registered in the United States. For any request or contact with a manager, please contact us at msg@aktascorp.com</p>
        </footer>
    </div>
</body>
</html>