<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AktasCorp</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background-color: #f9f0e6;
        }
    </style>
</head>
<body class="text-gray-800">

    <div class="max-w-4xl mx-auto px-4 py-20">
        <div class="relative rounded-lg overflow-hidden mb-12 h-64">
            <img src="font.png" alt="Banner" class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-opacity-30"></div>
            <div class="absolute left-8 top-1/2 transform -translate-y-1/2 text-white">
                <h1 class="text-4xl font-light tracking-wider">aktascorp</h1>
                <p class="text-sm">to be there in everything</p>
            </div>
        </div>

         <div class="p-8 rounded">
            <div class="space-y-3">
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light border-b border-gray-200 pb-2">
                    become a member of the group
                </a>
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light border-b border-gray-200 pb-2">
                    try Ise Engine
                </a>
                <a href="#" class="block text-gray-800 hover:text-gray-600 font-light">
                    contact aktascorp
                </a>
            </div>
        </div>

        <main>
            <section class="mb-12 items-center text-right">
                <h3 class="text-3xl mt-12">the company</h3>
                <p class="max-w-2xl">
                    Aktascorp is a group of all the companies held and created by Izhak Aktas. Each member company has the particularity of being modern and innovative for today's company by offering high-end services.
                </p>

                <h3 class="text-3xl mt-12">members</h3>
                <p class="max-w-2xl">
                    Companies or organisations offering quality and simplicity are generally welcome at AktasCorp. The new technology company called <a class="font-semibold" href="https://imators.com">Imators</a> is part of our group. Also a very pleasant neighbourhood called Vert Chasseur and <a class="font-semibold" href="https://vertchasseur.com">its site</a>, and without forgetting them, the <a class="font-semibold" href="https://peerkinton.com">Peerkinton</a> house, which offers private solutions dedicated to high-ranking neighbourhoods in several cities around the world.
                </p>

                <h3 class="text-3xl mt-12"><a href="/">academy -></a></h3>
                <p class="max-w-2xl">
                    aktascorp offers several development services as well as a dedicated space for its members. Minimum age is 14.
                </p>
            </section>
        </main>

        <div class="p-8 rounded">
            <blockquote class="border-l-4 border-gray-300 pl-6 py-4">
                <p class="text-xl font-light text-gray-700 mb-4">
                    "No matter how much you think about the money a project could generate, it will never help you actually create it. You have to believe in it and aim for it to be right, because then you'll be able to say: I created this, it works."                </p>
                <cite class="text-gray-500 text-sm">— Aktas Izhak</cite>
            </blockquote>
        </div>

        <footer class="mt-24 pt-6 border-t border-gray-200 text-sm text-gray-500">
            <p>&copy; 2025 AktasCorporation. All right reserved. AktasCorp is a company registered in the United States. For any request or contact with a manager, please contact us at msg@aktascorp.com</p>
        </footer>
    </div>

    <script>
        document.getElementById('menu-toggle').addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });
    </script>
</body>
</html>