<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Support</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            color: #f5f5f5;
        }
        
        .card-container {
            perspective: 1500px;
            height: 100%;
        }
        
        .card {
            position: relative;
            height: 100%;
            width: 100%;
            transform-style: preserve-3d;
            transition: transform 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        .card.flipped {
            transform: rotateY(180deg);
        }
        
        .card-front, .card-back {
            position: absolute;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            border-radius: 1rem;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .card-front {
            background: rgba(15, 15, 15, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .card-back {
            background: rgba(15, 15, 15, 0.9);
            transform: rotateY(180deg);
            border: 1px solid rgba(59, 130, 246, 0.3);
        }
        
        .card-btn {
            cursor: pointer;
            border: none;
            transition: all 0.3s ease;
        }
        
        .card-btn:hover {
            transform: translateY(-2px);
        }
        
        .card-content {
            flex-grow: 1;
        }
        
        @media (max-width: 640px) {
            .support-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (min-width: 641px) and (max-width: 1024px) {
            .support-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        @media (min-width: 1025px) {
            .support-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }
        
        .glass-effect {
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .text-shadow {
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
        }
        
        .blue-glow {
            box-shadow: 0 0 15px rgba(59, 130, 246, 0.5);
        }
        
        .hover-lift {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .hover-lift:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
<body class="min-h-screen">
    <?php include 'src/header.php'; ?>

    <main class="container mx-auto px-4 py-12 relative">
        <div class="max-w-6xl mx-auto">
            <!-- Hero Section -->
            <section class="text-center mb-16" data-aos="fade-up">
                <h1 class="text-5xl md:text-6xl font-light mb-6 text-white text-shadow">Support</h1>
                <p class="text-xl text-gray-300 max-w-3xl mx-auto">
                    Notre équipe est disponible 24/7 pour t'aider. Explore nos options de support ci-dessous.
                </p>
            </section>
            
            <!-- Support Grid -->
            <section class="grid support-grid gap-6 mb-16">
                <!-- Card 1 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="100">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-blue-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-blue-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Support clients</h2>
                                <p class="text-gray-300 mb-4">
                                    Une assistance dédiée et personnalisée pour tous nos clients disposant d'un compte Imators.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Support clients</h2>
                                <p class="text-gray-300 mb-4">
                                    Notre équipe de support client est disponible pour répondre à toutes tes questions concernant:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Problèmes techniques et dépannage</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Questions sur ton compte et facturation</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Assistance sur nos produits et services</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-blue-400 mr-2">•</span>
                                        <span>Suggestions et demandes d'amélioration</span>
                                    </li>
                                </ul>
                                <a href="https://idsma.imators.com" class="inline-block text-blue-400 hover:text-blue-300 underline mb-4">
                                    Accéder à ton espace ticket
                                </a>
                            </div>
                            <button class="card-btn w-full bg-blue-600 text-white py-4 rounded-lg font-medium hover:bg-blue-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 2 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="150">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-purple-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-purple-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Contact commercial</h2>
                                <p class="text-gray-300 mb-4">
                                    Pour toute demande professionnelle, de partenariat ou commerciale.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Contact commercial</h2>
                                <p class="text-gray-300 mb-4">
                                    Notre équipe commerciale est à ta disposition pour:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Des solutions personnalisées pour ton entreprise</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Établir des partenariats stratégiques</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Discuter des offres pour les professionnels</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-purple-400 mr-2">•</span>
                                        <span>Obtenir un devis sur mesure pour tes projets</span>
                                    </li>
                                </ul>
                                <p class="text-gray-300">
                                    Contacte-nous à 
                                    <a href="mailto:contact@imators.com" class="text-purple-400 hover:text-purple-300">
                                        contact@imators.com
                                    </a>
                                </p>
                            </div>
                            <button class="card-btn w-full bg-purple-600 text-white py-4 rounded-lg font-medium hover:bg-purple-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 3 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="200">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-green-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-green-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">FAQ</h2>
                                <p class="text-gray-300 mb-4">
                                    Réponses aux questions fréquemment posées par nos utilisateurs.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">FAQ</h2>
                                
                                <div class="space-y-4">
                                    <div>
                                        <h3 class="text-white font-medium">Comment créer un compte?</h3>
                                        <p class="text-gray-300">Rends-toi sur notre page d'inscription et suis les instructions pour créer ton compte personnalisé.</p>
                                    </div>
                                    
                                    <div>
                                        <h3 class="text-white font-medium">Comment réinitialiser mon mot de passe?</h3>
                                        <p class="text-gray-300">Clique sur "Mot de passe oublié" sur la page de connexion et suis les instructions envoyées par email.</p>
                                    </div>
                                    
                                    <div>
                                        <h3 class="text-white font-medium">Quel est le délai de réponse du support?</h3>
                                        <p class="text-gray-300">Notre équipe répond généralement dans les 24 heures ouvrables suivant ta demande.</p>
                                    </div>
                                </div>
                            </div>
                            <button class="card-btn w-full bg-green-600 text-white py-4 rounded-lg font-medium hover:bg-green-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 4 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="250">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-red-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-red-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Documentation</h2>
                                <p class="text-gray-300 mb-4">
                                    Guides détaillés et ressources pour utiliser nos produits efficacement.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Documentation</h2>
                                <p class="text-gray-300 mb-4">
                                    Notre documentation complète comprend:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-red-400 mr-2">•</span>
                                        <span>Guides d'utilisation étape par étape</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-red-400 mr-2">•</span>
                                        <span>Tutoriels vidéo explicatifs</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-red-400 mr-2">•</span>
                                        <span>Exemples de code et d'intégration</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-red-400 mr-2">•</span>
                                        <span>Bonnes pratiques et conseils d'optimisation</span>
                                    </li>
                                </ul>
                                <a href="/documentation" class="inline-block text-red-400 hover:text-red-300 underline">
                                    Consulter la documentation
                                </a>
                            </div>
                            <button class="card-btn w-full bg-red-600 text-white py-4 rounded-lg font-medium hover:bg-red-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 5 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="300">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-yellow-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-yellow-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Support technique</h2>
                                <p class="text-gray-300 mb-4">
                                    Résolution des problèmes techniques et assistance spécialisée.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Support technique</h2>
                                <p class="text-gray-300 mb-4">
                                    Notre équipe technique est disponible pour t'aider avec:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-yellow-400 mr-2">•</span>
                                        <span>Dépannage et résolution d'erreurs</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-yellow-400 mr-2">•</span>
                                        <span>Problèmes de connexion et d'accès</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-yellow-400 mr-2">•</span>
                                        <span>Erreurs système et bugs</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-yellow-400 mr-2">•</span>
                                        <span>Optimisation des performances</span>
                                    </li>
                                </ul>
                                <p class="text-gray-300">
                                    <a href="mailto:support@imators.com" class="text-yellow-400 hover:text-yellow-300">
                                        support@imators.com
                                    </a>
                                </p>
                            </div>
                            <button class="card-btn w-full bg-yellow-600 text-white py-4 rounded-lg font-medium hover:bg-yellow-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Card 6 -->
                <div class="h-96 card-container hover-lift" data-aos="fade-up" data-aos-delay="350">
                    <div class="card">
                        <div class="card-front p-6 border-t-4 border-indigo-500">
                            <div class="card-content">
                                <div class="h-12 w-12 bg-indigo-500 rounded-lg flex items-center justify-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                                    </svg>
                                </div>
                                <h2 class="text-2xl font-medium text-white mb-3">Formations</h2>
                                <p class="text-gray-300 mb-4">
                                    Sessions de formation et webinaires pour maîtriser nos solutions.
                                </p>
                            </div>
                            <button class="card-btn w-full bg-white text-black py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors">
                                Découvrir
                            </button>
                        </div>
                        <div class="card-back p-6">
                            <div class="card-content overflow-y-auto">
                                <h2 class="text-2xl font-medium text-white mb-4">Formations</h2>
                                <p class="text-gray-300 mb-4">
                                    Développe tes compétences avec nos formations:
                                </p>
                                <ul class="space-y-2 mb-4">
                                    <li class="flex items-start">
                                        <span class="text-indigo-400 mr-2">•</span>
                                        <span>Webinaires hebdomadaires pour tous niveaux</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-indigo-400 mr-2">•</span>
                                        <span>Sessions de formation personnalisées</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-indigo-400 mr-2">•</span>
                                        <span>Programme de certification Imators</span>
                                    </li>
                                    <li class="flex items-start">
                                        <span class="text-indigo-400 mr-2">•</span>
                                        <span>Bibliothèque de ressources d'apprentissage</span>
                                    </li>
                                </ul>
                                <a href="/trainings" class="inline-block text-indigo-400 hover:text-indigo-300 underline">
                                    Voir le calendrier des formations
                                </a>
                            </div>
                            <button class="card-btn w-full bg-indigo-600 text-white py-4 rounded-lg font-medium hover:bg-indigo-500 transition-colors">
                                Retour
                            </button>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Contact Banner -->
            <section class="mb-16" data-aos="fade-up">
                <div class="relative overflow-hidden rounded-2xl">
                    <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-8 md:p-12 blue-glow">
                        <div class="max-w-3xl mx-auto text-center text-white">
                            <h2 class="text-3xl font-medium mb-4">Besoin d'une assistance immédiate?</h2>
                            <p class="text-lg opacity-90 mb-8">
                                Notre équipe de support prioritaire est prête à intervenir rapidement pour résoudre tes problèmes urgents
                            </p>
                            <a href="mailto:urgentsupport@imators.com" class="inline-block bg-white text-blue-700 px-8 py-4 rounded-lg font-medium hover:bg-gray-100 transition-colors duration-300 shadow-lg">
                                Contacter le support d'urgence
                            </a>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Privacy Policy
                </a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Terms of Use
                </a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Home
                </a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    About Us
                </a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Contact Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
                <p class="text-sm">
                    All images, videos, and content on this site are the property of Imators.
                </p>
            </div>
        </div>

        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">
                &copy; 2025 Imators. All rights reserved.
            </p>
            <p class="text-xs">
                Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
            </p>
        </div>
    </footer>

    <script>
        // Initialisation de AOS (Animate On Scroll)
        AOS.init({
            duration: 800,
            once: true,
            offset: 100
        });
        
        // Script pour les cartes flip
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.card-container');
            
            cards.forEach(container => {
                const card = container.querySelector('.card');
                const frontBtn = container.querySelector('.card-front .card-btn');
                const backBtn = container.querySelector('.card-back .card-btn');
                
                frontBtn.addEventListener('click', () => {
                    card.classList.add('flipped');
                });
                
                backBtn.addEventListener('click', () => {
                    card.classList.remove('flipped');
                });
            });
        });
    </script>
</body>
</html>