<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Support</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        .bg-image {
            background-image: url('IMG_7530.JPG');
            background-size: cover;
            background-position: center;
            filter: brightness(0.6);
        }
        .reveal-header {
            opacity: 0;
            transform: translateY(20px);
            animation: revealHeader 0.8s ease forwards;
        }
        @keyframes revealHeader {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .text-gradient {
            background: linear-gradient(to right, #3B82F6, #2563EB);
            -webkit-background-clip: text;
            color: transparent;
        }
        .hover-scale {
            transition: transform 0.3s ease;
        }
        .hover-scale:hover {
            transform: scale(1.02);
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
        }
        .contact-email-banner {
            background: linear-gradient(90deg, #3B82F6 0%, #2563EB 100%);
            color: white;
            padding: 0.75rem 1rem;
            text-align: center;
            font-weight: 500;
            margin-bottom: 0;
        }
        .contact-email-link {
            color: white;
            font-weight: 600;
            text-decoration: underline;
            transition: opacity 0.2s ease;
        }
        .contact-email-link:hover {
            opacity: 0.9;
        }
        .faq-item {
            margin-bottom: 1rem;
        }
        .faq-question {
            cursor: pointer;
            padding: 1rem 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            text-align: left;
            background: transparent;
            border: none;
            border-bottom: 1px solid #333;
            color: #fff;
        }
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
            padding: 0 1rem;
            opacity: 0;
            transform: translateY(-10px);
        }
        .faq-answer.active {
            max-height: 300px;
            opacity: 1;
            transform: translateY(0);
            transition: all 0.3s ease-in;
            padding: 1rem;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <?php include 'src/header.php'; ?>

<section class="w-screen min-h-screen bg-black flex items-center justify-center p-8">
    <div class="max-w-4xl mx-auto space-y-16">
        <div class="text-center space-y-8">
            <h1 class="mt-24 text-6xl font-light text-white">Contact us for a professional request.</h1>
            <p class="text-xl text-gray-300">
                Our support team is available 24/7 to answer all your questions. 
                Simply reach out to us via email for assistance.
            </p>
        </div>

        <div class="grid gap-8">
            <div class="bg-white/5 backdrop-blur-lg border border-white/10 p-8 rounded-lg hover:scale-102 transition-transform duration-300">
                <h2 class="text-2xl text-white font-light mb-4">Support for our customers</h2>
                <p class="text-gray-300">
                    Customers with an Imators account can 
                    <a href="https://idsma.imators.com" class="text-blue-400 hover:text-blue-300 underline">
                        send requests to support via their ticket space.
                    </a>
                </p>
            </div>

            <div class="bg-white/5 backdrop-blur-lg border border-white/10 p-8 rounded-lg hover:scale-102 transition-transform duration-300">
                <h2 class="text-2xl text-white font-light mb-4">Commercial and professional contact</h2>
                <p class="text-gray-300">
                    Our team is available at 
                    <a href="mailto:contact@imators.com" class="text-blue-400 hover:text-blue-300">
                        contact@imators.com
                    </a>
                </p>
            </div>
        </div>
    </div>
</section>

   
    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div></footer>
    <script>
        AOS.init({
            duration: 800,
            once: true,
            offset: 100
        });
    </script>
</body>
</html>