<?php
require_once 'db.php';
$stmt = $pdo->prepare("SELECT * FROM dossiers WHERE statut = 'ouvert' ORDER BY date_ouverture DESC");
$stmt->execute();
$dossiers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Lord Court</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500&display=swap" rel="stylesheet">
    <style>
        .playfair {
            font-family: 'Playfair Display', serif;
        }
        .inter-light {
            font-family: 'Inter', sans-serif;
            font-weight: 300;
        }
        .inter-medium {
            font-family: 'Inter', sans-serif;
            font-weight: 500;
        }
    </style>
</head>
<body class="bg-white min-h-screen">
    <header class="bg-white/95 backdrop-blur-sm fixed top-0 left-0 right-0 z-50">
        <div class="max-w-4xl mx-auto px-6 py-8 text-center">
            <a href="/" class="playfair text-2xl tracking-wide text-black">THE LORD COURT</a>
        </div>
    </header>

    <main class="pt-32">
        <section class="max-w-3xl mx-auto px-6 py-20 text-center">
            <h2 class="playfair text-5xl mb-8 text-black leading-tight">Currently open files</h2>
            <p class="inter-light text-lg text-gray-500 leading-relaxed max-w-2xl mx-auto">
                Consult the list of cases currently being handled by the TLC
            </p>
        </section>

        <section class="max-w-6xl mx-auto px-6 pb-20">
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach($dossiers as $dossier): ?>
                <div class="group bg-white border border-gray-200 hover:border-black p-8 hover:bg-black hover:text-white transition-all duration-500 cursor-pointer" onclick="window.location.href='more-info.php?titre=<?php echo urlencode($dossier['titre']); ?>'">
                    <div class="mb-4">
                        <span class="inter-medium text-xs tracking-widest text-gray-400 group-hover:text-gray-300">
                            <?php echo date('d/m/Y', strtotime($dossier['date_ouverture'])); ?>
                        </span>
                    </div>
                    <h3 class="playfair text-xl mb-4 group-hover:text-white leading-tight">
                        <?php echo htmlspecialchars($dossier['titre']); ?>
                    </h3>
                    <div class="mb-6">
                        <div class="inter-light text-xs text-gray-500 group-hover:text-gray-300 mb-2">
                            <span class="inter-medium">Sectors:</span> <?php echo htmlspecialchars($dossier['secteurs']); ?>
                        </div>
                    </div>
                    <p class="inter-light text-sm text-gray-500 group-hover:text-gray-300 mb-8 leading-relaxed">
                        <?php echo htmlspecialchars(substr($dossier['description'], 0, 120)) . '...'; ?>
                    </p>
                    <div class="flex justify-end">
                        <div class="w-6 h-6 border border-gray-400 group-hover:border-white rounded-full flex items-center justify-center">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </section>
    </main>
</body>
</html>