<?php
require_once '../db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;

if ($id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid ID']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    $stmt = $pdo->prepare("SELECT * FROM medias WHERE dossier_id = ?");
    $stmt->execute([$id]);
    $medias = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($medias as $media) {
        if (file_exists($media['chemin'])) {
            unlink($media['chemin']);
        }
    }
    
    $stmt = $pdo->prepare("DELETE FROM medias WHERE dossier_id = ?");
    $stmt->execute([$id]);
    
    $stmt = $pdo->prepare("DELETE FROM logs WHERE dossier_id = ?");
    $stmt->execute([$id]);
    
    $stmt = $pdo->prepare("DELETE FROM dossiers WHERE id = ?");
    $stmt->execute([$id]);
    
    if ($stmt->rowCount() > 0) {
        $pdo->commit();
        echo json_encode(['success' => true]);
    } else {
        $pdo->rollback();
        echo json_encode(['success' => false, 'error' => 'Case not found']);
    }
    
} catch (Exception $e) {
    $pdo->rollback();
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Database error']);
}
?>