<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadre Image Dominante</title>
    <link href="https://fonts.googleapis.com/css2?family=Parkinsans:wght@300..800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
	.parkinsans {
  font-family: "Parkinsans", serif;
  font-style: normal;
}

        @keyframes zoomInPulse {
            0% { transform: scale(1.1); opacity: 0; }
            50% { transform: scale(1.05); opacity: 1; }
            100% { transform: scale(1); opacity: 1; }
        }
        @keyframes fadeInUpStrong {
            from { opacity: 0; transform: translateY(40px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-zoomInPulse { animation: zoomInPulse 1.5s ease-out forwards; }
        .animate-fadeInUpStrong { animation: fadeInUpStrong 0.8s ease-out forwards; }
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        .delay-500 { animation-delay: 0.5s; }
        #image-frame-overlay {
            position: fixed;
            inset: 0;
            z-index: 9999;
            background-color: rgba(0, 0, 0, 0.9);
        }
    </style>
</head>
<body class="h-screen overflow-hidden">
    <!-- Overlay du cadre image -->
    <div id="image-frame-overlay" class="flex items-center justify-center opacity-0 transition-opacity duration-700">
        <div id="image-frame" class="relative w-full h-full overflow-hidden animate-zoomInPulse">
            <!-- Image de fond responsive -->
            <img src="design45.webp" alt="Image de fond" class="absolute w-full h-full object-cover">
            
            <!-- Contenu superpos� -->
            <div class="absolute inset-0 flex flex-col justify-end p-6 sm:p-8 md:p-12 bg-gradient-to-t from-black via-black/70 to-transparent text-white">
                <!-- Label -->
                <p class="text-xs uppercase tracking-widest mb-2 sm:mb-3 opacity-0 animate-fadeInUpStrong delay-100">At 6.18pm on 25 December, Imators will present </p>
                
                <!-- Titre -->
                <h2 class="text-6xl parkinsans sm:text-5xl md:text-6xl lg:text-7xl mb-3 sm:mb-4 md:mb-6 opacity-0 animate-fadeInUpStrong delay-200 leading-tight">Academ</h2>
                
                <!-- Description -->
                <p class="text-lg sm:text-xl md:text-2xl mb-4 sm:mb-6 md:mb-8 max-w-3xl opacity-0 animate-fadeInUpStrong delay-300 leading-relaxed">Une plateforme pour trouver un tuteur de confiance en moins de 5 minutes, en toute sécurité, pour que vous puissiez enfin progresser à l'école avec la bonne personne.</p>
                
                <!-- Bouton -->
                <a href="/link" class="bg-white text-black py-3 px-6 sm:py-4 sm:px-8 md:px-10 rounded-full text-lg sm:text-xl font-bold hover:bg-gray-200 transition duration-300 transform hover:scale-105 w-max opacity-0 animate-fadeInUpStrong delay-400 shadow-lg">
                    Join the waiting list
                </a>
            </div>
            
            <!-- Bouton de fermeture -->
            <button onclick="closeImageFrame()" class="absolute top-4 right-4 sm:top-6 sm:right-6 md:top-8 md:right-8 text-white hover:text-gray-300 transition duration-300 opacity-0 animate-fadeInUpStrong delay-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 sm:h-10 sm:w-10 md:h-12 md:w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
    </div>
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        setTimeout(() => {
            const overlay = document.getElementById('image-frame-overlay');
            overlay.style.opacity = '1';
        }, 100);
    });

    function closeImageFrame() {
        const overlay = document.getElementById('image-frame-overlay');
        const imageFrame = document.getElementById('image-frame');
        imageFrame.style.transform = 'scale(1.1)';
        imageFrame.style.opacity = '0';
        overlay.style.opacity = '0';
        setTimeout(() => {
            overlay.style.display = 'none';
        }, 700);
    }
    </script>
</body>
</html>