<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.8.0/dist/alpine.min.js" defer></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        
        .gradient-background {
            background: rgb(34,193,195);
            background: linear-gradient(0deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
            color: #FFFFFF;
        }

        header {
            background-color: rgba(0, 0, 0, 0.8); 
            transition: background-color 0.5s;
        }
        .menu-link {
            transition: color 0.3s ease-in-out;
            color: #FFF !important; 
        }
        .footer, .mobile-menu {
            background-color: #111827;
            color: #FFF;
        }

        .coc {
            background-color: #111827;
        }

        .timeline {
            position: relative;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: 0;
            bottom: 0;
            width: 2px;
            background: #D1D5DB;
        }
        .timeline-item {
            position: relative;
            width: 100%;
            padding: 10px 40px;
            margin-bottom: 20px;
        }
        .timeline-marker {
            position: absolute;
            top: 15px;
            left: 50%;
            transform: translateX(-50%);
            height: 20px;
            width: 20px;
            border-radius: 50%;
            background: #3B82F6;
        }
        .timeline-content {
            max-width: 40%;
            padding: 20px;
            background: #F9FAFB;
            border-radius: 8px;
        }
        .timeline-item:nth-child(even) .timeline-content {
            margin-left: auto;
            background: #EFF6FF;
        }

        .parallax-container {
            perspective: 2px;
        }
        .parallax-background {
            transform: translateZ(-1px) scale(2);
            min-height: 100vh;
            background-size: cover;
            background-position: center;
        }
        .content {
            position: relative;
        }
        
        .fade-in-section {
            transition: opacity 0.6s ease-out, transform 1s ease-out;
            opacity: 0;
            transform: translateY(20px);
            visibility: hidden;
        }
        .fade-in-section.is-visible {
            opacity: 1;
            transform: none;
            visibility: visible;
        }

        @keyframes gradient {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }

        .gradient-bg {
            background: linear-gradient(-45deg, #6b1839, #1c4b82, #076b3b);
            background-size: 400% 400%;
            animation: gradient 15s ease infinite;
        }

        .rounded-image {
            border-radius: 1rem;
            overflow: hidden;
        }
    </style>
</head>
<body class="bg-black text-white">
<?php include 'src/header.php'; ?>
    <section class="py-20">
        <div class="container px-4 mx-auto">
            <div class="max-w-xl lg:max-w-2xl mx-auto text-center"></div>
        </div>
        <div class="h-96 mb-12 lg:mb-16">
            <img class="w-full h-full object-cover" src="banner.png" alt="">
        </div>
        <div class="container px-4 mx-auto">
            <div class="max-w-2xl mx-auto">
                <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Sinds de jaren 2000 wordt de technologische wereld gekenmerkt door een fase van opkomst en creatie van innovatieve en nieuwe technologie&euml;n, zoals de introductie van krachtige telefoons en computers, en de ontwikkeling van internationale netwerken. Dit tijdperk heeft onze manier van communiceren en wereldwijd interageren fundamenteel veranderd.
</p>
                <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Imators streeft ernaar om de tweede fase te cre&euml;ren die de wereld zal ervaren. Hoewel we vergezeld of voorafgegaan kunnen worden door anderen, blijft ons doel uniek: alomtegenwoordig zijn in alle aspecten van menselijke dagelijkse activiteiten terwijl we iets werkelijk waardevols brengen zonder mensen los te koppelen van de echte wereld. We streven ernaar technologie naadloos te integreren terwijl we menselijke authenticiteit en verbinding behouden.</p>
                <p class="text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">We richten ons op het implementeren van technologie in het dagelijks leven op een gunstige en evolutieve manier om een comfortabelere levensstijl mogelijk te maken, terwijl we de beheerders van ons eigen leven blijven en ervoor zorgen dat we ons niet laten controleren door machines. Onze visie benadrukt menselijke empowerment door technologie in plaats van afhankelijkheid ervan. Luiheid is een plaag die Imators wil tegengaan door een rijk van intellectuele geesten op te bouwen, waar iedereen het verdient om deel van uit te maken. We geloven in het bevorderen van actieve betrokkenheid en continu leren in onze technologische toekomst.​​​​​​​​​​​​​​​​</p>
            </div>
        </div>
    </section>

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        var swiper = new Swiper('.swiper-container', {
            slidesPerView: 1,
            spaceBetween: 30,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 40,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 50,
                },
            }
        });

        window.addEventListener('scroll', () => {
            document.querySelectorAll('.fade-in-section').forEach((el) => {
                const scrollY = window.scrollY + window.innerHeight;
                const elementTop = el.getBoundingClientRect().top + window.scrollY;
                const isVisible = scrollY > elementTop + 100;

                if (isVisible) {
                    el.classList.add('is-visible');
                }
            });
        });

        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            document.getElementById('mobile-menu').classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close').addEventListener('click', function() {
            document.getElementById('mobile-menu').classList.add('hidden');
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init();

        document.addEventListener("DOMContentLoaded", function() {
            const triggers = document.querySelectorAll('.slide-trigger');

            triggers.forEach(trigger => {
                trigger.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetId = this.getAttribute('href');
                    const targetElement = document.querySelector(targetId);
                    
                    if (targetElement) {
                        targetElement.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
        });
    </script>

<?php include 'src/footer.php'; ?>

</body>
</html>