<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="imators-verification" content="verified">
    <title>Imators Systems 1.7</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <style>
        * {
            font-family: 'Inter', sans-serif;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .glass-button {
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-in {
            animation: fadeIn 0.6s ease-out forwards;
        }
        .stagger-1 { animation-delay: 0.1s; opacity: 0; }
        .stagger-2 { animation-delay: 0.2s; opacity: 0; }
        .stagger-3 { animation-delay: 0.3s; opacity: 0; }
        .stagger-4 { animation-delay: 0.4s; opacity: 0; }
        .stagger-5 { animation-delay: 0.5s; opacity: 0; }
    </style>
</head>
<body class="bg-white text-black">
    
    <button onclick="toggleTheme()" class="glass-button fixed top-8 right-8 text-sm hover:opacity-80 z-50 px-4 py-2 rounded border">
        <span class="theme-text">Dark</span>
    </button>

    <div class="px-6 py-20">
        <div class="max-w-4xl mx-auto space-y-32">
            
            <div class="space-y-4 animate-in stagger-1">
                <div class="flex items-center gap-3 mb-8">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators" class="w-10 h-10">
                    <span class="text-base font-light">Imators Systems</span>
                </div>
                
                <h1 class="text-5xl md:text-6xl lg:text-7xl font-light leading-tight">
                    Secured creative<br>power.
                </h1>
                
                <p class="text-base text-gray-500 max-w-2xl leading-relaxed pt-4">
                    Enterprise management platform with advanced security protocols, optimised performance, and comprehensive project management tools
                </p>
            </div>
            
            <div class="max-w-3xl animate-in stagger-2">
                <div class="relative">
                    <div id="pathStatus" class="absolute -top-8 left-0 text-xs opacity-0"></div>
                    <div class="relative border border-gray-300 focus-within:border-black hover:border-gray-400">
                        <input type="text" 
                               id="pathInput"
                               class="w-full bg-transparent border-none outline-none py-5 px-6 pr-24 text-base placeholder-gray-400"
                               placeholder="Enter project folder path"
                               oninput="checkPath()"
                               onkeydown="if(event.key === 'Enter') searchOrRedirect()">
                        <button class="absolute right-3 top-3 bottom-3 bg-black text-white px-8 text-sm hover:opacity-80"
                                onclick="searchOrRedirect()">
                            →
                        </button>
                    </div>
                    <p class="text-xs text-gray-400 mt-3">Press / to focus • Enter to navigate</p>
                </div>
            </div>
            
            <div class="space-y-24">
                <div class="animate-in stagger-3">
                    <h2 class="text-2xl font-light mb-12">Core Features</h2>
                    <div class="grid md:grid-cols-3 gap-16">
                        <div class="space-y-3 hover:transform hover:-translate-y-1">
                            <div class="text-lg font-light">Enterprise Security</div>
                            <p class="text-sm text-gray-500 leading-relaxed">Advanced multi-layer protection with real-time threat monitoring and encrypted communications</p>
                        </div>
                        
                        <div class="space-y-3 hover:transform hover:-translate-y-1">
                            <div class="text-lg font-light">High Performance</div>
                            <p class="text-sm text-gray-500 leading-relaxed">Lightning-fast infrastructure with global CDN and optimised server architecture</p>
                        </div>
                        
                        <div class="space-y-3 hover:transform hover:-translate-y-1">
                            <div class="text-lg font-light">24/7 Support</div>
                            <p class="text-sm text-gray-500 leading-relaxed">Dedicated technical assistance with expert engineers available around the clock</p>
                        </div>
                    </div>
                </div>

                <div class="animate-in stagger-4">
                    <h2 class="text-2xl font-light mb-12">Technical Stack</h2>
                    <div class="grid md:grid-cols-2 gap-12">
                        <div class="space-y-6">
                            <div class="space-y-2 hover:transform hover:translate-x-1">
                                <div class="text-sm font-light">Infrastructure</div>
                                <p class="text-sm text-gray-500 leading-relaxed">Multi-region cloud architecture with automated failover and load balancing across global data centers</p>
                            </div>
                            
                            <div class="space-y-2 hover:transform hover:translate-x-1">
                                <div class="text-sm font-light">Security Protocols</div>
                                <p class="text-sm text-gray-500 leading-relaxed">End-to-end encryption, two-factor authentication, and continuous security audits</p>
                            </div>
                        </div>
                        
                        <div class="space-y-6">
                            <div class="space-y-2 hover:transform hover:translate-x-1">
                                <div class="text-sm font-light">Performance</div>
                                <p class="text-sm text-gray-500 leading-relaxed">Sub-100ms response times with intelligent caching and optimised database queries</p>
                            </div>
                            
                            <div class="space-y-2 hover:transform hover:translate-x-1">
                                <div class="text-sm font-light">Scalability</div>
                                <p class="text-sm text-gray-500 leading-relaxed">Horizontal scaling capabilities handling millions of concurrent users seamlessly</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="animate-in stagger-5">
                    <h2 class="text-2xl font-light mb-12">Changelog</h2>
                    <div class="space-y-8 border-l-2 border-gray-200 pl-8">
                        <div class="relative hover:transform hover:translate-x-2">
                            <div class="absolute -left-[33px] w-2 h-2 rounded-full bg-black"></div>
                            <div class="space-y-2">
                                <div class="flex items-center gap-3">
                                    <span class="text-sm font-light">Version 1.7</span>
                                    <span class="text-xs text-gray-400">October 2025</span>
                                </div>
                                <p class="text-sm text-gray-500 leading-relaxed">Enhanced security protocols with real-time path validations and implementations of the Can algorithm</p>
                            </div>
                        </div>

                        <div class="relative hover:transform hover:translate-x-2">
                            <div class="absolute -left-[33px] w-2 h-2 rounded-full bg-gray-400"></div>
                            <div class="space-y-2">
                                <div class="flex items-center gap-3">
                                    <span class="text-sm font-light">Version 1.6</span>
                                    <span class="text-xs text-gray-400">September 2025</span>
                                </div>
                                <p class="text-sm text-gray-500 leading-relaxed">Performance optimisation with sub-100ms response times and global CDN integration</p>
                            </div>
                        </div>

                        <div class="relative hover:transform hover:translate-x-2">
                            <div class="absolute -left-[33px] w-2 h-2 rounded-full bg-gray-400"></div>
                            <div class="space-y-2">
                                <div class="flex items-center gap-3">
                                    <span class="text-sm font-light">Version 1.5</span>
                                    <span class="text-xs text-gray-400">August 2025</span>
                                </div>
                                <p class="text-sm text-gray-500 leading-relaxed">Introduction of dark mode with adaptive theming and improved accessibility features</p>
                            </div>
                        </div>

                        <div class="relative hover:transform hover:translate-x-2">
                            <div class="absolute -left-[33px] w-2 h-2 rounded-full bg-gray-400"></div>
                            <div class="space-y-2">
                                <div class="flex items-center gap-3">
                                    <span class="text-sm font-light">Version 1.4</span>
                                    <span class="text-xs text-gray-400">July 2025</span>
                                </div>
                                <p class="text-sm text-gray-500 leading-relaxed">Multi-region architecture deployment and enhanced load balancing capabilities</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray-300 pt-12 flex flex-col md:flex-row justify-between items-start md:items-center gap-8">
                <div class="space-y-4">
                    <a href="/become-client" class="text-sm text-gray-400 hover:text-black inline-flex items-center gap-2">
                        Become a Client <span>→</span>
                    </a>
                    <div class="flex gap-6 text-xs text-gray-400">
                        <a href="/documentation" class="hover:text-black">Documentation</a>
                        <a href="https://imators.com/support" class="hover:text-black">Support</a>
                        <a href="https://imators.statuspage.io/" class="hover:text-black">System Status</a>
                    </div>
                </div>
                <div class="text-xs text-gray-400">
                    Version 1.7 • © 2025 Imators
                </div>
            </div>
            
        </div>
    </div>

    <script>
    let checkTimeout;
    
    async function checkPath() {
        const input = document.getElementById('pathInput');
        const status = document.getElementById('pathStatus');
        const value = input.value.trim();
        
        clearTimeout(checkTimeout);
        
        if(!value) {
            status.style.opacity = '0';
            return;
        }
        
        status.style.opacity = '1';
        status.textContent = 'Checking...';
        status.style.color = '#9ca3af';
        
        checkTimeout = setTimeout(async () => {
            try {
                const response = await fetch('https://imators.systems/' + value, {
                    method: 'HEAD'
                });
                
                if(response.ok) {
                    status.textContent = '✓ Path exists';
                    status.style.color = '#10b981';
                } else {
                    status.textContent = '✗ Path not found';
                    status.style.color = '#ef4444';
                }
            } catch(e) {
                status.textContent = '✗ Path not found';
                status.style.color = '#ef4444';
            }
        }, 500);
    }

    function updateGlassButton() {
        const button = document.querySelector('.glass-button');
        const isDark = document.body.classList.contains('dark-mode');
        
        if(isDark) {
            button.style.backgroundColor = 'rgba(255, 255, 255, 0.1)';
            button.style.borderColor = 'rgba(255, 255, 255, 0.2)';
            button.style.color = 'white';
        } else {
            button.style.backgroundColor = 'rgba(0, 0, 0, 0.05)';
            button.style.borderColor = 'rgba(0, 0, 0, 0.1)';
            button.style.color = 'black';
        }
    }

    function toggleTheme() {
        const body = document.body;
        const themeText = document.querySelector('.theme-text');
        
        if(body.classList.contains('dark-mode')) {
            body.classList.remove('dark-mode');
            body.style.backgroundColor = 'white';
            body.style.color = 'black';
            themeText.textContent = 'Dark';
            document.querySelectorAll('.border-gray-300, .border-gray-200').forEach(el => {
                el.style.borderColor = el.classList.contains('border-gray-200') ? '#e5e7eb' : '#d1d5db';
            });
            document.querySelectorAll('.text-gray-500').forEach(el => {
                el.style.color = '#6b7280';
            });
            document.querySelectorAll('.text-gray-400').forEach(el => {
                el.style.color = '#9ca3af';
            });
            document.querySelectorAll('.bg-gray-400').forEach(el => {
                el.style.backgroundColor = '#9ca3af';
            });
            document.querySelectorAll('.bg-black').forEach(el => {
                if(!el.classList.contains('glass-button')) {
                    el.style.backgroundColor = 'black';
                }
            });
            document.querySelectorAll('input').forEach(el => {
                el.style.color = 'black';
            });
            document.querySelectorAll('button:not(.glass-button)').forEach(el => {
                if(el.classList.contains('bg-black')) {
                    el.style.backgroundColor = 'black';
                    el.style.color = 'white';
                }
            });
            localStorage.setItem('theme', 'light');
        } else {
            body.classList.add('dark-mode');
            body.style.backgroundColor = 'black';
            body.style.color = 'white';
            themeText.textContent = 'Light';
            document.querySelectorAll('.border-gray-300, .border-gray-200').forEach(el => {
                el.style.borderColor = '#333';
            });
            document.querySelectorAll('.text-gray-500').forEach(el => {
                el.style.color = '#888';
            });
            document.querySelectorAll('.text-gray-400').forEach(el => {
                el.style.color = '#666';
            });
            document.querySelectorAll('.bg-gray-400').forEach(el => {
                el.style.backgroundColor = '#666';
            });
            document.querySelectorAll('.bg-black').forEach(el => {
                if(!el.classList.contains('glass-button')) {
                    el.style.backgroundColor = 'white';
                }
            });
            document.querySelectorAll('input').forEach(el => {
                el.style.color = 'white';
            });
            document.querySelectorAll('button:not(.glass-button)').forEach(el => {
                if(el.classList.contains('bg-black')) {
                    el.style.backgroundColor = 'white';
                    el.style.color = 'black';
                }
            });
            localStorage.setItem('theme', 'dark');
        }
        
        updateGlassButton();
    }

    if(localStorage.getItem('theme') === 'dark') {
        toggleTheme();
    } else {
        updateGlassButton();
    }

    function searchOrRedirect() {
        const value = document.querySelector('input').value.trim();
        if(value) {
            window.location.href = 'https://imators.systems/' + value;
        }
    }

    window.addEventListener('load', () => {
        setTimeout(() => {
            document.querySelector('input').focus();
        }, 1000);
    });

    document.addEventListener('keydown', (e) => {
        if(e.key === '/' && e.target.tagName !== 'INPUT') {
            e.preventDefault();
            document.querySelector('input').focus();
        }
    });
    </script>
</body>
</html>