import * as _heroui_theme from '@heroui/theme';
import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps } from '@heroui/system';
import { DateValue, AriaRangeCalendarProps } from '@react-types/calendar';
import { RangeCalendarState } from '@react-stately/calendar';
import { ContextType, UseCalendarBaseProps } from './use-calendar-base.js';
import { CalendarBaseProps } from './calendar-base.js';
import '@react-types/shared';
import '@internationalized/date';
import '@react-aria/calendar';
import '@react-types/button';
import '@heroui/button';
import '@heroui/react-utils';
import 'react/jsx-runtime';

type HeroUIBaseProps<T extends DateValue> = Omit<HTMLHeroUIProps<"div">, keyof AriaRangeCalendarProps<T>>;
interface Props<T extends DateValue> extends UseCalendarBaseProps, HeroUIBaseProps<T> {
}
type UseRangeCalendarProps<T extends DateValue> = Props<T> & AriaRangeCalendarProps<T>;
declare function useRangeCalendar<T extends DateValue>({ buttonPickerProps: buttonPickerPropsProp, className, ...originalProps }: UseRangeCalendarProps<T>): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    domRef: react.RefObject<HTMLDivElement>;
    context: ContextType<RangeCalendarState>;
    state: RangeCalendarState;
    slots: {
        base: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    title: string;
    classNames: _heroui_theme.SlotsToClasses<"header" | "title" | "content" | "gridWrapper" | "grid" | "gridHeader" | "gridHeaderRow" | "gridHeaderCell" | "gridBody" | "gridBodyRow" | "cell" | "pickerWrapper" | "pickerMonthList" | "pickerYearList" | "pickerHighlight" | "helperWrapper" | "errorMessage" | "base" | "prevButton" | "nextButton" | "headerWrapper" | "cellButton" | "pickerItem"> | undefined;
    getBaseCalendarProps: (props?: {}) => CalendarBaseProps;
};
type UseRangeCalendarReturn = ReturnType<typeof useRangeCalendar>;

export { type UseRangeCalendarProps, type UseRangeCalendarReturn, useRangeCalendar };
