"use client";

// src/use-input-otp.ts
import { mapPropsVariants, useProviderContext } from "@heroui/system";
import { inputOtp } from "@heroui/theme";
import { filterDOMProps, useDOMRef } from "@heroui/react-utils";
import { clsx, dataAttr, objectToDeps, isPatternNumeric } from "@heroui/shared-utils";
import { useCallback, useMemo } from "react";
import { chain, mergeProps, useFormReset } from "@react-aria/utils";
import { useControlledState } from "@react-stately/utils";
import { useFormValidationState } from "@react-stately/form";
import { useFormValidation } from "@react-aria/form";
import { useFocusRing } from "@react-aria/focus";
import { FormContext, useSlottedContext } from "@heroui/form";
function useInputOtp(originalProps) {
  var _a, _b, _c, _d;
  const globalContext = useProviderContext();
  const { validationBehavior: formValidationBehavior } = useSlottedContext(FormContext) || {};
  const [props, variantProps] = mapPropsVariants(originalProps, inputOtp.variantKeys);
  const {
    ref,
    baseRef,
    as,
    className,
    classNames,
    length = 4,
    autoFocus,
    "aria-label": ariaLabel = "One-time password input",
    onValueChange = () => {
    },
    allowedKeys = "^[0-9]*$",
    validationBehavior = (_a = formValidationBehavior != null ? formValidationBehavior : globalContext == null ? void 0 : globalContext.validationBehavior) != null ? _a : "native",
    type,
    name,
    maxLength,
    minLength,
    textAlign = "center",
    onComplete = () => {
    },
    pushPasswordManagerStrategy,
    pasteTransformer,
    containerClassName,
    noScriptCSSFallback,
    onChange,
    inputMode,
    ...otherProps
  } = props;
  const Component = as || "div";
  const inputRef = useDOMRef(ref);
  const baseDomRef = useDOMRef(baseRef);
  const { isFocusVisible, isFocused, focusProps } = useFocusRing({
    autoFocus,
    isTextInput: true
  });
  const handleValueChange = useCallback(
    (value2) => {
      onValueChange(value2 != null ? value2 : "");
    },
    [onValueChange]
  );
  const [value, setValue] = useControlledState(
    props.value,
    (_b = props.defaultValue) != null ? _b : "",
    handleValueChange
  );
  const disableAnimation = (_d = (_c = originalProps.disableAnimation) != null ? _c : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _d : false;
  const isDisabled = originalProps.isDisabled;
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  const validationState = useFormValidationState({
    ...props,
    validationBehavior,
    value
  });
  useFormReset(inputRef, value, setValue);
  useFormValidation({ ...props, validationBehavior }, validationState, inputRef);
  const {
    isInvalid: isAriaInvalid,
    validationErrors,
    validationDetails
  } = validationState.displayValidation;
  const isReadOnly = originalProps.isReadOnly;
  const isRequired = originalProps.isRequired;
  const isInvalid = originalProps.isInvalid || isAriaInvalid;
  const errorMessage = typeof props.errorMessage === "function" ? props.errorMessage({ isInvalid, validationErrors, validationDetails }) : props.errorMessage || (validationErrors == null ? void 0 : validationErrors.join(" "));
  const description = props.description;
  const hasHelper = !!description || !!errorMessage;
  const slots = useMemo(
    () => inputOtp({
      ...variantProps,
      disableAnimation,
      isInvalid,
      isReadOnly
    }),
    [objectToDeps(variantProps), disableAnimation, isInvalid, isReadOnly]
  );
  const getBaseProps = useCallback(
    (props2 = {}) => {
      return {
        ref: baseDomRef,
        className: slots.base({
          class: baseStyles
        }),
        "data-slot": "base",
        "data-disabled": dataAttr(isDisabled),
        "data-invalid": dataAttr(isInvalid),
        "data-required": dataAttr(originalProps == null ? void 0 : originalProps.isRequired),
        "data-readonly": dataAttr(originalProps == null ? void 0 : originalProps.isReadOnly),
        "data-filled": dataAttr(value.length === length),
        "aria-label": ariaLabel,
        "aria-required": dataAttr(originalProps.isRequired),
        "aria-readonly": dataAttr(originalProps == null ? void 0 : originalProps.isReadOnly),
        role: "base",
        ...mergeProps(
          filterDOMProps(otherProps, {
            enabled: true
          }),
          filterDOMProps(props2)
        ),
        onChange: (e) => {
          var _a2;
          const val = (_a2 = e.target) == null ? void 0 : _a2.value;
          const regex = new RegExp(allowedKeys);
          if (regex.test(val)) {
            onChange == null ? void 0 : onChange(e);
          }
        }
      };
    },
    [baseDomRef, slots, baseStyles, isDisabled, isInvalid, isRequired, isReadOnly, value, length]
  );
  const getInputOtpProps = useCallback(
    (props2 = {}) => {
      var _a2;
      const otpProps = {
        ...focusProps,
        required: isRequired,
        disabled: isDisabled,
        readOnly: isReadOnly,
        pattern: allowedKeys,
        maxLength: maxLength != null ? maxLength : length,
        minLength: minLength != null ? minLength : length,
        textAlign,
        ref: inputRef,
        name,
        value,
        autoFocus,
        onChange: setValue,
        onBlur: chain(focusProps.onBlur, props2 == null ? void 0 : props2.onBlur),
        onComplete,
        pushPasswordManagerStrategy,
        pasteTransformer,
        noScriptCSSFallback,
        inputMode: inputMode != null ? inputMode : isPatternNumeric(allowedKeys) ? "numeric" : "text",
        containerClassName: (_a2 = slots.wrapper) == null ? void 0 : _a2.call(slots, { class: clsx(classNames == null ? void 0 : classNames.wrapper, containerClassName) }),
        ...props2
      };
      return otpProps;
    },
    [
      inputMode,
      isRequired,
      isDisabled,
      isReadOnly,
      allowedKeys,
      inputRef,
      name,
      value,
      length,
      setValue,
      props.onBlur,
      onComplete,
      autoFocus
    ]
  );
  const getSegmentWrapperProps = useCallback(
    (props2 = {}) => {
      return {
        className: slots.segmentWrapper({
          class: clsx(classNames == null ? void 0 : classNames.segmentWrapper, props2 == null ? void 0 : props2.className)
        }),
        "data-slot": "segment-wrapper",
        "data-disabled": dataAttr(isDisabled),
        "aria-label": ariaLabel,
        ...props2
      };
    },
    [classNames == null ? void 0 : classNames.segmentWrapper, isDisabled]
  );
  const getHelperWrapperProps = useCallback(
    (props2 = {}) => {
      return {
        className: slots.helperWrapper({
          class: clsx(classNames == null ? void 0 : classNames.helperWrapper, props2 == null ? void 0 : props2.className)
        }),
        "data-slot": "helper-wrapper",
        ...props2
      };
    },
    [classNames == null ? void 0 : classNames.helperWrapper]
  );
  const getErrorMessageProps = useCallback(
    (props2 = {}) => {
      return {
        className: slots.errorMessage({
          class: clsx(classNames == null ? void 0 : classNames.errorMessage, props2 == null ? void 0 : props2.className)
        }),
        "data-slot": "error-message",
        ...props2
      };
    },
    [classNames == null ? void 0 : classNames.errorMessage]
  );
  const getDescriptionProps = useCallback(
    (props2 = {}) => {
      return {
        className: slots.description({
          class: clsx(classNames == null ? void 0 : classNames.description, props2 == null ? void 0 : props2.className)
        }),
        "data-slot": "description",
        ...props2
      };
    },
    [classNames == null ? void 0 : classNames.description]
  );
  return {
    Component,
    inputRef,
    length,
    value,
    type,
    slots,
    hasHelper,
    classNames,
    isInvalid,
    description,
    errorMessage,
    isFocusVisible,
    isFocused,
    getBaseProps,
    getInputOtpProps,
    getSegmentWrapperProps,
    getHelperWrapperProps,
    getErrorMessageProps,
    getDescriptionProps
  };
}

export {
  useInputOtp
};
